/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupContract;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
public class GroupServiceTest
extends KIMTestCase {
    private GroupService groupService;

    public void setUp() throws Exception {
        super.setUp();
        this.setGroupService(KimApiServiceLocator.getGroupService());
    }

    @Test
    public void testGetGroup() {
        Group g7 = this.groupService.getGroup("g7");
        Assert.assertNotNull((Object)g7);
        Assert.assertEquals((Object)"GroupSeven", (Object)g7.getName());
        Assert.assertEquals((Object)"KUALI", (Object)g7.getNamespaceCode());
        Assert.assertEquals((Object)"Group Seven", (Object)g7.getDescription());
        Group g8 = this.groupService.getGroup("g8");
        Assert.assertNotNull((Object)g8);
        Assert.assertEquals((Object)"GroupEight", (Object)g8.getName());
        Assert.assertEquals((Object)"KUALI", (Object)g8.getNamespaceCode());
        Assert.assertEquals((Object)"Group Eight", (Object)g8.getDescription());
    }

    @Test
    public void testGetDirectMemberGroupIds() {
        List groupIds = this.groupService.getDirectMemberGroupIds("g1");
        Assert.assertTrue((String)"g1 must contain group g2", (boolean)groupIds.contains("g2"));
        Assert.assertFalse((String)"g1 must not contain group g3", (boolean)groupIds.contains("g3"));
        groupIds = this.groupService.getDirectMemberGroupIds("g2");
        Assert.assertTrue((String)"g2 must contain group g3", (boolean)groupIds.contains("g3"));
        Assert.assertFalse((String)"g2 must not contain group g4 (inactive)", (boolean)groupIds.contains("g4"));
    }

    @Test
    public void testGetMemberGroupIds() {
        List groupIds = this.groupService.getMemberGroupIds("g1");
        Assert.assertTrue((String)"g1 must contain group g2", (boolean)groupIds.contains("g2"));
        Assert.assertTrue((String)"g1 must contain group g3", (boolean)groupIds.contains("g3"));
        Assert.assertFalse((String)"g1 must not contain group g4 (inactive)", (boolean)groupIds.contains("g4"));
        groupIds = this.groupService.getMemberGroupIds("g2");
        Assert.assertTrue((String)"g2 must contain group g3", (boolean)groupIds.contains("g3"));
        Assert.assertFalse((String)"g2 must not contain group g1", (boolean)groupIds.contains("g1"));
    }

    @Test
    public void testPrincipalMembership() {
        Assert.assertTrue((String)"p1 must be in g2", (boolean)this.groupService.isMemberOfGroup("p1", "g2"));
        Assert.assertTrue((String)"p1 must be direct member of g2", (boolean)this.groupService.isDirectMemberOfGroup("p1", "g2"));
        Assert.assertTrue((String)"p3 must be in g2", (boolean)this.groupService.isMemberOfGroup("p3", "g2"));
        Assert.assertFalse((String)"p3 should not be a direct member of g2", (boolean)this.groupService.isDirectMemberOfGroup("p3", "g2"));
        Assert.assertFalse((String)"p4 should not be reported as a member of g2 (g4 is inactive)", (boolean)this.groupService.isMemberOfGroup("p4", "g2"));
        Group g4Info = this.groupService.getGroup("g4");
        Group.Builder builder = Group.Builder.create((GroupContract)g4Info);
        builder.setActive(true);
        Group ug = this.groupService.updateGroup("g4", builder.build());
        Assert.assertTrue((boolean)ug.isActive());
        Group gg = this.groupService.getGroup("g4");
        Assert.assertTrue((boolean)gg.isActive());
        Assert.assertTrue((String)"p4 should be reported as a member of g2 (now that g4 is active)", (boolean)this.groupService.isMemberOfGroup("p4", "g2"));
        builder = Group.Builder.create((GroupContract)gg);
        builder.setActive(false);
        this.groupService.updateGroup(builder.build());
        Assert.assertFalse((String)"p4 should be reported as a member of g2 (now that g4 is active)", (boolean)this.groupService.isMemberOfGroup("p4", "g2"));
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }
}

