/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.component.Component;
import org.kuali.rice.coreservice.api.component.ComponentService;
import org.kuali.rice.coreservice.impl.component.ComponentBo;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.test.KRADTestCase;

public class ComponentServiceTest
extends KRADTestCase {
    private ComponentService componentService;

    @Before
    public void establishComponentService() {
        this.componentService = CoreServiceApiServiceLocator.getComponentService();
        Assert.assertNotNull((String)"Failed to locate ComponentService", (Object)this.componentService);
    }

    @Test
    public void testGetComponentByCode() {
        Assert.assertNull((Object)this.componentService.getComponentByCode("blah", "blah"));
        Component component = this.componentService.getComponentByCode("KR-WKFLW", "DocumentSearch");
        Assert.assertNotNull((Object)component);
        Assert.assertTrue((boolean)component.isActive());
    }

    @Test
    public void testGetAllComponentsByNamespaceCode() {
        List components = this.componentService.getAllComponentsByNamespaceCode("blah");
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)0L, (long)components.size());
        components = this.componentService.getAllComponentsByNamespaceCode("KR-NS");
        Assert.assertEquals((long)7L, (long)components.size());
        ComponentBo scheduleStepComponent = null;
        for (Component component : components) {
            Assert.assertTrue((String)("Component should have been active: " + component), (boolean)component.isActive());
            if (!component.getCode().equals("ScheduleStep")) continue;
            scheduleStepComponent = ComponentBo.from((Component)component);
        }
        Assert.assertNotNull((String)"Failed to locate schedule step component", scheduleStepComponent);
        scheduleStepComponent.setActive(false);
        KRADServiceLocator.getBusinessObjectService().save(scheduleStepComponent);
        components = this.componentService.getAllComponentsByNamespaceCode("KR-NS");
        Assert.assertEquals((long)7L, (long)components.size());
        int numActive = 0;
        int numInactive = 0;
        for (Component component : components) {
            if (component.isActive()) {
                ++numActive;
                continue;
            }
            ++numInactive;
        }
        Assert.assertEquals((long)6L, (long)numActive);
        Assert.assertEquals((long)1L, (long)numInactive);
    }

    @Test
    public void testGetActiveComponentsByNamespaceCode() {
        List components = this.componentService.getActiveComponentsByNamespaceCode("blah");
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)0L, (long)components.size());
        components = this.componentService.getActiveComponentsByNamespaceCode("KR-NS");
        Assert.assertEquals((long)7L, (long)components.size());
        ComponentBo scheduleStepComponent = null;
        for (Component component : components) {
            Assert.assertTrue((String)("Component should have been active: " + component), (boolean)component.isActive());
            if (!component.getCode().equals("ScheduleStep")) continue;
            scheduleStepComponent = ComponentBo.from((Component)component);
        }
        Assert.assertNotNull((String)"Failed to locate schedule step component", scheduleStepComponent);
        scheduleStepComponent.setActive(false);
        KRADServiceLocator.getBusinessObjectService().save(scheduleStepComponent);
        components = this.componentService.getActiveComponentsByNamespaceCode("KR-NS");
        Assert.assertEquals((long)6L, (long)components.size());
        for (Component component : components) {
            Assert.assertTrue((String)("Component should have been active: " + component), (boolean)component.isActive());
        }
    }

    @Test
    public void testPublishComponents_and_getPublishedComponentSet() {
        String testComponentSetId = "testComponentSet";
        String workflowNamespace = "KR-WKFLW";
        String testNamespace1 = "TestNamespace1";
        String testNamespace2 = "TestNamespace2";
        List testComponentSet = this.componentService.getDerivedComponentSet(testComponentSetId);
        Assert.assertTrue((String)"Initial testComponentSet should be empty", (boolean)testComponentSet.isEmpty());
        List workflowComponents = this.componentService.getAllComponentsByNamespaceCode(workflowNamespace);
        Assert.assertFalse((String)("There should be some components for the " + workflowNamespace + " namespace"), (boolean)workflowComponents.isEmpty());
        Assert.assertTrue((boolean)this.componentService.getAllComponentsByNamespaceCode(testNamespace1).isEmpty());
        Assert.assertTrue((boolean)this.componentService.getAllComponentsByNamespaceCode(testNamespace2).isEmpty());
        String customTestWorkflowComponent = "CustomTestWorkflowComponent";
        Component component1 = Component.Builder.create((String)workflowNamespace, (String)customTestWorkflowComponent, (String)customTestWorkflowComponent).build();
        String testNamespace1Component = "TestNamespace1Component";
        Component component2 = Component.Builder.create((String)testNamespace1, (String)testNamespace1Component, (String)testNamespace1Component).build();
        String testNamespace2Component1 = "TestNamespace2Component1";
        Component component3 = Component.Builder.create((String)testNamespace2, (String)testNamespace2Component1, (String)testNamespace2Component1).build();
        String testNamespace2Component2 = "TestNamespace2Component2";
        Component component4 = Component.Builder.create((String)testNamespace2, (String)testNamespace2Component2, (String)testNamespace2Component2).build();
        ArrayList<Component> setToPublish = new ArrayList<Component>();
        setToPublish.add(component1);
        setToPublish.add(component2);
        setToPublish.add(component3);
        setToPublish.add(component4);
        this.componentService.publishDerivedComponents(testComponentSetId, setToPublish);
        testComponentSet = this.componentService.getDerivedComponentSet(testComponentSetId);
        Assert.assertEquals((long)4L, (long)testComponentSet.size());
        for (Component component : testComponentSet) {
            Assert.assertEquals((Object)testComponentSetId, (Object)component.getComponentSetId());
        }
        ArrayList shuffledComponentSet = new ArrayList(testComponentSet);
        Collections.shuffle(shuffledComponentSet);
        this.componentService.publishDerivedComponents(testComponentSetId, shuffledComponentSet);
        testComponentSet = this.componentService.getDerivedComponentSet(testComponentSetId);
        Assert.assertEquals((long)4L, (long)testComponentSet.size());
        List workflowComponentsNew = this.componentService.getAllComponentsByNamespaceCode(workflowNamespace);
        Assert.assertEquals((long)(workflowComponents.size() + 1), (long)workflowComponentsNew.size());
        setToPublish = new ArrayList();
        setToPublish.add(component2);
        setToPublish.add(component3);
        setToPublish.add(component4);
        this.componentService.publishDerivedComponents(testComponentSetId, setToPublish);
        testComponentSet = this.componentService.getDerivedComponentSet(testComponentSetId);
        Assert.assertEquals((long)3L, (long)testComponentSet.size());
        workflowComponentsNew = this.componentService.getAllComponentsByNamespaceCode(workflowNamespace);
        Assert.assertEquals((long)workflowComponents.size(), (long)workflowComponentsNew.size());
    }
}

