/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.test.document.bo.Account;
import org.kuali.rice.krad.test.document.bo.AccountManager;
import org.kuali.rice.location.impl.county.CountyBo;
import org.kuali.rice.location.impl.state.StateBo;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.data.PerTestUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestFile;
import org.kuali.rice.test.data.UnitTestSql;
import org.kuali.test.KRADTestCase;

@PerTestUnitTestData(value={@UnitTestData(order={UnitTestData.Type.SQL_STATEMENTS, UnitTestData.Type.SQL_FILES}, sqlStatements={@UnitTestSql(value="delete from trv_acct where acct_fo_id between 101 and 301"), @UnitTestSql(value="delete from trv_acct_fo where acct_fo_id between 101 and 301")}, sqlFiles={@UnitTestFile(filename="classpath:testAccountManagers.sql", delimiter=";"), @UnitTestFile(filename="classpath:testAccounts.sql", delimiter=";")})}, tearDown={@UnitTestData(sqlStatements={@UnitTestSql(value="delete from trv_acct where acct_fo_id between 101 and 301"), @UnitTestSql(value="delete from trv_acct_fo where acct_fo_id between 101 and 301")})})
@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class BusinessObjectRefreshTest
extends KRADTestCase {
    @Test
    public void testLazyRefreshField() {
        String accountNumber = "b101";
        Account account = (Account)KRADServiceLocator.getBusinessObjectService().findBySinglePrimaryKey(Account.class, (Object)"b101");
        Assert.assertEquals((String)"Retrieved account should have name b101", (Object)"b101", (Object)account.getName());
        Assert.assertEquals((String)"Retrieved account should have a account manager with user name fo-101", (Object)"fo-101", (Object)account.getAccountManager().getUserName());
        account.setAmId(102L);
        account.refreshReferenceObject("accountManager");
        Assert.assertEquals((String)"Account Manager should now have user name of fo-102", (Object)"fo-102", (Object)account.getAccountManager().getUserName());
    }

    @Test
    public void testLazyRefreshWholeObject() {
        String accountNumber = "b101";
        Account account = (Account)KRADServiceLocator.getBusinessObjectService().findBySinglePrimaryKey(Account.class, (Object)"b101");
        Assert.assertEquals((String)"Retrieved account should have name b101", (Object)"b101", (Object)account.getName());
        Assert.assertEquals((String)"Retrieved account should have a account manager with user name fo-101", (Object)"fo-101", (Object)account.getAccountManager().getUserName());
        account.setAmId(102L);
        account.refresh();
        Assert.assertEquals((String)"Account Manager should now have user name of fo-102", (Object)"fo-102", (Object)account.getAccountManager().getUserName());
    }

    @Ignore
    @Test
    public void testLazyCollectionRefresh() {
        Long fredManagerId = 101L;
        AccountManager manager = (AccountManager)KRADServiceLocator.getBusinessObjectService().findBySinglePrimaryKey(AccountManager.class, (Object)new Long(fredManagerId));
        Assert.assertEquals((String)"Retrieve manager should have a name 'fo-101'", (Object)"fo-101", (Object)manager.getUserName());
        Assert.assertEquals((String)"Manager should have one account", (Object)new Integer(101), (Object)new Integer(manager.getAccounts().size()));
        String accountNumber = "b102";
        Account account = (Account)KRADServiceLocator.getBusinessObjectService().findBySinglePrimaryKey(Account.class, (Object)"b102");
        account.setAmId(101L);
        account = (Account)KRADServiceLocator.getBusinessObjectService().save((PersistableBusinessObject)account);
        manager.refreshReferenceObject("accounts");
        Assert.assertEquals((String)"Manager should have one account", (Object)new Integer(2), (Object)new Integer(manager.getAccounts().size()));
    }

    @Test
    public void testEagerRefreshField() {
    }

    @Test
    public void testEagerRefreshEboField() {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("code", "COCONINO");
        primaryKeys.put("countryCode", "US");
        primaryKeys.put("stateCode", "AZ");
        CountyBo county = (CountyBo)KRADServiceLocator.getBusinessObjectService().findByPrimaryKey(CountyBo.class, primaryKeys);
        primaryKeys.clear();
        primaryKeys.put("countryCode", "US");
        primaryKeys.put("code", "AZ");
        StateBo arizonaState = (StateBo)KRADServiceLocator.getBusinessObjectService().findByPrimaryKey(StateBo.class, primaryKeys);
        Assert.assertEquals((String)"On retrieval from database, state code should be AZ", (Object)arizonaState.getCode(), (Object)county.getState().getCode());
        Assert.assertEquals((String)"On retrieval from database, state name should be ARIZONA", (Object)arizonaState.getName(), (Object)county.getState().getName());
        county.setStateCode("CA");
        county.setCode("VENTURA");
        county.refresh();
        primaryKeys.clear();
        primaryKeys.put("countryCode", "US");
        primaryKeys.put("code", "CA");
        StateBo californiaState = (StateBo)KRADServiceLocator.getBusinessObjectService().findByPrimaryKey(StateBo.class, primaryKeys);
        Assert.assertEquals((String)"Does eager fetching automatically refresh?", (Object)californiaState.getCode(), (Object)county.getState().getCode());
        Assert.assertEquals((String)"On refresh, state name should be CALIFORNIA", (Object)californiaState.getName(), (Object)county.getState().getName());
    }
}

