/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kim.document.IdentityManagementGroupDocument;
import org.kuali.rice.kim.document.IdentityManagementKimDocument;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;
import org.kuali.rice.krad.bo.AdHocRouteWorkgroup;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.datadictionary.TransactionalDocumentEntry;
import org.kuali.rice.krad.datadictionary.exception.ClassValidationException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentBase;
import org.kuali.rice.krad.document.TransactionalDocumentBase;
import org.kuali.rice.krad.impls.RiceTestTransactionalDocument2;
import org.kuali.rice.krad.impls.RiceTestTransactionalDocument2Parent;
import org.kuali.rice.krad.impls.RiceTestTransactionalDocumentDivergent;
import org.kuali.rice.krad.impls.RiceTestTransactionalDocumentDivergentParent;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentBase;
import org.kuali.rice.krad.test.document.AccountRequestDocument;
import org.kuali.rice.krad.test.document.bo.AccountType2;
import org.kuali.rice.krad.test.document.bo.AccountType2Parent;
import org.kuali.rice.krad.test.document.bo.AccountTypeDivergent;
import org.kuali.rice.krad.test.document.bo.AccountTypeDivergentParent;
import org.kuali.test.KRADTestCase;

public class BaseBOClassAndBaseDocumentClassTest
extends KRADTestCase {
    DataDictionary dd = null;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dd = new DataDictionary();
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifControlDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifConfigurationDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifRiceDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifFieldDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifLookupDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifInquiryDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifGroupDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifHeaderFooterDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifLayoutManagerDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifViewPageDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifWidgetDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifMaintenanceDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifDocumentDefinitions.xml");
        this.dd.addConfigFileLocation("file:" + this.getUserDir() + "/../../impl/src/main/resources/org/kuali/rice/krad/bo/datadictionary");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kns/bo/datadictionary/DataDictionaryBaseTypes.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/bo/datadictionary/EmploymentStatus.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/bo/datadictionary/EmploymentType.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/impl/identity/PersonImpl.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/bo/datadictionary/KimBaseBeans.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/impl/group/Group.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/impl/role/RoleBo.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/impl/type/KimType.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/test/document/");
        this.dd.addConfigFileLocation("file:" + this.getBaseDir() + "/../../location/web/src/main/resources/org/kuali/rice/location/web/campus/Campus.xml");
        this.dd.addConfigFileLocation("file:" + this.getBaseDir() + "/../../location/web/src/main/resources/org/kuali/rice/location/web/campus/CampusType.xml");
        this.dd.addConfigFileLocation("file:" + this.getBaseDir() + "/../../location/web/src/main/resources/org/kuali/rice/location/web/country/Country.xml");
        this.dd.addConfigFileLocation("file:" + this.getBaseDir() + "/../../location/web/src/main/resources/org/kuali/rice/location/web/state/State.xml");
        this.dd.addConfigFileLocation("file:" + this.getBaseDir() + "/../../location/web/src/main/resources/org/kuali/rice/location/web/county/County.xml");
        this.dd.addConfigFileLocation("file:" + this.getBaseDir() + "/../../location/web/src/main/resources/org/kuali/rice/location/web/postalcode/PostalCode.xml");
        this.dd.addConfigFileLocation("file:" + this.getBaseDir() + "/../../core-service/web/src/main/resources/org/kuali/rice/coreservice/web/parameter/Parameter.xml");
        this.dd.addConfigFileLocation("file:" + this.getBaseDir() + "/../../core-service/web/src/main/resources/org/kuali/rice/coreservice/web/parameter/ParameterType.xml");
        this.dd.addConfigFileLocation("file:" + this.getBaseDir() + "/../../core-service/web/src/main/resources/org/kuali/rice/coreservice/web/namespace/Namespace.xml");
        this.dd.addConfigFileLocation("file:" + this.getBaseDir() + "/../../core-service/web/src/main/resources/org/kuali/rice/coreservice/web/component/Component.xml");
        this.dd.parseDataDictionaryConfigurationFiles(false);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.dd = null;
    }

    @Test
    public void testValidAndInvalidDDEntries() throws Exception {
        this.assertExpectedOutcomeOfBOEntryConstruction(AdHocRoutePerson.class, DocumentBase.class, true);
        this.assertExpectedOutcomeOfDocEntryConstruction(TransactionalDocumentBase.class, MaintenanceDocumentBase.class, true);
        this.assertExpectedOutcomeOfBOEntryConstruction(TransactionalDocumentBase.class, AdHocRouteRecipient.class, true);
        this.assertExpectedOutcomeOfDocEntryConstruction(AccountRequestDocument.class, IdentityManagementKimDocument.class, true);
        this.assertExpectedOutcomeOfBOEntryConstruction(AdHocRoutePerson.class, AdHocRouteRecipient.class, true);
        this.assertExpectedOutcomeOfDocEntryConstruction(TransactionalDocumentBase.class, DocumentBase.class, true);
        this.assertExpectedOutcomeOfBOEntryConstruction(AdHocRouteWorkgroup.class, AdHocRouteRecipient.class, true);
        this.assertExpectedOutcomeOfDocEntryConstruction(IdentityManagementPersonDocument.class, IdentityManagementKimDocument.class, true);
        this.assertExpectedOutcomeOfBOEntryConstruction(AdHocRouteRecipient.class, AdHocRoutePerson.class, true);
        this.assertExpectedOutcomeOfDocEntryConstruction(IdentityManagementKimDocument.class, IdentityManagementGroupDocument.class, true);
        this.assertExpectedOutcomeOfBOEntryConstruction(AdHocRoutePerson.class, AdHocRoutePerson.class, true);
        this.assertExpectedOutcomeOfDocEntryConstruction(MaintenanceDocumentBase.class, MaintenanceDocumentBase.class, true);
    }

    @Test
    public void testRetrieveDDEntriesByBaseClass() throws Exception {
        Object[][] tests;
        for (Object[] test : tests = new Object[][]{{"AccountType2Parent", "AccountType2", AccountType2.class, AccountType2Parent.class, "accountTypeCode2", "Account Type 2"}, {"org.kuali.rice.krad.test.document.bo.AccountType2Parent", "org.kuali.rice.krad.test.document.bo.AccountType2", AccountType2.class, AccountType2Parent.class, "accountTypeCode2", "Account Type 2"}, {"AccountTypeDivergentParent", "AccountTypeDivergent", AccountTypeDivergent.class, AccountTypeDivergentParent.class, "accountTypeCode Divergent", "Account Type Divergent"}, {"org.kuali.rice.krad.test.document.bo.AccountTypeDivergentParent", "org.kuali.rice.krad.test.document.bo.AccountTypeDivergent", AccountTypeDivergent.class, AccountTypeDivergentParent.class, "accountTypeCode Divergent", "Account Type Divergent"}}) {
            this.assertBusinessObjectEntry(this.dd.getBusinessObjectEntry((String)test[0]), (Class)test[2], (Class)test[3], (String)test[4], (String)test[5]);
            this.assertBusinessObjectEntry(this.dd.getBusinessObjectEntry((String)test[1]), (Class)test[2], (Class)test[3], (String)test[4], (String)test[5]);
        }
        for (Object[] test : tests = new Object[][]{{"RiceTestTransactionalDocument2Parent", "RiceTestTransactionalDocument2", RiceTestTransactionalDocument2.class, RiceTestTransactionalDocument2Parent.class}, {"org.kuali.rice.krad.impls.RiceTestTransactionalDocument2Parent", "org.kuali.rice.krad.impls.RiceTestTransactionalDocument2", RiceTestTransactionalDocument2.class, RiceTestTransactionalDocument2Parent.class}, {"RiceTestTransactionalDocumentDivergentParent", "RiceTestTransactionalDocumentDivergent", RiceTestTransactionalDocumentDivergent.class, RiceTestTransactionalDocumentDivergentParent.class}, {"org.kuali.rice.krad.impls.RiceTestTransactionalDocumentDivergentParent", "org.kuali.rice.krad.impls.RiceTestTransactionalDocumentDivergent", RiceTestTransactionalDocumentDivergent.class, RiceTestTransactionalDocumentDivergentParent.class}}) {
            this.assertDocumentEntry(this.dd.getDocumentEntry((String)test[0]), (Class)test[2], (Class)test[3]);
            this.assertDocumentEntry(this.dd.getDocumentEntry((String)test[1]), (Class)test[2], (Class)test[3]);
        }
        DataDictionaryEntry ddEntry = this.dd.getDictionaryObjectEntry("AccountType2");
        Assert.assertNotNull((String)"The AccountType2 DD entry from the entriesByJstlKey map should not be null", (Object)ddEntry);
        Assert.assertTrue((String)"The DD entry should have been a BusinessObjectEntry", (boolean)(ddEntry instanceof BusinessObjectEntry));
        this.assertBusinessObjectEntryIsAccountType2((BusinessObjectEntry)ddEntry);
    }

    private void assertExpectedOutcomeOfBOEntryConstruction(Class<? extends BusinessObject> boClass, Class<? extends BusinessObject> boBaseClass, boolean shouldSucceed) throws Exception {
        block3: {
            BusinessObjectEntry boEntry = new BusinessObjectEntry();
            boEntry.setBusinessObjectClass(boClass);
            boEntry.setBaseBusinessObjectClass(boBaseClass);
            boEntry.setObjectLabel(boClass.getSimpleName());
            try {
                boEntry.completeValidation();
                if (!shouldSucceed) {
                    Assert.fail((String)"The BO entry should have thrown a ClassValidationException during the validation process");
                }
            }
            catch (ClassValidationException e) {
                if (!shouldSucceed) break block3;
                Assert.fail((String)"The BO entry should not have thrown a ClassValidationException during the validation process");
            }
        }
    }

    private void assertExpectedOutcomeOfDocEntryConstruction(Class<? extends Document> docClass, Class<? extends Document> docBaseClass, boolean shouldSucceed) throws Exception {
        block3: {
            TransactionalDocumentEntry docEntry = new TransactionalDocumentEntry();
            docEntry.setDocumentClass(docClass);
            docEntry.setBaseDocumentClass(docBaseClass);
            try {
                docEntry.completeValidation();
                if (!shouldSucceed) {
                    Assert.fail((String)"The doc entry should have thrown a ClassValidationException during the validation process");
                }
            }
            catch (ClassValidationException e) {
                if (!shouldSucceed) break block3;
                Assert.fail((String)"The doc entry should not have thrown a ClassValidationException during the validation process");
            }
        }
    }

    private void assertBusinessObjectEntryIsAccountType2(BusinessObjectEntry boEntry) throws Exception {
        this.assertBusinessObjectEntry(boEntry, AccountType2.class, AccountType2Parent.class, "accountTypeCode2", "Account Type 2");
    }

    private void assertBusinessObjectEntry(BusinessObjectEntry boEntry, Class boClass, Class boBaseClass, String title, String label) throws Exception {
        Assert.assertNotNull((String)"The DD entry should not be null", (Object)boEntry);
        Assert.assertEquals((String)("The DD entry does not represent the " + boClass.getName() + " entry"), (Object)boClass, (Object)boEntry.getBusinessObjectClass());
        Assert.assertEquals((String)"The DD entry does not have the expected base class", (Object)boBaseClass, (Object)boEntry.getBaseBusinessObjectClass());
        Assert.assertEquals((String)"The DD entry does not have the expected title attribute", (Object)title, (Object)boEntry.getTitleAttribute());
        Assert.assertEquals((String)"The DD entry does not have the expected object label", (Object)label, (Object)boEntry.getObjectLabel());
    }

    private void assertDocumentEntry(DocumentEntry docEntry, Class docClass, Class baseDocClass) throws Exception {
        Assert.assertNotNull((String)"The RiceTestTransactionalDocument2 DD entry should not be null", (Object)docEntry);
        Assert.assertEquals((String)"The DD entry does not represent the RiceTestTransactionalDocument2 entry", (Object)docClass, (Object)docEntry.getDocumentClass());
        Assert.assertEquals((String)"The DD entry does not have the expected base class", (Object)baseDocClass, (Object)docEntry.getBaseDocumentClass());
    }
}

