/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.util.ArrayList;
import org.apache.commons.beanutils.PropertyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.keyvalues.PersistableBusinessObjectValuesFinder;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.test.document.bo.Account;
import org.kuali.rice.krad.test.document.bo.AccountExtension;
import org.kuali.rice.krad.test.document.bo.AccountType;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.test.KRADTestCase;

public class ExtensionAttributeTest
extends KRADTestCase {
    DataDictionary dd = null;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dd = new DataDictionary();
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifControlDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifFieldDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifGroupDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifHeaderFooterDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifLayoutManagerDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifViewPageDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifWidgetDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifConfigurationDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifRiceDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifLookupDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifInquiryDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifMaintenanceDefinitions.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/uif/UifDocumentDefinitions.xml");
        this.dd.addConfigFileLocation("file:" + this.getUserDir() + "/../../impl/src/main/resources/org/kuali/rice/krad/bo/datadictionary");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kns/bo/datadictionary/DataDictionaryBaseTypes.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/bo/datadictionary/EmploymentStatus.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/bo/datadictionary/EmploymentType.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/impl/identity/PersonImpl.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/bo/datadictionary/KimBaseBeans.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/impl/group/Group.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/impl/role/RoleBo.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/kim/impl/type/KimType.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/location/web/campus/Campus.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/location/web/campus/CampusType.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/location/web/country/Country.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/location/web/state/State.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/location/web/county/County.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/location/web/postalcode/PostalCode.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/coreservice/web/parameter/Parameter.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/coreservice/web/parameter/ParameterType.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/coreservice/web/namespace/Namespace.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/coreservice/web/component/Component.xml");
        this.dd.addConfigFileLocation("classpath:org/kuali/rice/krad/test/document");
        this.dd.parseDataDictionaryConfigurationFiles(false);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.dd = null;
    }

    @Test
    public void testExtensionAttributeType() throws Exception {
        BusinessObjectEntry boe = this.dd.getBusinessObjectEntry("Account");
        Assert.assertNotNull((String)"BusinessObjectEntry for TravelAccount should not be null", (Object)boe);
        AttributeDefinition extAttrib = boe.getAttributeDefinition("extension.accountTypeCode");
        Assert.assertNotNull((String)"AttributeDefinition for 'extension.accountType' should not be null", (Object)extAttrib);
        Assert.assertEquals((Object)PersistableBusinessObjectValuesFinder.class.getName(), (Object)extAttrib.getControl().getValuesFinderClass());
        Assert.assertEquals((Object)AccountType.class.getName(), (Object)extAttrib.getControl().getBusinessObjectClass());
        Assert.assertEquals((Object)"accountTypeCode", (Object)extAttrib.getControl().getKeyAttribute());
        Assert.assertEquals((Object)"name", (Object)extAttrib.getControl().getLabelAttribute());
        Assert.assertEquals((Object)true, (Object)extAttrib.getControl().getIncludeKeyInLabel());
        extAttrib = boe.getAttributeDefinition("extension.accountType.codeAndDescription");
        Assert.assertNotNull((String)"AttributeDefinition for 'extension.accountType.codeAndDescription' should not be null", (Object)extAttrib);
    }

    @Test
    public void testObjectUtils_getPropertyType() throws Exception {
        Account ta = new Account();
        Assert.assertEquals((String)"physical property type mismatch", PersistableBusinessObjectExtension.class, (Object)PropertyUtils.getPropertyType((Object)((Object)ta), (String)"extension"));
        Assert.assertEquals((String)"DD property type mismatch", AccountExtension.class, (Object)ObjectUtils.getPropertyType((Object)((Object)ta), (String)"extension", (PersistenceStructureService)KRADServiceLocator.getPersistenceStructureService()));
        Assert.assertEquals((String)"extension.accountType attribute class mismatch", AccountType.class, (Object)ObjectUtils.getPropertyType((Object)((Object)ta), (String)"extension.accountType", (PersistenceStructureService)KRADServiceLocator.getPersistenceStructureService()));
        Assert.assertEquals((String)"extension.accountType.codeAndDescription attribute class mismatch", String.class, (Object)ObjectUtils.getPropertyType((Object)((Object)ta), (String)"extension.accountType.codeAndDescription", (PersistenceStructureService)KRADServiceLocator.getPersistenceStructureService()));
    }

    @Test
    public void testBOMetaDataService() throws Exception {
        Account ta = new Account();
        DataObjectRelationship br = KNSServiceLocator.getBusinessObjectMetaDataService().getBusinessObjectRelationship((BusinessObject)ta, "extension.accountType");
        Assert.assertEquals((String)"mismatch on parent class", Account.class, (Object)br.getParentClass());
        Assert.assertEquals((String)"mismatch on related class", AccountType.class, (Object)br.getRelatedClass());
        System.out.println(br.getParentToChildReferences());
        Assert.assertEquals((String)"parent/child key not correct - should be extension.accountTypeCode/accountTypeCode", (Object)"accountTypeCode", br.getParentToChildReferences().get("extension.accountTypeCode"));
        br = KNSServiceLocator.getBusinessObjectMetaDataService().getBusinessObjectRelationship((BusinessObject)ta, "extension");
        Assert.assertNull((String)"extension is not lookupable, should have returned null", (Object)br);
    }

    @Test
    public void testQuickFinder() throws Exception {
        Account ta = new Account();
        ArrayList<String> lookupFieldAttributeList = new ArrayList<String>();
        lookupFieldAttributeList.add("extension.accountTypeCode");
        Field field = FieldUtils.getPropertyField(((Object)((Object)ta)).getClass(), (String)"extension.accountTypeCode", (boolean)true);
        field = LookupUtils.setFieldQuickfinder((BusinessObject)ta, (String)"extension.accountTypeCode", (Field)field, lookupFieldAttributeList);
        Assert.assertEquals((String)"lookup class not correct", (Object)AccountType.class.getName(), (Object)field.getQuickFinderClassNameImpl());
        Assert.assertEquals((String)"field lookup params not correct", (Object)"extension.accountTypeCode:accountTypeCode", (Object)field.getLookupParameters());
        Assert.assertEquals((String)"lookup field conversions not correct", (Object)"accountTypeCode:extension.accountTypeCode", (Object)field.getFieldConversions());
    }

    @Test
    public void testExistenceChecks() throws Exception {
        Account ta = new Account();
        ((AccountExtension)ta.getExtension()).setAccountTypeCode("XYZ");
        ta.setName("Test Name");
        ta.setNumber("1234567");
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        MaintenanceDocument document = (MaintenanceDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountMaintenanceDocument");
        Assert.assertNotNull((String)"new document must not be null", (Object)document);
        document.getDocumentHeader().setDocumentDescription(((Object)((Object)this)).getClass().getSimpleName() + "test");
        document.getOldMaintainableObject().setDataObject(null);
        document.getOldMaintainableObject().setDataObjectClass(((Object)((Object)ta)).getClass());
        document.getNewMaintainableObject().setDataObject((Object)ta);
        document.getNewMaintainableObject().setDataObjectClass(((Object)((Object)ta)).getClass());
        boolean failedAsExpected = false;
        try {
            document.validateBusinessRules((KualiDocumentEvent)new RouteDocumentEvent((Document)document));
        }
        catch (ValidationException expected) {
            failedAsExpected = true;
        }
        Assert.assertTrue((String)"validation should have failed", (boolean)failedAsExpected);
        System.out.println("document errors: " + GlobalVariables.getMessageMap());
        Assert.assertTrue((String)"there should be errors", (GlobalVariables.getMessageMap().getErrorCount() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"should be an error on the account type code", (boolean)GlobalVariables.getMessageMap().doesPropertyHaveError("document.newMaintainableObject.dataObject.extension.accountTypeCode"));
        Assert.assertTrue((String)"account type code should have an existence error", (boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.newMaintainableObject.dataObject.extension.accountTypeCode", "error.existence"));
    }
}

