/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.fieldlevel;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kns.datadictionary.validation.fieldlevel.FloatingPointValidationPattern;
import org.kuali.test.KRADTestCase;

public class FloatingPointValidationPatternTest
extends KRADTestCase {
    FloatingPointValidationPattern pattern;

    public final void setUp() throws Exception {
        super.setUp();
        this.pattern = new FloatingPointValidationPattern();
    }

    @Test
    public final void testDefaultAllows_positive1() {
        Assert.assertTrue((boolean)this.pattern.matches(".1"));
    }

    @Test
    public final void testDefaultAllows_positive2() {
        Assert.assertTrue((boolean)this.pattern.matches("0.1"));
    }

    @Test
    public final void testDefaultAllows_positive3() {
        Assert.assertTrue((boolean)this.pattern.matches("1.1"));
    }

    @Test
    public final void testDefaultAllows_positive4() {
        Assert.assertTrue((boolean)this.pattern.matches("1"));
    }

    @Test
    public final void testDefaultAllows_positive5() {
        Assert.assertTrue((boolean)this.pattern.matches("1.0"));
    }

    @Test
    public final void testDefaultAllows_negative1() {
        Assert.assertFalse((boolean)this.pattern.matches("-.1"));
    }

    @Test
    public final void testDefaultAllows_negative2() {
        Assert.assertFalse((boolean)this.pattern.matches("-0.1"));
    }

    @Test
    public final void testDefaultAllows_negative3() {
        Assert.assertFalse((boolean)this.pattern.matches("-1.1"));
    }

    @Test
    public final void testDefaultAllows_negative4() {
        Assert.assertFalse((boolean)this.pattern.matches("-1"));
    }

    @Test
    public final void testDefaultAllows_negative5() {
        Assert.assertFalse((boolean)this.pattern.matches("-1.0"));
    }

    @Test
    public final void testDefaultAllows_invalid1() {
        Assert.assertFalse((boolean)this.pattern.matches("-."));
    }

    @Test
    public final void testDefaultAllows_invalid2() {
        Assert.assertFalse((boolean)this.pattern.matches("1."));
    }

    @Test
    public final void testDefaultAllows_invalid3() {
        Assert.assertFalse((boolean)this.pattern.matches("-1."));
    }

    @Test
    public final void testAllowNegative_positive1() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches(".1"));
    }

    @Test
    public final void testAllowNegative_positive2() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("0.1"));
    }

    @Test
    public final void testAllowNegative_positive3() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("1.1"));
    }

    @Test
    public final void testAllowNegative_positive4() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("1"));
    }

    @Test
    public final void testAllowNegative_positive5() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("1.0"));
    }

    @Test
    public final void testAllowNegative_negative1() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("-.1"));
    }

    @Test
    public final void testAllowNegative_negative2() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("-0.1"));
    }

    @Test
    public final void testAllowNegative_negative3() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("-1.1"));
    }

    @Test
    public final void testAllowNegative_negative4() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("-1"));
    }

    @Test
    public final void testAllowNegative_negative5() {
        this.pattern.setAllowNegative(true);
        Assert.assertTrue((boolean)this.pattern.matches("-1.0"));
    }

    @Test
    public final void testAllowNegative_invalid1() {
        this.pattern.setAllowNegative(true);
        Assert.assertFalse((boolean)this.pattern.matches("-."));
    }

    @Test
    public final void testAllowNegative_invalid2() {
        this.pattern.setAllowNegative(true);
        Assert.assertFalse((boolean)this.pattern.matches("1."));
    }

    @Test
    public final void testAllowNegative_invalid3() {
        this.pattern.setAllowNegative(true);
        Assert.assertFalse((boolean)this.pattern.matches("-1."));
    }
}

