/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.lookup;

import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kns.lookup.KualiLookupableImpl;
import org.kuali.rice.kns.lookup.LookupableHelperService;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocatorInternal;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.document.bo.Account;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.data.PerTestUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestFile;
import org.kuali.rice.test.data.UnitTestSql;
import org.kuali.test.KRADTestCase;

@PerTestUnitTestData(value={@UnitTestData(order={UnitTestData.Type.SQL_STATEMENTS, UnitTestData.Type.SQL_FILES}, sqlStatements={@UnitTestSql(value="delete from trv_acct where acct_fo_id between 101 and 301"), @UnitTestSql(value="delete from trv_acct_fo where acct_fo_id between 101 and 301")}, sqlFiles={@UnitTestFile(filename="classpath:testAccountManagers.sql", delimiter=";"), @UnitTestFile(filename="classpath:testAccounts.sql", delimiter=";")})}, tearDown={@UnitTestData(sqlStatements={@UnitTestSql(value="delete from trv_acct where acct_fo_id between 101 and 301"), @UnitTestSql(value="delete from trv_acct_fo where acct_fo_id between 101 and 301")})})
@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class KualiLookupableTest
extends KRADTestCase {
    private KualiLookupableImpl lookupableImpl;

    public void setUp() throws Exception {
        super.setUp();
        this.lookupableImpl = new KualiLookupableImpl();
        this.lookupableImpl.setLookupableHelperService((LookupableHelperService)KRADServiceLocatorInternal.getService((String)"lookupableHelperService"));
        this.lookupableImpl.setBusinessObjectClass(Account.class);
    }

    @Test
    public void testGetRows() throws Exception {
        List rows = this.lookupableImpl.getRows();
        Assert.assertEquals((long)4L, (long)rows.size());
        Field f = ((Row)rows.get(0)).getField(0);
        Assert.assertEquals((Object)"number", (Object)f.getPropertyName());
        Assert.assertEquals((Object)"Account Number", (Object)f.getFieldLabel());
        Assert.assertEquals((Object)"text", (Object)f.getFieldType());
        f = ((Row)rows.get(1)).getField(0);
        Assert.assertEquals((Object)"name", (Object)f.getPropertyName());
        Assert.assertEquals((Object)"Account Name", (Object)f.getFieldLabel());
        Assert.assertEquals((Object)"text", (Object)f.getFieldType());
        f = ((Row)rows.get(2)).getField(0);
        Assert.assertEquals((Object)"extension.accountTypeCode", (Object)f.getPropertyName());
        Assert.assertEquals((Object)"Account Type Code", (Object)f.getFieldLabel());
        Assert.assertEquals((Object)"dropdown", (Object)f.getFieldType());
        f = ((Row)rows.get(3)).getField(0);
        Assert.assertEquals((Object)"amId", (Object)f.getPropertyName());
        Assert.assertEquals((Object)"Account Manager Id", (Object)f.getFieldLabel());
        Assert.assertEquals((Object)"text", (Object)f.getFieldType());
    }

    @Test
    public void testReturnUrl() throws Exception {
        HashMap<String, String> lookupProps = new HashMap<String, String>();
        lookupProps.put("number", "b101");
        lookupProps.put("name", "b101");
        Account account = (Account)((Object)KRADServiceLocatorWeb.getLookupService().findObjectBySearch(Account.class, lookupProps));
        HashMap<String, String> fieldConversions = new HashMap<String, String>();
        this.lookupableImpl.setDocFormKey("8888888");
        this.lookupableImpl.setBackLocation("http://localhost:8080/ib.do");
        String returnUrl = this.lookupableImpl.getReturnUrl((BusinessObject)account, fieldConversions, "kualiLookupable", null).constructCompleteHtmlTag();
        this.checkURLContains("Lookup return url does not contain docFormKey", "docFormKey=8888888", returnUrl);
        this.checkURLContains("Lookup return url does not go back to back location", "http://localhost:8080/ib.do", returnUrl);
        Assert.assertEquals((Object)returnUrl, (Object)"<a title=\"return valueAccount Number=b101 \" href=\"http://localhost:8080/ib.do?refreshCaller=kualiLookupable&number=b101&methodToCall=refresh&docFormKey=8888888\"  >return value</a>");
        fieldConversions.put("number", "myAccount[0].chartCode");
        returnUrl = this.lookupableImpl.getReturnUrl((BusinessObject)account, fieldConversions, "kualiLookupable", null).constructCompleteHtmlTag();
        this.checkURLContains("Lookup return url does not map key", "myAccount[0].chartCode=b101", returnUrl);
    }

    private void checkURLContains(String message, String containString, String url) {
        Assert.assertTrue((String)message, (url.indexOf(containString) > 0 ? 1 : 0) != 0);
    }
}

