/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LookupService;
import org.kuali.rice.krad.test.document.bo.Account;
import org.kuali.rice.krad.test.document.bo.AccountManager;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.data.PerTestUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestFile;
import org.kuali.rice.test.data.UnitTestSql;
import org.kuali.test.KRADTestCase;

@PerTestUnitTestData(value={@UnitTestData(order={UnitTestData.Type.SQL_STATEMENTS, UnitTestData.Type.SQL_FILES}, sqlStatements={@UnitTestSql(value="delete from trv_acct where acct_fo_id between 101 and 301"), @UnitTestSql(value="delete from trv_acct_fo where acct_fo_id between 101 and 301")}, sqlFiles={@UnitTestFile(filename="classpath:testAccountManagers.sql", delimiter=";"), @UnitTestFile(filename="classpath:testAccounts.sql", delimiter=";")})}, tearDown={@UnitTestData(sqlStatements={@UnitTestSql(value="delete from trv_acct where acct_fo_id between 101 and 301"), @UnitTestSql(value="delete from trv_acct_fo where acct_fo_id between 101 and 301")})})
@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class LookupServiceTest
extends KRADTestCase {
    @Test
    public void testLookupReturnLimits() throws Exception {
        LookupService lookupService = KRADServiceLocatorWeb.getLookupService();
        HashMap formProps = new HashMap();
        Collection accountManagers = lookupService.findCollectionBySearchHelper(AccountManager.class, formProps, false);
        Assert.assertEquals((long)90L, (long)accountManagers.size());
        accountManagers = null;
        accountManagers = lookupService.findCollectionBySearch(AccountManager.class, formProps);
        Assert.assertEquals((long)90L, (long)accountManagers.size());
    }

    @Test
    public void testLookupReturnDefaultLimit() throws Exception {
        LookupService lookupService = KRADServiceLocatorWeb.getLookupService();
        HashMap formProps = new HashMap();
        Collection travelAccounts = lookupService.findCollectionBySearchHelper(Account.class, formProps, false);
        Assert.assertEquals((long)200L, (long)travelAccounts.size());
        travelAccounts = null;
        travelAccounts = lookupService.findCollectionBySearch(Account.class, formProps);
        Assert.assertEquals((long)200L, (long)travelAccounts.size());
    }

    @Test
    public void testLookupReturnDefaultUnbounded() throws Exception {
        HashMap formProps;
        LookupService lookupService = KRADServiceLocatorWeb.getLookupService();
        Collection accountManagers = lookupService.findCollectionBySearchHelper(AccountManager.class, formProps = new HashMap(), true);
        int size = accountManagers.size();
        Assert.assertTrue((String)"# of Fiscal Officers should be > 200", (size > 200 ? 1 : 0) != 0);
        accountManagers = null;
        accountManagers = lookupService.findCollectionBySearchUnbounded(AccountManager.class, formProps);
        size = accountManagers.size();
        Assert.assertTrue((String)"# of Fiscal Officers should be > 200", (size > 200 ? 1 : 0) != 0);
    }

    @Test
    public void testLookupReturnDefaultUnbounded2() throws Exception {
        HashMap formProps;
        LookupService lookupService = KRADServiceLocatorWeb.getLookupService();
        Collection travelAccounts = lookupService.findCollectionBySearchHelper(Account.class, formProps = new HashMap(), true);
        int size = travelAccounts.size();
        Assert.assertTrue((String)"# of Travel Accounts should be > 200", (size > 200 ? 1 : 0) != 0);
        travelAccounts = null;
        travelAccounts = lookupService.findCollectionBySearchUnbounded(Account.class, formProps);
        size = travelAccounts.size();
        Assert.assertTrue((String)"# of Travel Accounts should be > 200", (size > 200 ? 1 : 0) != 0);
    }
}

