/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.framework.persistence.jpa.metadata.MetadataManager;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.impl.parameter.ParameterBo;
import org.kuali.rice.coreservice.impl.parameter.ParameterId;
import org.kuali.rice.coreservice.impl.parameter.ParameterTypeBo;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.test.document.bo.Account;
import org.kuali.rice.krad.test.document.bo.AccountExtension;
import org.kuali.rice.location.impl.country.CountryBo;
import org.kuali.rice.location.impl.state.StateBo;
import org.kuali.rice.location.impl.state.StateId;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.data.PerTestUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestFile;
import org.kuali.rice.test.data.UnitTestSql;
import org.kuali.test.KRADTestCase;

@PerTestUnitTestData(value={@UnitTestData(order={UnitTestData.Type.SQL_STATEMENTS, UnitTestData.Type.SQL_FILES}, sqlStatements={@UnitTestSql(value="delete from trv_acct where acct_fo_id between 101 and 301"), @UnitTestSql(value="delete from trv_acct_fo where acct_fo_id between 101 and 301")}, sqlFiles={@UnitTestFile(filename="classpath:testAccountManagers.sql", delimiter=";"), @UnitTestFile(filename="classpath:testAccounts.sql", delimiter=";")})}, tearDown={@UnitTestData(sqlStatements={@UnitTestSql(value="delete from trv_acct where acct_fo_id between 101 and 301"), @UnitTestSql(value="delete from trv_acct_fo where acct_fo_id between 101 and 301")})})
@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class MetadataManagerTest
extends KRADTestCase {
    @Test
    public void testPKMapToObject() {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        Object pkValue = MetadataManager.convertPrimaryKeyMapToObject(CountryBo.class, pkMap);
        Assert.assertNull((String)"An empty map should return a null key", (Object)pkValue);
        pkMap.put("code", "AN");
        pkValue = MetadataManager.convertPrimaryKeyMapToObject(CountryBo.class, pkMap);
        Assert.assertEquals((String)"Single pkValue should be of class String", String.class, pkValue.getClass());
        Assert.assertEquals((String)"Single pkValue should be \"AN\"", (Object)"AN", (Object)pkValue);
        pkMap.put("name", "ANDORRA");
        boolean exceptionThrown = false;
        try {
            pkValue = MetadataManager.convertPrimaryKeyMapToObject(CountryBo.class, pkMap);
        }
        catch (IllegalArgumentException iae) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Multiple keys did not lead to exception", (boolean)exceptionThrown);
        pkMap.clear();
        pkMap.put("countryCode", "US");
        pkMap.put("code", "WV");
        pkValue = MetadataManager.convertPrimaryKeyMapToObject(StateBo.class, pkMap);
        Assert.assertEquals((String)"Composite pkValue for State should have class of StateId", StateId.class, pkValue.getClass());
        StateId stateId = (StateId)pkValue;
        Assert.assertEquals((String)"Country code was not correctly set", (Object)"US", (Object)stateId.getCountryCode());
        Assert.assertEquals((String)"State code was not correctly set", (Object)"WV", (Object)stateId.getCode());
        pkMap.put("name", "WEST VIRGINIA");
        exceptionThrown = false;
        try {
            pkValue = MetadataManager.convertPrimaryKeyMapToObject(StateBo.class, pkMap);
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Non primary key field caused exception", (boolean)exceptionThrown);
    }

    @Test
    public void testPKObjectForEntity() {
        ParameterTypeBo parameterType = (ParameterTypeBo)KRADServiceLocator.getBusinessObjectService().findBySinglePrimaryKey(ParameterTypeBo.class, (Object)"CONFG");
        Assert.assertNotNull((String)"ParameterType should not be null", (Object)parameterType);
        Object pkValue = MetadataManager.getEntityPrimaryKeyObject((Object)parameterType);
        Assert.assertEquals((String)"Single pkValue should be of class String", String.class, pkValue.getClass());
        Assert.assertEquals((String)"Single pkValue should be \"CONFG\"", (Object)"CONFG", (Object)pkValue);
        Parameter parameter = CoreFrameworkServiceLocator.getParameterService().getParameter("KR-NS", "Lookup", "MULTIPLE_VALUE_RESULTS_PER_PAGE");
        Assert.assertNotNull((String)"State should not be null", (Object)parameter);
        pkValue = MetadataManager.getEntityPrimaryKeyObject((Object)ParameterBo.from((Parameter)parameter));
        Assert.assertEquals((String)"Composite pkValue for Parameter should have class of ParameterId", ParameterId.class, pkValue.getClass());
        ParameterId parameterId = (ParameterId)pkValue;
        Assert.assertEquals((String)"namespace code was not correctly set", (Object)"KR-NS", (Object)parameterId.getNamespaceCode());
        Assert.assertEquals((String)"parameter detail type code was not correctly set", (Object)"Lookup", (Object)parameterId.getComponentCode());
        Assert.assertEquals((String)"parameter name was not correctly set", (Object)"MULTIPLE_VALUE_RESULTS_PER_PAGE", (Object)parameterId.getName());
        Assert.assertEquals((String)"parameterApplicationNamespaceCode was not correctly set", (Object)"KUALI", (Object)parameterId.getApplicationId());
    }

    @Test
    public void testPKObjectForExtension() {
        Account account = (Account)KRADServiceLocator.getBusinessObjectService().findBySinglePrimaryKey(Account.class, (Object)"b101");
        Assert.assertNotNull((String)"Account should not be null", (Object)((Object)account));
        AccountExtension accountExtension = (AccountExtension)account.getExtension();
        Object pkValue = MetadataManager.getPersistableBusinessObjectPrimaryKeyObjectWithValuesForExtension((Object)((Object)account), (Object)((Object)accountExtension));
        Assert.assertEquals((String)"Single pkValue should be of class String", String.class, pkValue.getClass());
        Assert.assertEquals((String)"Single pkValue should be \"b101\"", (Object)"b101", (Object)pkValue);
    }
}

