/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.test.document;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.krad.document.TransactionalDocumentBase;
import org.kuali.rice.krad.workflow.SearchAttributeIndexRequestTest;

@Entity
@Table(name="TST_SEARCH_ATTR_INDX_TST_DOC_T")
public class SearchAttributeIndexTestDocument
extends TransactionalDocumentBase {
    static Logger LOG = Logger.getLogger(SearchAttributeIndexRequestTest.class);
    private static final long serialVersionUID = -2290510385815271758L;
    @Column(name="RTE_LVL_CNT")
    private int routeLevelCount = 0;
    @Column(name="CNSTNT_STR")
    private String constantString;
    @Column(name="RTD_STR")
    private String routedString;
    @Column(name="HLD_RTD_STR")
    private String heldRoutedString;
    @Column(name="RD_ACCS_CNT")
    private int readAccessCount = 0;

    public void initialize(String constantString, String routedString) {
        this.constantString = constantString;
        this.heldRoutedString = routedString;
    }

    public int getRouteLevelCount() {
        ++this.readAccessCount;
        return this.routeLevelCount;
    }

    public String getConstantString() {
        return this.constantString;
    }

    public String getRoutedString() {
        return this.routedString;
    }

    public int getReadAccessCount() {
        return this.readAccessCount;
    }

    public void doRouteLevelChange(DocumentRouteLevelChange levelChangeEvent) {
        super.doRouteLevelChange(levelChangeEvent);
        ++this.routeLevelCount;
        if (this.routedString == null) {
            this.routedString = this.heldRoutedString;
        }
        LOG.info((Object)("Performing route level change on SearchAttributeIndexTestDocument; routeLevelCount is " + this.routeLevelCount));
    }
}

