/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.beanutils.NestedNullException;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.coreservice.impl.parameter.ParameterBo;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.web.struts.form.pojo.PojoPlugin;
import org.kuali.rice.kns.web.struts.form.pojo.PojoPropertyUtilsBean;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DocumentAttachment;
import org.kuali.rice.krad.bo.MultiDocumentAttachment;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentBase;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.document.BOContainingPerson;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.test.KRADTestCase;

public class ObjectUtilsTest
extends KRADTestCase {
    @Test
    public void testObjectUtils_equalsByKey() throws Exception {
        ParameterBo parameterInDB = new ParameterBo();
        parameterInDB.setNamespaceCode("KR-NS");
        parameterInDB.setName("OBJ_UTIL_TEST");
        ParameterBo parameterNew = new ParameterBo();
        parameterNew.setNamespaceCode("KR-NS");
        parameterInDB.setName(null);
        boolean equalsResult = false;
        equalsResult = ObjectUtils.equalByKeys((PersistableBusinessObject)parameterInDB, (PersistableBusinessObject)parameterNew);
        Assert.assertFalse((boolean)equalsResult);
    }

    private void changeAttributeDefinitionFormatter(Class boClass, String attributeName, Class formatterClass) {
        DataDictionaryEntryBase entry = (DataDictionaryEntryBase)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(boClass.getName());
        if (entry != null) {
            AttributeDefinition attributeDefinition = entry.getAttributeDefinition(attributeName);
            attributeDefinition.setFormatterClass(formatterClass.getName());
        }
    }

    @Test
    public void testMissingNestedObjectCreation() throws Exception {
        PojoPlugin.initBeanUtils();
        MaintenanceDocumentBase m = new MaintenanceDocumentBase();
        m.setAttachments(new ArrayList());
        Assert.assertNotNull((Object)m.getAttachments());
        Object o = ObjectUtils.getPropertyValue((Object)m, (String)"attachments[0]");
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((boolean)(o instanceof MultiDocumentAttachment));
    }

    @Test
    public void testInvalidOJBCollection() {
        Assert.assertNull((Object)new PojoPropertyUtilsBean.PersistenceStructureServiceProvider().getCollectionItemClass((Object)new MaintenanceDocumentBase(), "abcd"));
        Assert.assertNull((Object)new PojoPropertyUtilsBean.PersistenceStructureServiceProvider().getCollectionItemClass((Object)new MaintenanceDocumentBase(), "attachment"));
        Assert.assertNull((Object)new PojoPropertyUtilsBean.PersistenceStructureServiceProvider().getCollectionItemClass((Object)new DocumentAttachment(), "attachmentContent"));
    }

    @Test
    public void testPopulateBusinessObjectFromMap() {
        PojoPlugin.initBeanUtils();
        NestedBo nestedBo = new NestedBo();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("nestedImpl.value", "value");
        FieldUtils.populateBusinessObjectFromMap((BusinessObject)nestedBo, values);
        Assert.assertNotNull((Object)nestedBo.nested);
        nestedBo.nested = null;
        values.clear();
        values.put("nestedIntf.value", "value");
        try {
            FieldUtils.populateBusinessObjectFromMap((BusinessObject)nestedBo, values);
            Assert.fail((String)"Expected to throw NestedNullException due to attempt to instantiate interface");
        }
        catch (NestedNullException nestedNullException) {
            // empty catch block
        }
        BOContainingPerson bo = new BOContainingPerson();
        values.clear();
        values.put("person.name", "value");
        FieldUtils.populateBusinessObjectFromMap((BusinessObject)bo, values);
        Assert.assertNotNull((Object)bo.getPerson());
        Assert.assertEquals((Object)"value", (Object)bo.getPerson().getName());
    }

    public static class NestedBo
    implements BusinessObject,
    ValueHolder {
        public String value = "foo";
        public NestedBo nested = null;

        public void refresh() {
        }

        public void setNestedImpl(NestedBo nested) {
            this.nested = nested;
        }

        public NestedBo getNestedImpl() {
            return this.nested;
        }

        public void setNestedIntf(ValueHolder refreshable) {
            this.nested = (NestedBo)refreshable;
        }

        public ValueHolder getNestedIntf() {
            return this.nested;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static interface ValueHolder {
        public void setValue(String var1);

        public String getValue();
    }
}

