/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.workflow.service;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.test.KRADTestCase;

public class WorkflowInfoServiceTest
extends KRADTestCase {
    @Test
    public void testRouteHeaderExists_NullId() throws IllegalArgumentException {
        boolean errorThrown = false;
        try {
            KewApiServiceLocator.getWorkflowDocumentService().doesDocumentExist(null);
        }
        catch (RiceIllegalArgumentException e) {
            errorThrown = true;
        }
        Assert.assertTrue((String)"An error should have been thrown.", (boolean)errorThrown);
    }

    @Test
    public void testRouteHeaderExists_NegativeId() {
        boolean errorThrown = false;
        boolean result = true;
        try {
            result = KewApiServiceLocator.getWorkflowDocumentService().doesDocumentExist("-10");
        }
        catch (Exception e) {
            errorThrown = true;
        }
        Assert.assertFalse((String)"An error should not have been thrown.", (boolean)errorThrown);
        Assert.assertFalse((String)"The routeHeader should never exist for a negative documentId.", (boolean)result);
    }

    @Test
    public void testRouteHeaderExists_KnownBadZeroId() {
        boolean errorThrown = false;
        boolean result = true;
        try {
            result = KewApiServiceLocator.getWorkflowDocumentService().doesDocumentExist("0");
        }
        catch (Exception e) {
            errorThrown = true;
        }
        Assert.assertFalse((String)"An error should not have been thrown.", (boolean)errorThrown);
        Assert.assertFalse((String)"The routeHeader should never exist for a documentId of 0.", (boolean)result);
    }

    @Test
    public void testRouteHeaderExists_KnownGood() {
        Assert.assertTrue((String)"This has been checked with a known-good id in the DB at this time.", (boolean)true);
    }
}

