/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.web;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;
import org.kuali.rice.location.impl.country.CountryBo;
import org.kuali.rice.location.impl.county.CountyBo;
import org.kuali.rice.location.impl.state.StateBo;
import org.kuali.test.BaseMaintenanceDocumentTest;

public class CountyMaintenanceDocumentTest
extends BaseMaintenanceDocumentTest {
    @Before
    public void insertTestCountryAndState() {
        CountryBo country = new CountryBo();
        country.setCode("CC");
        country.setName("New Country");
        country.setActive(true);
        KRADServiceLocator.getBusinessObjectService().save((PersistableBusinessObject)country);
        StateBo state = new StateBo();
        state.setCode("SS");
        state.setCountryCode("CC");
        state.setName("New State");
        state.setActive(true);
        KRADServiceLocator.getBusinessObjectService().save((PersistableBusinessObject)state);
    }

    @Override
    protected Object getNewMaintainableObject() {
        CountyBo county = new CountyBo();
        county.setName("Tompkins");
        county.setCode("TOMPKINS");
        county.setCountryCode("US");
        county.setStateCode("CA");
        return county;
    }

    @Override
    protected String getDocumentTypeName() {
        return "CountyMaintenanceDocument";
    }

    @Override
    protected String getInitiatorPrincipalName() {
        return "quickstart";
    }

    @Override
    protected Object getOldMaintainableObject() {
        return this.getNewMaintainableObject();
    }

    @Test(expected=ValidationException.class)
    public void test_MismatchedStateCountry() throws WorkflowException {
        Assert.assertNotNull((Object)LocationApiServiceLocator.getCountryService().getCountry("CC"));
        Assert.assertNotNull((Object)LocationApiServiceLocator.getStateService().getState("CC", "SS"));
        CountyBo county = new CountyBo();
        county.setName("Tompkins");
        county.setCode("TOMPKINS");
        county.setCountryCode("US");
        county.setStateCode("SS");
        MaintenanceDocument document = this.getDocument();
        document.getOldMaintainableObject().setDataObject(null);
        document.getOldMaintainableObject().setDataObjectClass(county.getClass());
        document.getNewMaintainableObject().setDataObject((Object)county);
        document.getNewMaintainableObject().setDataObjectClass(county.getClass());
        document.getNewMaintainableObject().setMaintenanceAction("New");
        KRADServiceLocatorWeb.getDocumentService().routeDocument((Document)this.getDocument(), "submit", null);
        Assert.assertTrue((String)"ValidationException should have been thrown instead of this assertion failure", (boolean)this.getDocument().getDocumentHeader().getWorkflowDocument().isEnroute());
    }
}

