/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.lookup.keyvalues;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.PersistableBusinessObjectValuesFinder;
import org.kuali.rice.krad.test.document.bo.AccountManager;
import org.kuali.rice.krad.test.document.bo.AccountType;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.data.PerTestUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestFile;
import org.kuali.rice.test.data.UnitTestSql;
import org.kuali.test.KRADTestCase;

@PerTestUnitTestData(value={@UnitTestData(order={UnitTestData.Type.SQL_STATEMENTS, UnitTestData.Type.SQL_FILES}, sqlStatements={@UnitTestSql(value="delete from trv_acct_type"), @UnitTestSql(value="delete from trv_acct_fo where acct_fo_id between 101 and 301")}, sqlFiles={@UnitTestFile(filename="classpath:testAccountManagers.sql", delimiter=";"), @UnitTestFile(filename="classpath:testAccountType.sql", delimiter=";")})}, tearDown={@UnitTestData(sqlStatements={@UnitTestSql(value="delete from trv_acct_type"), @UnitTestSql(value="delete from trv_acct_fo where acct_fo_id between 101 and 301")})})
@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class PersistableBusinessObjectValuesFinderTest
extends KRADTestCase {
    private List<KeyValue> testKeyValues = new ArrayList<KeyValue>();
    private List<KeyValue> testKeyValuesKeyInLabel = new ArrayList<KeyValue>();
    private List<KeyValue> testKeyValuesLongKey = new ArrayList<KeyValue>();
    private List<KeyValue> testKeyValuesKeyInLabelLongKey = new ArrayList<KeyValue>();

    public PersistableBusinessObjectValuesFinderTest() {
        this.testKeyValues.add((KeyValue)new ConcreteKeyValue("CAT", "Clearing Account Type"));
        this.testKeyValues.add((KeyValue)new ConcreteKeyValue("EAT", "Expense Account Type"));
        this.testKeyValues.add((KeyValue)new ConcreteKeyValue("IAT", "Income Account Type"));
        this.testKeyValuesKeyInLabel.add((KeyValue)new ConcreteKeyValue("CAT", "CAT - Clearing Account Type"));
        this.testKeyValuesKeyInLabel.add((KeyValue)new ConcreteKeyValue("EAT", "EAT - Expense Account Type"));
        this.testKeyValuesKeyInLabel.add((KeyValue)new ConcreteKeyValue("IAT", "IAT - Income Account Type"));
        for (int x = 101; x < 302; ++x) {
            this.testKeyValuesLongKey.add((KeyValue)new ConcreteKeyValue(new Long(x).toString(), "fo-" + x));
            this.testKeyValuesKeyInLabelLongKey.add((KeyValue)new ConcreteKeyValue(new Long(x).toString(), x + " - fo-" + x));
        }
    }

    @Test
    public void testGetKeyValues() throws Exception {
        PersistableBusinessObjectValuesFinder valuesFinder = new PersistableBusinessObjectValuesFinder();
        valuesFinder.setBusinessObjectClass(AccountType.class);
        valuesFinder.setKeyAttributeName("accountTypeCode");
        valuesFinder.setLabelAttributeName("name");
        valuesFinder.setIncludeKeyInDescription(false);
        List keyValues = valuesFinder.getKeyValues();
        Assert.assertEquals((long)this.testKeyValues.size(), (long)keyValues.size());
        for (KeyValue testKeyValue : this.testKeyValues) {
            Assert.assertEquals((Object)testKeyValue.getValue(), (Object)valuesFinder.getKeyLabel(testKeyValue.getKey()));
        }
    }

    @Test
    public void testGetKeyValuesKeyInLabel() throws Exception {
        PersistableBusinessObjectValuesFinder valuesFinder = new PersistableBusinessObjectValuesFinder();
        valuesFinder.setBusinessObjectClass(AccountType.class);
        valuesFinder.setKeyAttributeName("accountTypeCode");
        valuesFinder.setLabelAttributeName("name");
        valuesFinder.setIncludeKeyInDescription(true);
        List keyValues = valuesFinder.getKeyValues();
        Assert.assertEquals((long)this.testKeyValuesKeyInLabel.size(), (long)keyValues.size());
        for (KeyValue testKeyValue : this.testKeyValuesKeyInLabel) {
            Assert.assertEquals((Object)testKeyValue.getValue(), (Object)valuesFinder.getKeyLabel(testKeyValue.getKey()));
        }
    }

    @Test
    public void testGetKeyValuesLongKey() throws Exception {
        PersistableBusinessObjectValuesFinder valuesFinder = new PersistableBusinessObjectValuesFinder();
        valuesFinder.setBusinessObjectClass(AccountManager.class);
        valuesFinder.setKeyAttributeName("amId");
        valuesFinder.setLabelAttributeName("userName");
        valuesFinder.setIncludeKeyInDescription(false);
        List keyValues = valuesFinder.getKeyValues();
        Assert.assertEquals((long)this.testKeyValuesLongKey.size(), (long)keyValues.size());
        for (KeyValue testKeyValue : this.testKeyValuesLongKey) {
            Assert.assertEquals((Object)testKeyValue.getValue(), (Object)valuesFinder.getKeyLabel(testKeyValue.getKey()));
        }
    }

    @Test
    public void testGetKeyValuesKeyInLabelLongKey() throws Exception {
        PersistableBusinessObjectValuesFinder valuesFinder = new PersistableBusinessObjectValuesFinder();
        valuesFinder.setBusinessObjectClass(AccountManager.class);
        valuesFinder.setKeyAttributeName("amId");
        valuesFinder.setLabelAttributeName("userName");
        valuesFinder.setIncludeKeyInDescription(true);
        List keyValues = valuesFinder.getKeyValues();
        Assert.assertEquals((long)this.testKeyValuesKeyInLabelLongKey.size(), (long)keyValues.size());
        for (KeyValue testKeyValue : this.testKeyValuesKeyInLabelLongKey) {
            Assert.assertEquals((Object)testKeyValue.getValue(), (Object)valuesFinder.getKeyLabel(testKeyValue.getKey()));
        }
    }
}

