/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationOrderTest {
    @Test
    @TestAnnotation1(value="11")
    @TestAnnotationHolder(value={@TestAnnotation(value="1"), @TestAnnotation(value="2"), @TestAnnotation(value="3"), @TestAnnotation(value="4"), @TestAnnotation(value="5"), @TestAnnotation(value="6")})
    @TestAnnotation2(value="22")
    public void testAnnotationOrder() throws Exception {
        Method me = this.getClass().getMethod("testAnnotationOrder", new Class[0]);
        Annotation[] annotations = me.getAnnotations();
        Assert.assertEquals((long)4L, (long)annotations.length);
        Assert.assertEquals(Test.class, annotations[0].annotationType());
        Assert.assertEquals(TestAnnotation1.class, annotations[1].annotationType());
        Assert.assertEquals(TestAnnotationHolder.class, annotations[2].annotationType());
        Assert.assertEquals(TestAnnotation2.class, annotations[3].annotationType());
        TestAnnotationHolder holder = me.getAnnotation(TestAnnotationHolder.class);
        TestAnnotation[] children = holder.value();
        Assert.assertEquals((long)6L, (long)children.length);
        Assert.assertEquals((Object)"1", (Object)children[0].value());
        Assert.assertEquals((Object)"2", (Object)children[1].value());
        Assert.assertEquals((Object)"3", (Object)children[2].value());
        Assert.assertEquals((Object)"4", (Object)children[3].value());
        Assert.assertEquals((Object)"5", (Object)children[4].value());
        Assert.assertEquals((Object)"6", (Object)children[5].value());
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestAnnotationHolder {
        public TestAnnotation[] value();
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestAnnotation2 {
        public String value();
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestAnnotation1 {
        public String value();
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestAnnotation {
        public String value();
    }
}

