/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.charlevel;

import org.junit.Test;
import org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaNumericValidationPattern;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;
import org.kuali.rice.krad.datadictionary.validation.ValidationTestUtils;
import org.kuali.rice.test.BaseRiceTestCase;

public class AlphaNumericValidationPatternTest
extends BaseRiceTestCase {
    private AlphaNumericValidationPattern pattern;

    public void setUp() throws Exception {
        super.setUp();
        this.pattern = new AlphaNumericValidationPattern();
    }

    @Test
    public final void testMatch_allowDefault() {
        boolean[] expected = new boolean[]{true, false, false, false, true, false, false, true, false, false, true, false, false, false, false, false, false};
        ValidationTestUtils.assertPatternMatches((ValidationPattern)this.pattern, expected);
    }

    @Test
    public final void testMatch_allowUnderscore() {
        boolean[] expected = new boolean[]{true, false, false, false, true, false, true, true, false, true, true, true, false, false, false, false, false};
        this.pattern.setAllowUnderscore(true);
        ValidationTestUtils.assertPatternMatches((ValidationPattern)this.pattern, expected);
    }

    @Test
    public final void testMatch_allowWhitespace() {
        boolean[] expected = new boolean[]{true, false, false, false, true, true, false, true, true, false, true, false, true, false, false, false, false};
        this.pattern.setAllowWhitespace(true);
        ValidationTestUtils.assertPatternMatches((ValidationPattern)this.pattern, expected);
    }

    @Test
    public final void testMatch_allowUnderScoreAndWhiteSpace() {
        boolean[] expected = new boolean[]{true, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false};
        this.pattern.setAllowUnderscore(true);
        this.pattern.setAllowWhitespace(true);
        ValidationTestUtils.assertPatternMatches((ValidationPattern)this.pattern, expected);
    }

    @Test
    public final void testMatch_allowPeriod() {
        boolean[] expected = new boolean[]{true, false, false, false, true, false, false, true, false, false, true, false, false, false, true, false, false};
        this.pattern.setAllowPeriod(true);
        ValidationTestUtils.assertPatternMatches((ValidationPattern)this.pattern, expected);
    }

    @Test
    public final void testMatch_allowPeriodAndUnderscore() {
        boolean[] expected = new boolean[]{true, false, false, false, true, false, true, true, false, true, true, true, false, false, true, true, false};
        this.pattern.setAllowPeriod(true);
        this.pattern.setAllowUnderscore(true);
        ValidationTestUtils.assertPatternMatches((ValidationPattern)this.pattern, expected);
    }

    @Test
    public final void testMatch_allowPeriodAndUnderscoreAndSpace() {
        boolean[] expected = new boolean[]{true, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true};
        this.pattern.setAllowPeriod(true);
        this.pattern.setAllowUnderscore(true);
        this.pattern.setAllowWhitespace(true);
        ValidationTestUtils.assertPatternMatches((ValidationPattern)this.pattern, expected);
    }
}

