/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.jpa;

import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.bo.Account;

public class ReportQueryByCriteriaTest
extends KRADTestCase {
    @Test
    public void testCriteriaToReportQuery_emptySelect() throws Exception {
        Criteria criteria = new Criteria(Account.class.getName().substring(Account.class.getPackage().getName().length() + 1), "a");
        String query = criteria.toQuery(QueryByCriteria.QueryByCriteriaType.SELECT, new String[0]);
        Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((String)query, (String)"select a from Account as a"));
    }

    @Test
    public void testCriteriaToReportQuery_singleFieldSelect() throws Exception {
        Criteria criteria = new Criteria(Account.class.getName().substring(Account.class.getPackage().getName().length() + 1), "a");
        String[] attr = new String[]{"number"};
        String query = criteria.toQuery(QueryByCriteria.QueryByCriteriaType.SELECT, attr);
        Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((String)query, (String)"select a.number from Account as a"));
    }

    @Test
    public void testCriteriaToReportQuery_multipleFieldSelect() throws Exception {
        Criteria criteria = new Criteria(Account.class.getName().substring(Account.class.getPackage().getName().length() + 1), "a");
        String[] attr = new String[]{"number", "name", "amId"};
        String query = criteria.toQuery(QueryByCriteria.QueryByCriteriaType.SELECT, attr);
        Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((String)query, (String)"select a.number, a.name, a.amId from Account as a"));
    }
}

