/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.bo.Account;
import org.kuali.rice.krad.test.document.bo.AccountManager;

public class BusinessObjectServiceTest
extends KRADTestCase {
    @Test
    public void testSave() throws Exception {
        BusinessObjectService businessObjectService = KRADServiceLocator.getBusinessObjectService();
        AccountManager am = new AccountManager();
        am.setUserName("bhutchin");
        ArrayList<Account> accounts = new ArrayList<Account>();
        Account account1 = new Account();
        account1.setNumber("1");
        account1.setName("account 1");
        account1.setAccountManager(am);
        accounts.add(account1);
        Account account2 = new Account();
        account2.setNumber("2");
        account2.setName("account 2");
        account2.setAccountManager(am);
        accounts.add(account2);
        am.setAccounts(accounts);
        businessObjectService.save((PersistableBusinessObject)am);
    }

    @Test
    public void testRetrieve() {
        BusinessObjectService businessObjectService = KRADServiceLocator.getBusinessObjectService();
        AccountManager manager = new AccountManager();
        manager.setUserName("mgorilla");
        ArrayList<Account> accounts = new ArrayList<Account>();
        Account account1 = new Account();
        account1.setNumber("MG1");
        account1.setName("Manilla Gorilla Account");
        account1.setAccountManager(manager);
        accounts.add(account1);
        manager.setAccounts(accounts);
        manager = (AccountManager)businessObjectService.save((PersistableBusinessObject)manager);
        AccountManager manager2 = (AccountManager)businessObjectService.retrieve((PersistableBusinessObject)manager);
        Assert.assertNotNull((String)"manager2 should not be null", (Object)((Object)manager2));
        Assert.assertEquals((String)"manager2 should have the same user name as manager", (Object)manager.getUserName(), (Object)manager2.getUserName());
        AccountManager manager3 = new AccountManager();
        manager3.setAmId(manager.getAmId());
        manager2 = (AccountManager)businessObjectService.retrieve((PersistableBusinessObject)manager3);
        Assert.assertNotNull((String)"manager2 should not be null", (Object)((Object)manager2));
        Assert.assertEquals((String)"manager2 should have the same user name as manager", (Object)manager.getUserName(), (Object)manager2.getUserName());
        manager3.setAmId(-99L);
        manager2 = (AccountManager)businessObjectService.retrieve((PersistableBusinessObject)manager3);
        Assert.assertNull((String)"manager2 should be null", (Object)((Object)manager2));
        AccountManager manager4 = new AccountManager();
        manager4.setAmId(manager.getAmId());
        manager2 = (AccountManager)businessObjectService.findBySinglePrimaryKey(AccountManager.class, (Object)manager4.getAmId());
        Assert.assertNotNull((String)"manager2 should not be null", (Object)((Object)manager2));
        Assert.assertEquals((String)"manager2 should have the same user name as manager", (Object)manager.getUserName(), (Object)manager2.getUserName());
    }
}

