/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.test;

import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.test.TestDictionaryConfig;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.SQLDataLoader;
import org.kuali.rice.test.TestUtilities;
import org.kuali.rice.test.lifecycles.KEWXmlDataLoaderLifecycle;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
public abstract class KRADTestCase
extends BaselineTestCase {
    private static final String SQL_FILE = "classpath:org/kuali/rice/krad/test/DefaultSuiteTestData.sql";
    private static final String XML_FILE = "classpath:org/kuali/rice/krad/test/DefaultSuiteTestData.xml";
    private static final String KRAD_MODULE_NAME = "krad";
    protected DataDictionary dd;

    public KRADTestCase() {
        super(KRAD_MODULE_NAME);
    }

    public KRADTestCase(String moduleName) {
        super(moduleName);
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        List classes = TestUtilities.getHierarchyClassesToHandle(((Object)((Object)this)).getClass(), (Class[])new Class[]{TestDictionaryConfig.class}, new HashSet());
        if (!classes.isEmpty()) {
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("TestDataDictionary.xml");
            this.dd = (DataDictionary)context.getBean("testDataDictionary");
            for (Class c : classes) {
                String[] dictionaryFiles;
                if (!c.isAnnotationPresent(TestDictionaryConfig.class)) continue;
                TestDictionaryConfig testDictionaryConfig = c.getAnnotation(TestDictionaryConfig.class);
                String namespaceCode = testDictionaryConfig.namespaceCode();
                String dictionaryFileString = testDictionaryConfig.dataDictionaryFiles();
                for (String dictionaryFile : dictionaryFiles = StringUtils.split((String)dictionaryFileString, (String)",")) {
                    this.LOG.info((Object)("Adding test data dictionary file: " + dictionaryFile));
                    this.dd.addConfigFileLocation(namespaceCode, dictionaryFile);
                }
            }
            this.dd.parseDataDictionaryConfigurationFiles(true);
        }
    }

    protected Object getTestDictionaryObject(String id) {
        if (this.dd != null) {
            return this.dd.getDictionaryObject(id);
        }
        return null;
    }

    protected List<Lifecycle> getSuiteLifecycles() {
        List suiteLifecycles = super.getSuiteLifecycles();
        suiteLifecycles.add(new KEWXmlDataLoaderLifecycle(XML_FILE));
        return suiteLifecycles;
    }

    protected void loadSuiteTestData() throws Exception {
        super.loadSuiteTestData();
        new SQLDataLoader(SQL_FILE, ";").runSql();
    }

    protected Lifecycle getLoadApplicationLifecycle() {
        SpringResourceLoader springResourceLoader = new SpringResourceLoader(new QName("KRADTestResourceLoader"), "classpath:KRADTestHarnessSpringBeans.xml", null);
        springResourceLoader.setParentSpringResourceLoader(this.getTestHarnessSpringResourceLoader());
        return springResourceLoader;
    }
}

