/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.dataobject.TravelMileageRate;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
public class TravelMileageRateTest
extends KRADTestCase {
    private static final String MILEAGE_RATE_CODE = "IL";
    private static final String MILEAGE_RATE_NAME = "International";
    private static final BigDecimal MILEAGE_RATE = new BigDecimal("50");

    @Test
    public void testTravelMileageRate() {
        Assert.assertTrue((String)(TravelMileageRate.class.getName() + " is not mapped in JPA"), (boolean)KRADServiceLocator.getDataObjectService().supports(TravelMileageRate.class));
        String id = this.createTravelMileageRate();
        TravelMileageRate travelMileageRate = (TravelMileageRate)KRADServiceLocator.getDataObjectService().find(TravelMileageRate.class, (Object)id);
        Assert.assertNotNull((String)"Travel Mileage Rate ID is null", (Object)travelMileageRate.getMileageRateId());
        Assert.assertEquals((String)"Travel Mileage Rate code is incorrect", (Object)MILEAGE_RATE_CODE, (Object)travelMileageRate.getMileageRateCd());
        Assert.assertEquals((String)"Travel Mileage Rate name is incorrect", (Object)MILEAGE_RATE_NAME, (Object)travelMileageRate.getMileageRateName());
        Assert.assertEquals((String)"Travel Mileage Rate amount is incorrect", (Object)MILEAGE_RATE, (Object)travelMileageRate.getMileageRate());
        Assert.assertTrue((String)"Travel Mileage Rate is not active", (boolean)travelMileageRate.isActive());
    }

    private String createTravelMileageRate() {
        TravelMileageRate travelMileageRate = new TravelMileageRate();
        travelMileageRate.setMileageRateCd(MILEAGE_RATE_CODE);
        travelMileageRate.setMileageRateName(MILEAGE_RATE_NAME);
        travelMileageRate.setMileageRate(MILEAGE_RATE);
        travelMileageRate.setActive(true);
        return ((TravelMileageRate)KRADServiceLocator.getDataObjectService().save((Object)travelMileageRate, new PersistenceOption[0])).getMileageRateId();
    }
}

