/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.dataobject.TravelAuthorizationDocument;
import edu.sampleu.travel.dataobject.TravelDestination;
import edu.sampleu.travel.dataobject.TravelMileageRate;
import edu.sampleu.travel.dataobject.TravelPerDiemExpense;
import edu.sampleu.travel.options.PostalCountryCode;
import edu.sampleu.travel.options.PostalStateCode;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
public class TravelPerDiemExpenseTest
extends KRADTestCase {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static String DOCUMENT_NUMBER;
    private static final String DOCUMENT_DESCRIPTION = "Test Travel Authorization Document";
    private static final String CELL_PHONE_NUMBER = "555-555-5555";
    private static String TRAVEL_DESTINATION_ID;
    private static final String DESTINATION_NAME;
    private static final String COUNTRY_CODE;
    private static final String STATE_CODE;
    private static String MILEAGE_RATE_ID;
    private static final String MILEAGE_RATE_CODE = "DO";
    private static final String MILEAGE_RATE_NAME = "Domestic";
    private static final BigDecimal MILEAGE_RATE;
    private static final String PER_DIEM_DATE = "2010-01-01";
    private static final BigDecimal BREAKFAST_VALUE;
    private static final BigDecimal LUNCH_VALUE;
    private static final BigDecimal DINNER_VALUE;
    private static final BigDecimal INCIDENTALS_VALUE;
    private static final BigDecimal ESTIMATED_MILEAGE;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        GlobalVariables.setUserSession((UserSession)new UserSession("admin"));
        TravelDestination newTravelDestination = new TravelDestination();
        newTravelDestination.setTravelDestinationName(DESTINATION_NAME);
        newTravelDestination.setCountryCd(COUNTRY_CODE);
        newTravelDestination.setStateCd(STATE_CODE);
        TRAVEL_DESTINATION_ID = ((TravelDestination)KRADServiceLocator.getDataObjectService().save((Object)newTravelDestination, new PersistenceOption[]{PersistenceOption.FLUSH})).getTravelDestinationId();
        TravelMileageRate newTravelMileageRate = new TravelMileageRate();
        newTravelMileageRate.setMileageRateCd(MILEAGE_RATE_CODE);
        newTravelMileageRate.setMileageRateName(MILEAGE_RATE_NAME);
        newTravelMileageRate.setMileageRate(MILEAGE_RATE);
        MILEAGE_RATE_ID = ((TravelMileageRate)KRADServiceLocator.getDataObjectService().save((Object)newTravelMileageRate, new PersistenceOption[]{PersistenceOption.FLUSH})).getMileageRateId();
        Document newDocument = KRADServiceLocatorWeb.getDocumentService().getNewDocument(TravelAuthorizationDocument.class);
        newDocument.getDocumentHeader().setDocumentDescription(DOCUMENT_DESCRIPTION);
        TravelAuthorizationDocument newTravelAuthorizationDocument = (TravelAuthorizationDocument)newDocument;
        newTravelAuthorizationDocument.setCellPhoneNumber(CELL_PHONE_NUMBER);
        newTravelAuthorizationDocument.setTripDestinationId(TRAVEL_DESTINATION_ID);
        DOCUMENT_NUMBER = KRADServiceLocatorWeb.getDocumentService().saveDocument((Document)newTravelAuthorizationDocument).getDocumentNumber();
    }

    @Override
    public void tearDown() throws Exception {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testTravelPerDiemExpense() throws Exception {
        Assert.assertTrue((String)(TravelPerDiemExpense.class.getName() + " is not mapped in JPA"), (boolean)KRADServiceLocator.getDataObjectService().supports(TravelPerDiemExpense.class));
        String id = this.createTravelPerDiemExpense();
        TravelPerDiemExpense travelPerDiemExpense = (TravelPerDiemExpense)KRADServiceLocator.getDataObjectService().find(TravelPerDiemExpense.class, (Object)id);
        Assert.assertNotNull((String)"Travel Per Diem Expense ID is null", (Object)travelPerDiemExpense.getTravelPerDiemExpenseId());
        Assert.assertEquals((String)"Travel Per Diem Expense document ID is incorrect", (Object)DOCUMENT_NUMBER, (Object)travelPerDiemExpense.getTravelAuthorizationDocumentId());
        Assert.assertEquals((String)"Travel Per Diem Expense destination ID is incorrect", (Object)TRAVEL_DESTINATION_ID, (Object)travelPerDiemExpense.getTravelDestinationId());
        Assert.assertEquals((String)"Travel Per Diem Expense date is incorrect", (Object)DATE_FORMAT.parse(PER_DIEM_DATE), (Object)travelPerDiemExpense.getPerDiemDate());
        Assert.assertEquals((String)"Travel Per Diem Expense breakfast value is incorrect", (Object)BREAKFAST_VALUE, (Object)travelPerDiemExpense.getBreakfastValue());
        Assert.assertEquals((String)"Travel Per Diem Expense lunch value is incorrect", (Object)LUNCH_VALUE, (Object)travelPerDiemExpense.getLunchValue());
        Assert.assertEquals((String)"Travel Per Diem Expense dinner value is incorrect", (Object)DINNER_VALUE, (Object)travelPerDiemExpense.getDinnerValue());
        Assert.assertEquals((String)"Travel Per Diem Expense incidentals value is incorrect", (Object)INCIDENTALS_VALUE, (Object)travelPerDiemExpense.getIncidentalsValue());
        Assert.assertEquals((String)"Travel Per Diem Expense mileage rate ID is incorrect", (Object)MILEAGE_RATE_ID, (Object)travelPerDiemExpense.getMileageRateId());
        Assert.assertEquals((String)"Travel Per Diem Expense estimated mileage is incorrect", (Object)ESTIMATED_MILEAGE, (Object)travelPerDiemExpense.getEstimatedMileage());
    }

    private String createTravelPerDiemExpense() throws Exception {
        TravelPerDiemExpense travelPerDiemExpense = new TravelPerDiemExpense();
        travelPerDiemExpense.setTravelAuthorizationDocumentId(DOCUMENT_NUMBER);
        travelPerDiemExpense.setTravelDestinationId(TRAVEL_DESTINATION_ID);
        travelPerDiemExpense.setPerDiemDate(DATE_FORMAT.parse(PER_DIEM_DATE));
        travelPerDiemExpense.setBreakfastValue(BREAKFAST_VALUE);
        travelPerDiemExpense.setLunchValue(LUNCH_VALUE);
        travelPerDiemExpense.setDinnerValue(DINNER_VALUE);
        travelPerDiemExpense.setIncidentalsValue(INCIDENTALS_VALUE);
        travelPerDiemExpense.setMileageRateId(MILEAGE_RATE_ID);
        travelPerDiemExpense.setEstimatedMileage(ESTIMATED_MILEAGE);
        return ((TravelPerDiemExpense)KRADServiceLocator.getDataObjectService().save((Object)travelPerDiemExpense, new PersistenceOption[]{PersistenceOption.FLUSH})).getTravelPerDiemExpenseId();
    }

    static {
        DESTINATION_NAME = PostalStateCode.CA.getLabel();
        COUNTRY_CODE = PostalCountryCode.US.getCode();
        STATE_CODE = PostalStateCode.CA.getCode();
        MILEAGE_RATE = new BigDecimal("30");
        BREAKFAST_VALUE = new BigDecimal("15.00");
        LUNCH_VALUE = new BigDecimal("30.00");
        DINNER_VALUE = new BigDecimal("45.00");
        INCIDENTALS_VALUE = new BigDecimal("15.00");
        ESTIMATED_MILEAGE = new BigDecimal("50");
    }
}

