/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.bo.AccountExtension;
import org.kuali.rice.location.impl.county.CountyBo;
import org.kuali.rice.location.impl.state.StateBo;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.data.PerTestUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestFile;
import org.kuali.rice.test.data.UnitTestSql;

@PerTestUnitTestData(value={@UnitTestData(order={UnitTestData.Type.SQL_STATEMENTS, UnitTestData.Type.SQL_FILES}, sqlStatements={@UnitTestSql(value="delete from trv_acct_ext"), @UnitTestSql(value="delete from trv_acct_type")}, sqlFiles={@UnitTestFile(filename="classpath:testAccountType.sql", delimiter=";"), @UnitTestFile(filename="classpath:testAccountExtensions.sql", delimiter=";")})}, tearDown={@UnitTestData(sqlStatements={@UnitTestSql(value="delete from trv_acct_ext"), @UnitTestSql(value="delete from trv_acct_type")})})
@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
@KRADTestCase.Legacy
public class BusinessObjectRefreshTest
extends KRADTestCase {
    @Test
    public void testLazyRefreshField() {
        String number = "a1";
        AccountExtension accountExtension = (AccountExtension)KNSServiceLocator.getBusinessObjectService().findBySinglePrimaryKey(AccountExtension.class, (Object)"a1");
        Assert.assertNotNull((String)"Unable to retrieve account extension a1", (Object)accountExtension);
        Assert.assertEquals((String)"Retrieved account extension should have an account type of IAT", (Object)"IAT", (Object)accountExtension.getAccountType().getAccountTypeCode());
        Assert.assertEquals((String)"Retrieved account extension should have an account type name of Income Account Type", (Object)"Income Account Type", (Object)accountExtension.getAccountType().getName());
        accountExtension.setAccountTypeCode("CAT");
        accountExtension.refreshReferenceObject("accountType");
        Assert.assertEquals((String)"Account extension should now have an account type name of Clearing Account Type", (Object)"Clearing Account Type", (Object)accountExtension.getAccountType().getName());
    }

    @Test
    public void testLazyRefreshWholeObject() {
        String number = "a1";
        AccountExtension accountExtension = (AccountExtension)KNSServiceLocator.getBusinessObjectService().findBySinglePrimaryKey(AccountExtension.class, (Object)"a1");
        Assert.assertNotNull((String)"Unable to retrieve account extension a1", (Object)accountExtension);
        Assert.assertEquals((String)"Retrieved account extension should have account type IAT", (Object)"IAT", (Object)accountExtension.getAccountType().getAccountTypeCode());
        Assert.assertEquals((String)"Retrieved account extension should have an account type name of Income Account Type", (Object)"Income Account Type", (Object)accountExtension.getAccountType().getName());
        accountExtension.setAccountTypeCode("CAT");
        accountExtension.refresh();
        Assert.assertEquals((String)"Account extension should now have an account type name of Clearing Account Type", (Object)"Clearing Account Type", (Object)accountExtension.getAccountType().getName());
    }

    @Test
    public void testEagerRefreshEboField() {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("code", "COCONINO");
        primaryKeys.put("countryCode", "US");
        primaryKeys.put("stateCode", "AZ");
        CountyBo county = (CountyBo)KNSServiceLocator.getBusinessObjectService().findByPrimaryKey(CountyBo.class, primaryKeys);
        primaryKeys.clear();
        primaryKeys.put("countryCode", "US");
        primaryKeys.put("code", "AZ");
        StateBo arizonaState = (StateBo)KNSServiceLocator.getBusinessObjectService().findByPrimaryKey(StateBo.class, primaryKeys);
        Assert.assertEquals((String)"On retrieval from database, state code should be AZ", (Object)arizonaState.getCode(), (Object)county.getState().getCode());
        Assert.assertEquals((String)"On retrieval from database, state name should be ARIZONA", (Object)arizonaState.getName(), (Object)county.getState().getName());
        county.setStateCode("CA");
        county.setCode("VENTURA");
        county.refresh();
        primaryKeys.clear();
        primaryKeys.put("countryCode", "US");
        primaryKeys.put("code", "CA");
        StateBo californiaState = (StateBo)KNSServiceLocator.getBusinessObjectService().findByPrimaryKey(StateBo.class, primaryKeys);
        Assert.assertEquals((String)"Does eager fetching automatically refresh?", (Object)californiaState.getCode(), (Object)county.getState().getCode());
        Assert.assertEquals((String)"On refresh, state name should be CALIFORNIA", (Object)californiaState.getName(), (Object)county.getState().getName());
    }
}

