/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.keyvalues;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.keyvalues.PersistableBusinessObjectValuesFinder;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.bo.AccountType;

public class PersistableBusinessObjectValuesFinderTest
extends KRADTestCase {
    private List<KeyValue> testKeyValues = new ArrayList<KeyValue>();
    private List<KeyValue> testKeyValuesKeyInLabel = new ArrayList<KeyValue>();

    public PersistableBusinessObjectValuesFinderTest() {
        this.testKeyValues.add((KeyValue)new ConcreteKeyValue("CAT", "Clearing Account Type"));
        this.testKeyValues.add((KeyValue)new ConcreteKeyValue("EAT", "Expense Account Type"));
        this.testKeyValues.add((KeyValue)new ConcreteKeyValue("IAT", "Income Account Type"));
        this.testKeyValuesKeyInLabel.add((KeyValue)new ConcreteKeyValue("CAT", "CAT - Clearing Account Type"));
        this.testKeyValuesKeyInLabel.add((KeyValue)new ConcreteKeyValue("EAT", "EAT - Expense Account Type"));
        this.testKeyValuesKeyInLabel.add((KeyValue)new ConcreteKeyValue("IAT", "IAT - Income Account Type"));
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        AccountType cat = new AccountType();
        cat.setAccountTypeCode("CAT");
        cat.setName("Clearing Account Type");
        AccountType eat = new AccountType();
        eat.setAccountTypeCode("EAT");
        eat.setName("Expense Account Type");
        AccountType iat = new AccountType();
        iat.setAccountTypeCode("IAT");
        iat.setName("Income Account Type");
        DataObjectService dataObjectService = KradDataServiceLocator.getDataObjectService();
        dataObjectService.save((Object)cat, new PersistenceOption[0]);
        dataObjectService.save((Object)eat, new PersistenceOption[0]);
        dataObjectService.save((Object)iat, new PersistenceOption[0]);
        dataObjectService.flush(AccountType.class);
    }

    @Test
    public void testGetKeyValues() throws Exception {
        PersistableBusinessObjectValuesFinder valuesFinder = new PersistableBusinessObjectValuesFinder();
        valuesFinder.setBusinessObjectClass(AccountType.class);
        valuesFinder.setKeyAttributeName("accountTypeCode");
        valuesFinder.setLabelAttributeName("name");
        valuesFinder.setIncludeKeyInDescription(false);
        List keyValues = valuesFinder.getKeyValues();
        Assert.assertEquals((long)this.testKeyValues.size(), (long)keyValues.size());
        for (KeyValue testKeyValue : this.testKeyValues) {
            Assert.assertEquals((Object)testKeyValue.getValue(), (Object)valuesFinder.getKeyLabel(testKeyValue.getKey()));
        }
    }

    @Test
    public void testGetKeyValuesKeyInLabel() throws Exception {
        PersistableBusinessObjectValuesFinder valuesFinder = new PersistableBusinessObjectValuesFinder();
        valuesFinder.setBusinessObjectClass(AccountType.class);
        valuesFinder.setKeyAttributeName("accountTypeCode");
        valuesFinder.setLabelAttributeName("name");
        valuesFinder.setIncludeKeyInDescription(true);
        List keyValues = valuesFinder.getKeyValues();
        Assert.assertEquals((long)this.testKeyValuesKeyInLabel.size(), (long)keyValues.size());
        for (KeyValue testKeyValue : this.testKeyValuesKeyInLabel) {
            Assert.assertEquals((Object)testKeyValue.getValue(), (Object)valuesFinder.getKeyLabel(testKeyValue.getKey()));
        }
    }
}

