/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.test.KRADTestCase;

public class DateTimeServiceTest
extends KRADTestCase {
    @Test
    public void testGetCurrentDate() {
        Date beforeServiceDate = new Date();
        Date serviceDate = CoreApiServiceLocator.getDateTimeService().getCurrentDate();
        Date afterServiceDate = new Date();
        Assert.assertTrue((String)"beforeServiceDate not <= serviceDate", (beforeServiceDate.before(serviceDate) || beforeServiceDate.equals(serviceDate) ? 1 : 0) != 0);
        Assert.assertTrue((String)"afterServiceDate not >= serviceDate", (afterServiceDate.after(serviceDate) || afterServiceDate.equals(serviceDate) ? 1 : 0) != 0);
    }

    @Test
    public void testGetCurrentSqlDate() {
        java.sql.Date serviceDate = CoreApiServiceLocator.getDateTimeService().getCurrentSqlDate();
        java.sql.Date beforeServiceDate = new java.sql.Date(serviceDate.getTime() - 100L);
        java.sql.Date afterServiceDate = new java.sql.Date(serviceDate.getTime() + 100L);
        Assert.assertTrue((String)"beforeServiceDate not <= serviceDate", (beforeServiceDate.before(serviceDate) || beforeServiceDate.equals(serviceDate) ? 1 : 0) != 0);
        Assert.assertTrue((String)"afterServiceDate not >= serviceDate", (afterServiceDate.after(serviceDate) || afterServiceDate.equals(serviceDate) ? 1 : 0) != 0);
    }

    @Test
    public void testGetCurrentSqlDateMidnight() throws InterruptedException {
        DateTimeServiceTest.waitForMidnightIfWithinOneSecond();
        java.sql.Date before = CoreApiServiceLocator.getDateTimeService().getCurrentSqlDateMidnight();
        Date checkBefore = new Date();
        Thread.sleep(500L);
        Date checkAfter = new Date();
        java.sql.Date after = CoreApiServiceLocator.getDateTimeService().getCurrentSqlDateMidnight();
        Assert.assertTrue((boolean)checkBefore.before(checkAfter));
        Assert.assertEquals((long)before.getTime(), (long)after.getTime());
        Date afterUtil = new Date(after.getTime());
        Assert.assertEquals((long)0L, (long)afterUtil.getHours());
        Assert.assertEquals((long)0L, (long)afterUtil.getMinutes());
        Assert.assertEquals((long)0L, (long)afterUtil.getSeconds());
    }

    private static void waitForMidnightIfWithinOneSecond() throws InterruptedException {
        Date now = new Date();
        Date then = new Date(now.getTime() + 1000L);
        if (now.getDay() != then.getDay()) {
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testGetCurrentCalendar() {
        Date beforeServiceDate = new Date();
        Calendar serviceCalendar = CoreApiServiceLocator.getDateTimeService().getCurrentCalendar();
        Date afterServiceDate = new Date();
        Date serviceDate = serviceCalendar.getTime();
        Assert.assertTrue((String)"beforeServiceDate not <= serviceDate", (beforeServiceDate.before(serviceDate) || beforeServiceDate.equals(serviceDate) ? 1 : 0) != 0);
        Assert.assertTrue((String)"afterServiceDate not >= serviceDate", (afterServiceDate.after(serviceDate) || afterServiceDate.equals(serviceDate) ? 1 : 0) != 0);
    }

    @Test
    public void testConvertToSqlTimestamp_blankTimeString() throws ParseException {
        Assert.assertNull((Object)CoreApiServiceLocator.getDateTimeService().convertToSqlTimestamp(null));
    }

    @Test
    public void testConvertToSqlTimestamp_invalidTimeString() {
        boolean failedAsExpected = false;
        try {
            CoreApiServiceLocator.getDateTimeService().convertToSqlTimestamp("foo");
        }
        catch (ParseException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((String)"invalid timeString failed to fail", (boolean)failedAsExpected);
    }

    @Test
    public void testConvertToSqlTimestamp_validTimeString() throws ParseException {
        Timestamp serviceTimestamp = CoreApiServiceLocator.getDateTimeService().convertToSqlTimestamp("05/01/1966 02:41 PM");
        Calendar serviceCalendar = Calendar.getInstance();
        serviceCalendar.setTime(serviceTimestamp);
        Assert.assertEquals((String)"unexpected year", (long)1966L, (long)serviceCalendar.get(1));
        Assert.assertEquals((String)"unexpected month", (long)5L, (long)(serviceCalendar.get(2) + 1));
        Assert.assertEquals((String)"unexpected day", (long)1L, (long)serviceCalendar.get(5));
        Assert.assertEquals((String)"unexpected hours", (long)14L, (long)serviceCalendar.get(11));
        Assert.assertEquals((String)"unexpected minutes", (long)41L, (long)serviceCalendar.get(12));
        Assert.assertEquals((String)"unexpected seconds", (long)0L, (long)serviceCalendar.get(13));
        Assert.assertEquals((String)"unexpected milliseconds", (long)serviceTimestamp.getNanos(), (long)0L);
    }

    @Test
    public void testConvertToSqlDate_blankDateString() throws ParseException {
        boolean failedAsExpected = false;
        try {
            CoreApiServiceLocator.getDateTimeService().convertToSqlDate("");
        }
        catch (IllegalArgumentException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((String)"blank dateString failed to fail", (boolean)failedAsExpected);
    }

    @Test
    public void testConvertToSqlDate_invalidDateString() {
        boolean failedAsExpected = false;
        try {
            CoreApiServiceLocator.getDateTimeService().convertToSqlDate("foo");
        }
        catch (ParseException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((String)"invalid dateString failed to fail", (boolean)failedAsExpected);
    }

    @Test
    public void testConvertToSqlDate_validDateString() throws ParseException {
        java.sql.Date serviceDate = CoreApiServiceLocator.getDateTimeService().convertToSqlDate("05/01/1966");
        Calendar serviceCalendar = Calendar.getInstance();
        serviceCalendar.setTime(serviceDate);
        Assert.assertEquals((String)"unexpected year", (long)1966L, (long)serviceCalendar.get(1));
        Assert.assertEquals((String)"unexpected month", (long)5L, (long)(serviceCalendar.get(2) + 1));
        Assert.assertEquals((String)"unexpected day", (long)1L, (long)serviceCalendar.get(5));
        Assert.assertEquals((String)"unexpected hours", (long)0L, (long)serviceCalendar.get(11));
        Assert.assertEquals((String)"unexpected minutes", (long)0L, (long)serviceCalendar.get(12));
        Assert.assertEquals((String)"unexpected seconds", (long)0L, (long)serviceCalendar.get(13));
    }

    @Test
    public void testConvertToSqlTime_blankTimeString() throws ParseException {
        boolean failedAsExpected = false;
        try {
            CoreApiServiceLocator.getDateTimeService().convertToSqlTime("");
        }
        catch (IllegalArgumentException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((String)"blank timeString failed to fail", (boolean)failedAsExpected);
    }

    @Test
    public void testConvertToSqlTime_invalidTimeString() {
        boolean failedAsExpected = false;
        try {
            CoreApiServiceLocator.getDateTimeService().convertToSqlTime("foo");
        }
        catch (ParseException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((String)"invalid timeString failed to fail", (boolean)failedAsExpected);
    }

    @Test
    public void testConvertToSqlTime_validTimeString() throws ParseException {
        Time serviceTime = CoreApiServiceLocator.getDateTimeService().convertToSqlTime("10:28 am");
        Calendar serviceCalendar = Calendar.getInstance();
        serviceCalendar.setTime(serviceTime);
        Assert.assertEquals((String)"unexpected hours", (long)10L, (long)serviceCalendar.get(11));
        Assert.assertEquals((String)"unexpected minutes", (long)28L, (long)serviceCalendar.get(12));
        Assert.assertEquals((String)"unexpected seconds", (long)0L, (long)serviceCalendar.get(13));
    }

    @Test
    public void testDateDiff() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        Date date1 = sdf.parse("01/01/2006");
        Date date2 = sdf.parse("12/31/2006");
        Assert.assertEquals((Object)"365", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true)));
        Assert.assertEquals((Object)"364", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, false)));
        date1 = sdf.parse("01/01/2008");
        date2 = sdf.parse("12/31/2008");
        Assert.assertEquals((Object)"366", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true)));
        Assert.assertEquals((Object)"365", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, false)));
        Assert.assertEquals((Object)"366", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true)));
        Assert.assertEquals((Object)"365", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, false)));
        date1 = sdf.parse("07/01/2007");
        date2 = sdf.parse("06/30/2008");
        Assert.assertEquals((Object)"366", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true)));
        Assert.assertEquals((Object)"365", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, false)));
        date1 = sdf.parse("07/01/2006");
        date2 = sdf.parse("06/30/2007");
        Assert.assertEquals((Object)"365", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true)));
        Assert.assertEquals((Object)"364", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, false)));
        date1 = sdf.parse("01/01/2006");
        date2 = sdf.parse("01/31/2006");
        Assert.assertEquals((Object)"31", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true)));
        Assert.assertEquals((Object)"30", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, false)));
        date1 = sdf.parse("04/14/2006");
        date2 = sdf.parse("05/13/2006");
        Assert.assertEquals((Object)"30", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true)));
        Assert.assertEquals((Object)"29", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, false)));
        date1 = sdf.parse("01/01/2006");
        date2 = sdf.parse("01/02/2006");
        Assert.assertEquals((Object)"2", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true)));
        Assert.assertEquals((Object)"1", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, false)));
        date1 = sdf.parse("01/01/2006");
        date2 = sdf.parse("06/30/2006");
        Assert.assertEquals((Object)"181", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true)));
        date1 = sdf.parse("07/01/2006");
        date2 = sdf.parse("12/31/2006");
        Assert.assertEquals((Object)"184", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true)));
        date1 = sdf.parse("07/01/2006");
        date2 = sdf.parse("07/20/2006");
        Assert.assertEquals((Object)"19", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, false)));
        date1 = sdf.parse("07/20/2006");
        date2 = sdf.parse("07/20/2006");
        Assert.assertEquals((Object)"0", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, false)));
        date1 = sdf.parse("07/25/2006");
        date2 = sdf.parse("07/20/2006");
        Assert.assertEquals((Object)"-5", (Object)Integer.toString(CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, false)));
    }

    @Test
    public void testDateDiffDaylightSavingsTimeInclusive() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        Date date1 = sdf.parse("03/13/2017");
        Date date2 = sdf.parse("03/13/2017");
        Assert.assertEquals((long)1L, (long)CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true));
        date1 = sdf.parse("03/13/2017");
        date2 = sdf.parse("03/14/2017");
        Assert.assertEquals((long)2L, (long)CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true));
        date1 = sdf.parse("03/12/2017");
        date2 = sdf.parse("03/13/2017");
        Assert.assertEquals((long)2L, (long)CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true));
        date1 = sdf.parse("03/13/2017");
        date2 = sdf.parse("03/12/2017");
        Assert.assertEquals((long)-2L, (long)CoreApiServiceLocator.getDateTimeService().dateDiff(date1, date2, true));
    }
}

