/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentBase;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.AccountRequestDocument;
import org.kuali.rice.krad.test.document.AccountRequestDocument2;
import org.kuali.rice.krad.test.document.RuleEventImpl;
import org.kuali.rice.krad.test.document.bo.Account;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.NoteType;

public class DocumentServiceTest
extends KRADTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    public void tearDown() throws Exception {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testGetNewDocument() throws Exception {
        AccountRequestDocument travelDocument = (AccountRequestDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest");
        WorkflowDocument wd = travelDocument.getDocumentHeader().getWorkflowDocument();
        Assert.assertEquals((String)"Initiator should be the current user", (Object)wd.getInitiatorPrincipalId(), (Object)GlobalVariables.getUserSession().getPerson().getPrincipalId());
    }

    @Test
    public void testGetNewDocumentDifferentInitiatorThanCurrentUser() throws Exception {
        AccountRequestDocument travelDocument = (AccountRequestDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest", "testuser1");
        WorkflowDocument wd = travelDocument.getDocumentHeader().getWorkflowDocument();
        Assert.assertEquals((String)"Initiator should be testuser1", (Object)wd.getInitiatorPrincipalId(), (Object)"testuser1");
    }

    @Test
    public void testGetNewDocumentInvalidInitiator() throws Exception {
        AccountRequestDocument travelDocument = (AccountRequestDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest", "notValidUserAtAll");
        WorkflowDocument wd = travelDocument.getDocumentHeader().getWorkflowDocument();
        Assert.assertEquals((String)"Initiator should be the current user", (Object)wd.getInitiatorPrincipalId(), (Object)GlobalVariables.getUserSession().getPerson().getPrincipalId());
    }

    @Test
    public void testSaveDocument_DocumentEvent() throws Exception {
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountMaintenanceDocument");
        Account account = (Account)maintenanceDocument.getNewMaintainableObject().getDataObject();
        SaveDocumentEvent documentEvent = new SaveDocumentEvent((Document)maintenanceDocument);
        documentEvent.setName("DocumentControllerBaseSaveDocumentRuleTest#testSave_SaveDocumentEvent()");
        documentEvent.setRuleMethodName("processEvent");
        Document savedDocument = KRADServiceLocatorWeb.getDocumentService().saveDocument((Document)maintenanceDocument, (DocumentEvent)documentEvent);
        Assert.assertNull((String)"New maintenance document should not have a version number yet.", (Object)maintenanceDocument.getDocumentHeader().getVersionNumber());
        Assert.assertNotNull((String)"Saved maintenance document must have a version number.", (Object)savedDocument.getDocumentHeader().getVersionNumber());
        List msgs = GlobalVariables.getMessageMap().getInfoMessagesForProperty(documentEvent.getName());
        Assert.assertEquals((String)"There must be one entry added by the business rule method.", (long)1L, (long)msgs.size());
        Assert.assertEquals((String)"The message set by the business rule must match the test message.", (Object)(documentEvent.getRuleMethodName() + "()"), (Object)((ErrorMessage)msgs.get(0)).toString());
    }

    @Test
    public void testSaveDocument_Default() throws Exception {
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountMaintenanceDocument");
        Account account = (Account)maintenanceDocument.getNewMaintainableObject().getDataObject();
        RuleEventImpl documentEvent = new RuleEventImpl((Document)maintenanceDocument);
        documentEvent.setName("DocumentControllerBaseSaveDocumentRuleTest#testSave_Default()");
        Document savedDocument = KRADServiceLocatorWeb.getDocumentService().saveDocument((Document)maintenanceDocument, (DocumentEvent)documentEvent);
        Assert.assertNull((String)"New maintenance document should not have a version number yet.", (Object)maintenanceDocument.getDocumentHeader().getVersionNumber());
        Assert.assertNotNull((String)"Saved maintenance document must have a version number.", (Object)savedDocument.getDocumentHeader().getVersionNumber());
        List msgs = GlobalVariables.getMessageMap().getInfoMessagesForProperty(documentEvent.getClass().getName());
        Assert.assertEquals((String)"There must be one entry added by the business rule method.", (long)1L, (long)msgs.size());
        Assert.assertEquals((String)"The message set by the business rule must match the test message.", (Object)"org.kuali.rice.krad.test.document.AccountRules()", (Object)((ErrorMessage)msgs.get(0)).toString());
    }

    @Test
    public void testGetDocumentsByListOfDocumentHeaderIds_Default() throws Exception {
        Document document1 = KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountMaintenanceDocument");
        Document document2 = KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountMaintenanceDocument");
        RuleEventImpl documentEvent1 = new RuleEventImpl(document1);
        documentEvent1.setName("saving document 1");
        RuleEventImpl documentEvent2 = new RuleEventImpl(document2);
        documentEvent2.setName("saving document 2");
        Document savedDocument1 = KRADServiceLocatorWeb.getDocumentService().saveDocument(document1, (DocumentEvent)documentEvent1);
        Document savedDocument2 = KRADServiceLocatorWeb.getDocumentService().saveDocument(document2, (DocumentEvent)documentEvent2);
        String documentNumber1 = savedDocument1.getDocumentNumber();
        String documentNumber2 = savedDocument2.getDocumentNumber();
        List documents = KRADServiceLocatorWeb.getDocumentService().getDocumentsByListOfDocumentHeaderIds(MaintenanceDocumentBase.class, Arrays.asList(documentNumber1, documentNumber2));
        Assert.assertEquals((String)"wrong number of documents found", (long)2L, (long)documents.size());
        for (Document document : documents) {
            Assert.assertNotNull((String)"document was null", (Object)document);
        }
    }

    @Test
    public void testGetDocumentsByListOfDocumentHeaderIds_MissingDocuments() throws Exception {
        String fakeDocumentNumber1 = "1234";
        String fakeDocumentNumber2 = "5678";
        List documents = KRADServiceLocatorWeb.getDocumentService().getDocumentsByListOfDocumentHeaderIds(MaintenanceDocumentBase.class, Arrays.asList(fakeDocumentNumber1, fakeDocumentNumber2));
        Assert.assertTrue((String)"documents found", (boolean)documents.isEmpty());
    }

    @Test
    public void testGetNotes() throws Exception {
        AccountRequestDocument2 accountDoc2 = (AccountRequestDocument2)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest2");
        String remoteObjectId = "remoteObjectId" + RandomStringUtils.randomNumeric((int)5);
        String noteText = "i like notes";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)"admin", (String)"AccountRequest2");
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setWorkflowDocument(workflowDocument);
        documentHeader.setDocumentNumber(workflowDocument.getDocumentId());
        documentHeader.setObjectId(remoteObjectId);
        accountDoc2.setDocumentHeader(documentHeader);
        Note note = new Note();
        note.setAuthorUniversalIdentifier("superLongNameUsersFromWorkflow");
        note.setNotePostedTimestamp(CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp());
        note.setNoteText(noteText);
        note.setRemoteObjectIdentifier(remoteObjectId);
        note.setNoteTypeCode(NoteType.BUSINESS_OBJECT.getCode());
        try {
            KRADServiceLocator.getNoteService().save(note);
        }
        catch (Exception e) {
            Assert.fail((String)"Saving a note should not fail");
        }
        Note note2 = new Note();
        note2.setAuthorUniversalIdentifier("admin");
        note2.setNotePostedTimestamp(CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp());
        note2.setNoteText(noteText);
        note2.setRemoteObjectIdentifier(remoteObjectId);
        note2.setNoteTypeCode(NoteType.BUSINESS_OBJECT.getCode());
        try {
            KRADServiceLocator.getNoteService().save(note2);
            KradDataServiceLocator.getDataObjectService().flush(Note.class);
        }
        catch (Exception e) {
            Assert.fail((String)"Saving a note should not fail");
        }
        List notes = accountDoc2.getNotes();
        Assert.assertTrue((String)"Size of the notes list should be 2", (notes.size() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((String)"List is immutable but it should be mutable.", (boolean)Collections.unmodifiableList(notes).getClass().isInstance(notes));
        for (Note note1 : notes) {
            Assert.assertNotNull((String)"document was null", (Object)note1);
            Assert.assertTrue((boolean)note1.getNoteText().equalsIgnoreCase(noteText));
        }
    }
}

