/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kim.api.common.template.Template;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.permission.PermissionAttributeBo;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.kuali.rice.krad.kim.PopulateGroupPermissionTypeServiceImpl;
import org.kuali.rice.krad.test.KRADTestCase;

@KRADTestCase.Legacy
public class PopulateGroupPermissionTypeServiceImplTest
extends KRADTestCase {
    PopulateGroupPermissionTypeServiceImpl permissionService;
    private String PERM_NM_POP_GROUP_GROUP_NM = "Populate Group WorkflowAdmin";
    private String PERM_NM_POP_GROUP_TYPE_DEFAULT = "Populate Groups Namespace KR*, Kim Type Default";
    private String PERM_NM_POP_GROUP_NOT_TYPE_DEFAULT = "Populate Groups Namespace KR*, Kim Type NotDefault";
    private String PERM_NM_POP_GROUP_TYPE_DEFAULT_KFS = "Populate Groups Namespace KFS*, Kim Type Default";
    private String PERM_NM_POP_GROUP_NMSPC_ALL = "Populate Groups Namespace *";
    private String PERM_NM_POP_GROUP_NMSPC_KR = "Populate Groups Namespace KR*";
    private String PERM_NM_POP_GROUP_NMSPC_KFS = "Populate Groups Namespace KFS*";
    private String PERM_NM_POP_GROUP_NMSPC_KR_WKFLW = "Populate Groups Namespace KR-WKFLW";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.permissionService = new PopulateGroupPermissionTypeServiceImpl(){};
        this.permissionService.setExactMatchStringAttributeName("groupName");
        this.permissionService.setNamespaceRequiredOnStoredMap(true);
    }

    @Test
    public void testGroupNameMatchOnPopulateGroupPermission() {
        Map<String, String> requestedDetails = this.getGroupRequestedDetails();
        ArrayList<PermissionBo> permissionsList = new ArrayList<PermissionBo>();
        Template template = KimApiServiceLocator.getPermissionService().findPermTemplateByNamespaceCodeAndName("KR-IDM", "Populate Group");
        ArrayList<String> permAttrsGeneric = new ArrayList<String>();
        permAttrsGeneric.add("namespaceCode=KR*");
        ArrayList<String> permAttrsForSpecificKimTypeName = new ArrayList<String>();
        permAttrsForSpecificKimTypeName.add("namespaceCode=KR*");
        permAttrsForSpecificKimTypeName.add("kimTypeName=Default");
        ArrayList<String> permAttrsForSpecificGroupName = new ArrayList<String>();
        permAttrsForSpecificGroupName.add("groupName=WorkflowAdmin");
        permAttrsForSpecificGroupName.add("namespaceCode=KR*");
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_NMSPC_KR, "KR-SYS", permAttrsGeneric));
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_TYPE_DEFAULT, "KR-SYS", permAttrsForSpecificKimTypeName));
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_GROUP_NM, "KR-SYS", permAttrsForSpecificGroupName));
        ArrayList<Permission> immutablePermissionList = new ArrayList<Permission>();
        for (PermissionBo bo : permissionsList) {
            immutablePermissionList.add(PermissionBo.to((PermissionBo)bo));
        }
        List returnedPermissions = this.permissionService.getMatchingPermissions(requestedDetails, immutablePermissionList);
        Assert.assertTrue((returnedPermissions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Permission)returnedPermissions.get(0)).getName().equals(this.PERM_NM_POP_GROUP_GROUP_NM));
    }

    @Test
    public void testTypeNameMatchOnPopulateGroupPermission() {
        Map<String, String> requestedDetails = this.getGroupRequestedDetails();
        ArrayList<PermissionBo> permissionsList = new ArrayList<PermissionBo>();
        Template template = KimApiServiceLocator.getPermissionService().findPermTemplateByNamespaceCodeAndName("KR-IDM", "Populate Group");
        ArrayList<String> permAttrsGeneric = new ArrayList<String>();
        permAttrsGeneric.add("namespaceCode=KR*");
        ArrayList<String> permAttrsForSpecificKimTypeName = new ArrayList<String>();
        permAttrsForSpecificKimTypeName.add("namespaceCode=KR*");
        permAttrsForSpecificKimTypeName.add("kimTypeName=Default");
        ArrayList<String> permAttrsForSpecificGroupName = new ArrayList<String>();
        permAttrsForSpecificGroupName.add("groupName=NotTheGroupWeAreModifying");
        permAttrsForSpecificGroupName.add("namespaceCode=KR*");
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_NMSPC_KR, "KR-SYS", permAttrsGeneric));
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_TYPE_DEFAULT, "KR-SYS", permAttrsForSpecificKimTypeName));
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_GROUP_NM, "KR-SYS", permAttrsForSpecificGroupName));
        ArrayList<Permission> immutablePermissionList = new ArrayList<Permission>();
        for (PermissionBo bo : permissionsList) {
            immutablePermissionList.add(PermissionBo.to((PermissionBo)bo));
        }
        List returnedPermissions = this.permissionService.getMatchingPermissions(requestedDetails, immutablePermissionList);
        Assert.assertTrue((returnedPermissions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Permission)returnedPermissions.get(0)).getName().equals(this.PERM_NM_POP_GROUP_TYPE_DEFAULT));
    }

    @Test
    public void testTypeNameMatchOnPopulateGroupPermission2() {
        Map<String, String> requestedDetails = this.getGroupRequestedDetails();
        ArrayList<PermissionBo> permissionsList = new ArrayList<PermissionBo>();
        Template template = KimApiServiceLocator.getPermissionService().findPermTemplateByNamespaceCodeAndName("KR-IDM", "Populate Group");
        ArrayList<String> permAttrsGeneric = new ArrayList<String>();
        permAttrsGeneric.add("namespaceCode=KR*");
        ArrayList<String> permAttrsForSpecificKimTypeName = new ArrayList<String>();
        permAttrsForSpecificKimTypeName.add("namespaceCode=KR*");
        permAttrsForSpecificKimTypeName.add("kimTypeName=Default");
        ArrayList<String> permAttrsForSpecificKimTypeName2 = new ArrayList<String>();
        permAttrsForSpecificKimTypeName2.add("namespaceCode=KFS*");
        permAttrsForSpecificKimTypeName2.add("kimTypeName=Default");
        ArrayList<String> permAttrsForSpecificGroupName = new ArrayList<String>();
        permAttrsForSpecificGroupName.add("groupName=NotTheGroupWeAreModifying");
        permAttrsForSpecificGroupName.add("namespaceCode=KR*");
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_NMSPC_KR, "KR-SYS", permAttrsGeneric));
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_TYPE_DEFAULT, "KR-SYS", permAttrsForSpecificKimTypeName));
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_TYPE_DEFAULT_KFS, "KFS-SYS", permAttrsForSpecificKimTypeName2));
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_GROUP_NM, "KR-SYS", permAttrsForSpecificGroupName));
        ArrayList<Permission> immutablePermissionList = new ArrayList<Permission>();
        for (PermissionBo bo : permissionsList) {
            immutablePermissionList.add(PermissionBo.to((PermissionBo)bo));
        }
        List returnedPermissions = this.permissionService.getMatchingPermissions(requestedDetails, immutablePermissionList);
        Assert.assertTrue((returnedPermissions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Permission)returnedPermissions.get(0)).getName().equals(this.PERM_NM_POP_GROUP_TYPE_DEFAULT));
    }

    @Test
    public void testNamespaceMatchOnPopulateGroupPermission() {
        Map<String, String> requestedDetails = this.getGroupRequestedDetails();
        ArrayList<PermissionBo> permissionsList = new ArrayList<PermissionBo>();
        Template template = KimApiServiceLocator.getPermissionService().findPermTemplateByNamespaceCodeAndName("KR-IDM", "Populate Group");
        ArrayList<String> permAttrsGeneric = new ArrayList<String>();
        permAttrsGeneric.add("namespaceCode=KR*");
        ArrayList<String> permAttrsForSpecificKimTypeName = new ArrayList<String>();
        permAttrsForSpecificKimTypeName.add("namespaceCode=KR*");
        permAttrsForSpecificKimTypeName.add("kimTypeName=NotDefault");
        ArrayList<String> permAttrsForSpecificGroupName = new ArrayList<String>();
        permAttrsForSpecificGroupName.add("groupName=NotTheGroupWeAreModifying");
        permAttrsForSpecificGroupName.add("namespaceCode=KR*");
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_NMSPC_KR, "KR-SYS", permAttrsGeneric));
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_NOT_TYPE_DEFAULT, "KR-SYS", permAttrsForSpecificKimTypeName));
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_GROUP_NM, "KR-SYS", permAttrsForSpecificGroupName));
        ArrayList<Permission> immutablePermissionList = new ArrayList<Permission>();
        for (PermissionBo bo : permissionsList) {
            immutablePermissionList.add(PermissionBo.to((PermissionBo)bo));
        }
        List returnedPermissions = this.permissionService.getMatchingPermissions(requestedDetails, immutablePermissionList);
        Assert.assertTrue((returnedPermissions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Permission)returnedPermissions.get(0)).getName().equals(this.PERM_NM_POP_GROUP_NMSPC_KR));
    }

    @Test
    public void testNamespaceExactMatchOnPopulateGroupPermission() {
        Map<String, String> requestedDetails = this.getGroupRequestedDetails();
        ArrayList<PermissionBo> permissionsList = new ArrayList<PermissionBo>();
        Template template = KimApiServiceLocator.getPermissionService().findPermTemplateByNamespaceCodeAndName("KR-IDM", "Populate Group");
        ArrayList<String> permAttrsSpecficNmspc = new ArrayList<String>();
        permAttrsSpecficNmspc.add("namespaceCode=KR-WKFLW");
        ArrayList<String> permAttrsGeneric = new ArrayList<String>();
        permAttrsGeneric.add("namespaceCode=KR*");
        ArrayList<String> permAttrsGeneric2 = new ArrayList<String>();
        permAttrsGeneric2.add("namespaceCode=KFS*");
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_NMSPC_KR, "KR-SYS", permAttrsGeneric));
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_NMSPC_KR_WKFLW, "KR-SYS", permAttrsSpecficNmspc));
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_NMSPC_KFS, "KR-SYS", permAttrsGeneric2));
        ArrayList<Permission> immutablePermissionList = new ArrayList<Permission>();
        for (PermissionBo bo : permissionsList) {
            immutablePermissionList.add(PermissionBo.to((PermissionBo)bo));
        }
        List returnedPermissions = this.permissionService.getMatchingPermissions(requestedDetails, immutablePermissionList);
        Assert.assertTrue((returnedPermissions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Permission)returnedPermissions.get(0)).getName().equals(this.PERM_NM_POP_GROUP_NMSPC_KR_WKFLW));
    }

    @Test
    public void testNamespaceMultipleMatchOnPopulateGroupPermission() {
        Map<String, String> requestedDetails = this.getGroupRequestedDetails();
        ArrayList<PermissionBo> permissionsList = new ArrayList<PermissionBo>();
        Template template = KimApiServiceLocator.getPermissionService().findPermTemplateByNamespaceCodeAndName("KR-IDM", "Populate Group");
        ArrayList<String> permAttrsAllNmspc = new ArrayList<String>();
        permAttrsAllNmspc.add("namespaceCode=*");
        ArrayList<String> permAttrsGeneric = new ArrayList<String>();
        permAttrsGeneric.add("namespaceCode=KR*");
        ArrayList<String> permAttrsGeneric2 = new ArrayList<String>();
        permAttrsGeneric2.add("namespaceCode=KFS*");
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_NMSPC_KR, "KR-SYS", permAttrsGeneric));
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_NMSPC_ALL, "KR-SYS", permAttrsAllNmspc));
        permissionsList.add(this.createPermission(template, this.PERM_NM_POP_GROUP_NMSPC_KFS, "KR-SYS", permAttrsGeneric2));
        ArrayList<Permission> immutablePermissionList = new ArrayList<Permission>();
        for (PermissionBo bo : permissionsList) {
            immutablePermissionList.add(PermissionBo.to((PermissionBo)bo));
        }
        List returnedPermissions = this.permissionService.getMatchingPermissions(requestedDetails, immutablePermissionList);
        Assert.assertTrue((returnedPermissions.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Permission)returnedPermissions.get(0)).getName().equals(this.PERM_NM_POP_GROUP_NMSPC_KR));
        Assert.assertTrue((boolean)((Permission)returnedPermissions.get(1)).getName().equals(this.PERM_NM_POP_GROUP_NMSPC_ALL));
    }

    private Map<String, String> getGroupRequestedDetails() {
        HashMap<String, String> requestedDetails = new HashMap<String, String>();
        requestedDetails.put("groupName", "WorkflowAdmin");
        requestedDetails.put("namespaceCode", "KR-WKFLW");
        requestedDetails.put("kimTypeName", "Default");
        return requestedDetails;
    }

    private PermissionBo createPermission(Template permissionTemplate, String name, String namespace, List<String> attrs) {
        PermissionBo perm = new PermissionBo();
        perm.setName(name);
        perm.setNamespaceCode(namespace);
        perm.setTemplate(PermissionTemplateBo.from((Template)permissionTemplate));
        perm.setTemplateId(permissionTemplate.getId());
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        for (String attr : attrs) {
            String[] splitAttr = attr.split("=", 2);
            permissionDetails.put(splitAttr[0], splitAttr[1]);
        }
        List attrBos = KimAttributeDataBo.createFrom(PermissionAttributeBo.class, permissionDetails, (String)perm.getTemplate().getKimTypeId());
        perm.setAttributeDetails(attrBos);
        return perm;
    }
}

