/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.api.bus.support.JavaServiceDefinition;
import org.kuali.rice.ksb.api.registry.ServiceInfo;
import org.kuali.rice.ksb.api.registry.ServiceRegistry;
import org.kuali.rice.ksb.messaging.remotedservices.TestRepeatMessageQueue;
import org.kuali.rice.ksb.test.KSBTestCase;

public class ServiceUpdateAndRemovalTest
extends KSBTestCase {
    @Test
    public void testRemovalOfAllLocalServices() throws Exception {
        ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
        ServiceRegistry serviceRegistry = KsbApiServiceLocator.getServiceRegistry();
        List<ServiceInfo> serviceInfos = this.findLocallyPublishedServices(serviceBus.getInstanceId(), serviceRegistry);
        Assert.assertFalse((String)"There should be at least one locally published service in the database.", (boolean)serviceInfos.isEmpty());
        serviceRegistry.takeInstanceOffline(serviceBus.getInstanceId());
        serviceInfos = this.findLocallyPublishedServices(serviceBus.getInstanceId(), serviceRegistry);
        Assert.assertEquals((String)"There should not be any locally published services in the database.", (long)0L, (long)serviceInfos.size());
    }

    private List<ServiceInfo> findLocallyPublishedServices(String instanceId, ServiceRegistry serviceRegistry) {
        ArrayList<ServiceInfo> locallyPublishedServices = new ArrayList<ServiceInfo>();
        List serviceInfos = serviceRegistry.getAllOnlineServices();
        for (ServiceInfo serviceInfo : serviceInfos) {
            if (!serviceInfo.getInstanceId().equals(instanceId)) continue;
            locallyPublishedServices.add(serviceInfo);
        }
        return locallyPublishedServices;
    }

    private ServiceInfo findLocallyPublishedService(String instanceId, QName serviceName, ServiceRegistry serviceRegistry) {
        List<ServiceInfo> locallyPublishedServices = this.findLocallyPublishedServices(instanceId, serviceRegistry);
        for (ServiceInfo serviceInfo : locallyPublishedServices) {
            if (!serviceInfo.getServiceName().equals(serviceName)) continue;
            return serviceInfo;
        }
        return null;
    }

    @Test
    public void testModificationOfLocalServices() throws Exception {
        ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
        ServiceRegistry serviceRegistry = KsbApiServiceLocator.getServiceRegistry();
        QName serviceName = new QName("KEW", "serviceForTestingModifications");
        ServiceInfo regularInfo = null;
        JavaServiceDefinition serviceDefinition = new JavaServiceDefinition();
        serviceDefinition.setServiceName(serviceName);
        serviceDefinition.setPriority(Integer.valueOf(4));
        serviceDefinition.setService((Object)new TestRepeatMessageQueue());
        serviceDefinition.validate();
        serviceBus.publishService((ServiceDefinition)serviceDefinition, true);
        regularInfo = this.findLocallyPublishedService(serviceBus.getInstanceId(), serviceName, serviceRegistry);
        this.assertRegistryRefreshHasExpectedResults(serviceBus, serviceRegistry, regularInfo, serviceName, false);
        regularInfo = this.findLocallyPublishedService(serviceBus.getInstanceId(), serviceName, serviceRegistry);
        serviceDefinition.setPriority(Integer.valueOf(3));
        serviceDefinition.validate();
        this.assertRegistryRefreshHasExpectedResults(serviceBus, serviceRegistry, regularInfo, serviceName, true);
    }

    private void assertRegistryRefreshHasExpectedResults(ServiceBus serviceBus, ServiceRegistry serviceRegistry, ServiceInfo regularInfo, QName serviceName, boolean serviceDefinitionsShouldDiffer) throws Exception {
        serviceBus.synchronize();
        ServiceInfo newRegularInfo = this.findLocallyPublishedService(regularInfo.getInstanceId(), serviceName, serviceRegistry);
        Assert.assertTrue((String)"The ServiceInfo instances for the service should satisy the non-ServiceDefinition part of an isSame() check", (regularInfo.getStatus().equals((Object)newRegularInfo.getStatus()) && regularInfo.getServiceName().equals(newRegularInfo.getServiceName()) && regularInfo.getServerIpAddress().equals(newRegularInfo.getServerIpAddress()) && regularInfo.getApplicationId().equals(newRegularInfo.getApplicationId()) ? 1 : 0) != 0);
        if (serviceDefinitionsShouldDiffer) {
            Assert.assertNotSame((String)"The checksum for the configured service should have been modified after refreshing the registry.", (Object)regularInfo.getChecksum(), (Object)newRegularInfo.getChecksum());
        } else {
            Assert.assertEquals((String)"The checksum for the configured service should not have been modified after refreshing the registry.", (Object)regularInfo.getChecksum(), (Object)newRegularInfo.getChecksum());
        }
    }
}

