/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.testclient1;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.kuali.rice.ksb.messaging.remotedservices.BaseballCard;
import org.kuali.rice.ksb.messaging.remotedservices.BaseballCardCollectionService;
import org.kuali.rice.ksb.messaging.remotedservices.ServiceCallInformationHolder;

public class BaseballCardCollectionServiceImpl
implements BaseballCardCollectionService {
    private Map<Integer, BaseballCard> cards = new ConcurrentHashMap<Integer, BaseballCard>();
    private AtomicInteger nextId = new AtomicInteger(1);

    @Override
    public Integer add(BaseballCard card) {
        Integer result = null;
        if (card != null) {
            int id = this.nextId.addAndGet(1);
            this.cards.put(id, card);
            result = id;
        }
        return result;
    }

    @Override
    public void delete(Integer id) {
        this.cards.remove(id);
    }

    @Override
    public BaseballCard get(Integer id) {
        return this.cards.get(id);
    }

    @Override
    public List<BaseballCard> get(String playerName) {
        ArrayList<BaseballCard> results = new ArrayList<BaseballCard>();
        for (BaseballCard card : this.cards.values()) {
            if (!playerName.equals(card.getPlayerName())) continue;
            results.add(card);
        }
        return results;
    }

    @Override
    public List<BaseballCard> getAll() {
        ServiceCallInformationHolder.stuff.put("capturedHeaders", PhaseInterceptorChain.getCurrentMessage().get((Object)Message.PROTOCOL_HEADERS));
        return new ArrayList<BaseballCard>(this.cards.values());
    }

    @Override
    public void update(Integer id, BaseballCard card) {
        this.cards.put(id, card);
    }

    @Override
    public void unannotatedMethod() {
    }
}

