/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import javax.xml.namespace.QName;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.config.property.SimpleConfig;
import org.kuali.rice.core.impl.config.property.JAXBConfigImpl;
import org.kuali.rice.ksb.api.bus.support.JavaServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.JavaServiceDefinition;
import org.kuali.rice.ksb.messaging.serviceconnectors.HttpInvokerConnector;

public class HttpInvokerConnectorConfigurationTest {
    private static String simpleConfig = "SIMPLE_CONFIG";
    private static String jaxbConfig = "JAXB_CONFIG";

    protected Config getConfigObject(String configType) {
        SimpleConfig cRet = null;
        if (simpleConfig.equals(configType)) {
            cRet = new SimpleConfig();
        } else if (jaxbConfig.equals(configType)) {
            cRet = new JAXBConfigImpl();
        }
        return cRet;
    }

    @Test
    public void testHttpClientConfiguration() throws Exception {
        this.testHttpClientConfigurationImpl(simpleConfig);
        this.testHttpClientConfigurationImpl(jaxbConfig);
    }

    protected void testHttpClientConfigurationImpl(String configType) throws Exception {
        JavaServiceDefinition javaServiceDefinition = new JavaServiceDefinition();
        javaServiceDefinition.setServiceName(new QName("test", "test"));
        JavaServiceConfiguration configuration = JavaServiceConfiguration.fromServiceDefinition((JavaServiceDefinition)javaServiceDefinition);
        ConfigContext.init((Config)this.getConfigObject(configType));
        HttpInvokerConnector httpConnector = new HttpInvokerConnector(configuration, null);
        HttpClient httpClient = httpConnector.getHttpClient();
        HttpConnectionManager connectionManager = httpClient.getHttpConnectionManager();
        Assert.assertTrue((String)"Should be a multi-threaded connection manager.", (boolean)(connectionManager instanceof MultiThreadedHttpConnectionManager));
        int defaultMaxConnectionsPerHost = connectionManager.getParams().getDefaultMaxConnectionsPerHost();
        Assert.assertEquals((long)20L, (long)defaultMaxConnectionsPerHost);
        Assert.assertEquals((long)20L, (long)connectionManager.getParams().getMaxTotalConnections());
        Assert.assertEquals((long)10000L, (long)connectionManager.getParams().getConnectionTimeout());
        Assert.assertEquals((long)10000L, (long)httpClient.getParams().getConnectionManagerTimeout());
        Assert.assertEquals((Object)"rfc2109", (Object)httpClient.getParams().getCookiePolicy());
        Config config = this.getConfigObject(configType);
        config.putProperty("http.connection-manager.max-total", "500");
        config.putProperty("http.connection-manager.timeout", "5000");
        config.putProperty("http.connection.timeout", "15000");
        config.putProperty("http.somerandomproperty", "thisismyproperty");
        config.putProperty("http.authentication.preemptive", "false");
        ConfigContext.init((Config)config);
        httpConnector = new HttpInvokerConnector(configuration, null);
        httpClient = httpConnector.getHttpClient();
        connectionManager = httpClient.getHttpConnectionManager();
        Assert.assertTrue((String)"Should be a multi-threaded connection manager.", (boolean)(connectionManager instanceof MultiThreadedHttpConnectionManager));
        defaultMaxConnectionsPerHost = connectionManager.getParams().getDefaultMaxConnectionsPerHost();
        Assert.assertEquals((long)20L, (long)defaultMaxConnectionsPerHost);
        Assert.assertEquals((long)500L, (long)connectionManager.getParams().getMaxTotalConnections());
        Assert.assertEquals((long)15000L, (long)connectionManager.getParams().getConnectionTimeout());
        Assert.assertEquals((long)5000L, (long)httpClient.getParams().getConnectionManagerTimeout());
        Assert.assertEquals((Object)"rfc2109", (Object)httpClient.getParams().getCookiePolicy());
        Assert.assertFalse((boolean)httpClient.getParams().isAuthenticationPreemptive());
        config = this.getConfigObject(configType);
        config.putProperty("http.authentication.preemptive", "true");
        ConfigContext.init((Config)config);
        httpConnector = new HttpInvokerConnector(configuration, null);
        httpClient = httpConnector.getHttpClient();
        Assert.assertTrue((boolean)httpClient.getParams().isAuthenticationPreemptive());
        config = this.getConfigObject(configType);
        config.putProperty("http.connection-manager.class", MyHttpConnectionManager.class.getName());
        ConfigContext.init((Config)config);
        httpConnector = new HttpInvokerConnector(configuration, null);
        httpClient = httpConnector.getHttpClient();
        connectionManager = httpClient.getHttpConnectionManager();
        Assert.assertTrue((String)"Should be a MyHttpConnectionManager.", (boolean)(connectionManager instanceof MyHttpConnectionManager));
        config = this.getConfigObject(configType);
        config.putProperty("http.method.retry-handler", "badparm");
        ConfigContext.init((Config)config);
        try {
            httpConnector = new HttpInvokerConnector(configuration, null);
            Assert.fail((String)"An exception should have been thrown because the retry handler is an illegal parameter.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class MyHttpConnectionManager
    extends SimpleHttpConnectionManager {
    }
}

