/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ksb.api.messaging.ResourceFacade;
import org.kuali.rice.ksb.messaging.remotedservices.BaseballCard;
import org.kuali.rice.ksb.messaging.remotedservices.BaseballCardCollectionService;
import org.kuali.rice.ksb.messaging.remotedservices.Inbox;
import org.kuali.rice.ksb.messaging.remotedservices.InboxResource;
import org.kuali.rice.ksb.messaging.remotedservices.Message;
import org.kuali.rice.ksb.messaging.remotedservices.MessageResource;
import org.kuali.rice.ksb.test.KSBTestCase;

public class RESTServiceTest
extends KSBTestCase {
    private static final String BBCARD_SERVICE = "baseballCardCollectionService";
    private static final String KMS_SERVICE = "kms";
    private static final String NAMESPACE = "test";

    @Override
    public boolean startClient1() {
        return true;
    }

    @Test
    public void testMessagingService() throws Exception {
        ResourceFacade kmsService = (ResourceFacade)GlobalResourceLoader.getService((QName)new QName(NAMESPACE, KMS_SERVICE));
        InboxResource inboxResource = (InboxResource)kmsService.getResource("inbox");
        MessageResource messageResource = (MessageResource)kmsService.getResource(MessageResource.class);
        this.exerciseMessagingService(inboxResource, messageResource);
    }

    private void exerciseMessagingService(InboxResource inboxResource, MessageResource messageResource) {
        Inbox inbox = new Inbox();
        inbox.setOwner("Joe Q. Tester");
        inbox = inboxResource.createInbox(inbox);
        Message message = new Message();
        message.setRecipient("Joe Q. Tester");
        message.setSubject("Hello new world!");
        message.setText("This is a test message.");
        Message createdMessage = messageResource.createMessage(message);
        List<String> messages = inbox.getMessages();
        messages.add(createdMessage.getId());
        inboxResource.updateInbox(inbox);
        inbox = inboxResource.retrieveInbox(inbox.getId());
        List<String> updatedMessages = inbox.getMessages();
        String updatedMessageId = updatedMessages.get(0);
        Message retrievedMessage = messageResource.retrieve(updatedMessageId);
        Assert.assertTrue((boolean)retrievedMessage.getSubject().equals("Hello new world!"));
    }

    @Test
    public void testBaseballCardCollectionService() {
        BaseballCard cardA = new BaseballCard("Mickey Mantle", "Topps", 1952);
        BaseballCard cardB = new BaseballCard("Ted Williams", "Bowman", 1954);
        BaseballCard cardC = new BaseballCard("Willie Mays", "Bowman", 1951);
        BaseballCard cardD = new BaseballCard("Willie Mays Hayes", "Bogus", 1989);
        BaseballCardCollectionService service = (BaseballCardCollectionService)GlobalResourceLoader.getService((QName)new QName(NAMESPACE, BBCARD_SERVICE));
        service.add(cardA);
        service.add(cardB);
        Integer willieMaysId = service.add(cardC);
        List<BaseballCard> allCards = service.getAll();
        Assert.assertNotNull(allCards);
        Assert.assertTrue((allCards.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)allCards.contains(cardA));
        Assert.assertTrue((boolean)allCards.contains(cardB));
        Assert.assertTrue((boolean)allCards.contains(cardC));
        service.update(willieMaysId, cardD);
        allCards = service.getAll();
        Assert.assertNotNull(allCards);
        Assert.assertTrue((allCards.size() == 3 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)allCards.contains(cardC));
        Assert.assertTrue((boolean)allCards.contains(cardD));
        service.delete(willieMaysId);
        allCards = service.getAll();
        Assert.assertNotNull(allCards);
        Assert.assertTrue((allCards.size() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)allCards.contains(cardD));
        service.add(cardA);
        service.add(cardA);
        service.add(cardA);
        allCards = service.getAll();
        Assert.assertTrue((allCards.size() == 5 ? 1 : 0) != 0);
        try {
            service.unannotatedMethod();
            Assert.fail((String)"Magic?  You can't remotely invoke a method that doesn't have JAX-RS annotations in the resource class!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

