/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import org.apache.log4j.Logger;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.exceptionhandling.DefaultExceptionServiceImpl;
import org.kuali.rice.test.TestUtilities;
import org.kuali.rice.test.ThreadMonitor;

public class TestExceptionRoutingServiceImpl
extends DefaultExceptionServiceImpl {
    private static final Logger LOG = Logger.getLogger(TestExceptionRoutingServiceImpl.class);

    public void placeInExceptionRouting(Throwable throwable, PersistedMessageBO message, Object service) {
        ExceptionThreader exceptionThreader = new ExceptionThreader(throwable, message, service, this);
        ThreadMonitor.addThread((Thread)exceptionThreader);
        exceptionThreader.start();
    }

    public void callRealPlaceInExceptionRouting(Throwable throwable, PersistedMessageBO message, Object service) throws Exception {
        super.placeInExceptionRouting(throwable, message, service);
    }

    private static class ExceptionThreader
    extends Thread {
        private Throwable throwable;
        private PersistedMessageBO message;
        private Object service;
        private TestExceptionRoutingServiceImpl testExceptionService;

        public ExceptionThreader(Throwable throwable, PersistedMessageBO message, Object service, TestExceptionRoutingServiceImpl testExceptionService) {
            this.throwable = throwable;
            this.message = message;
            this.service = service;
            this.testExceptionService = testExceptionService;
            TestUtilities.setExceptionThreader((Thread)this);
        }

        @Override
        public void run() {
            try {
                this.testExceptionService.callRealPlaceInExceptionRouting(this.throwable, this.message, this.service);
            }
            catch (Throwable t) {
                LOG.fatal((Object)"Error executing callRealPlaceInExceptionRouting.", t);
            }
        }
    }
}

