/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.exceptionhandling;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.JavaServiceConfiguration;
import org.kuali.rice.ksb.api.messaging.AsynchronousCall;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.PersistedMessagePayload;
import org.kuali.rice.ksb.messaging.exceptionhandling.DefaultMessageExceptionHandler;
import org.kuali.rice.ksb.test.KSBTestCase;

public class DefaultMessageExceptionHandlerTest
extends KSBTestCase {
    private PersistedMessageBO setupMessage(Integer retriesAttempted, Integer serviceMaxRetries) throws Exception {
        PersistedMessageBO message = new PersistedMessageBO();
        message.setRetryCount(retriesAttempted);
        JavaServiceConfiguration.Builder builder = JavaServiceConfiguration.Builder.create();
        builder.setRetryAttempts(serviceMaxRetries);
        AsynchronousCall methodCall = new AsynchronousCall(new Class[0], new Object[0], (ServiceConfiguration)builder.build(), "", null, null);
        message.setPayload(new PersistedMessagePayload(methodCall, message));
        message.setMethodCall(methodCall);
        return message;
    }

    private void setMaxRetries(String maxRetries) {
        ConfigContext.getCurrentContextConfig().putProperty("RouteQueue.maxRetryAttemptsOverride", maxRetries);
    }

    @Test
    public void testGetGlobalMaxRetryAttempts() throws Exception {
        DefaultMessageExceptionHandler exceptionHandler = new DefaultMessageExceptionHandler();
        this.setMaxRetries("0");
        this.setMaxRetries("B");
        Assert.assertNull((String)"Method should return null if app constant is non-numeric.", (Object)exceptionHandler.getGlobalMaxRetryAttempts());
        this.setMaxRetries("-10");
        Assert.assertNull((String)"Method should return null if app constant is negative number.", (Object)exceptionHandler.getGlobalMaxRetryAttempts());
        this.setMaxRetries("-1");
        Assert.assertNull((String)"Method should return null if app constant is negative number.", (Object)exceptionHandler.getGlobalMaxRetryAttempts());
        this.setMaxRetries("0");
        Assert.assertEquals((String)"Method should return app constant value if app constant is numeric and greater than or equal to zero.", (Object)new Integer(0), (Object)exceptionHandler.getGlobalMaxRetryAttempts());
        this.setMaxRetries("1");
        Assert.assertEquals((String)"Method should return app constant value if app constant is numeric and greater than or equal to zero.", (Object)new Integer(1), (Object)exceptionHandler.getGlobalMaxRetryAttempts());
        this.setMaxRetries("5");
        Assert.assertEquals((String)"Method should return app constant value if app constant is numeric and greater than or equal to zero.", (Object)new Integer(5), (Object)exceptionHandler.getGlobalMaxRetryAttempts());
    }

    @Test
    public void testIsInException() throws Exception {
        DefaultMessageExceptionHandler exceptionHandler = new DefaultMessageExceptionHandler();
        PersistedMessageBO message = null;
        this.setMaxRetries("-10");
        message = this.setupMessage(0, 1);
        Assert.assertFalse((boolean)exceptionHandler.isInException(message));
        message.setRetryCount(Integer.valueOf(1));
        Assert.assertTrue((boolean)exceptionHandler.isInException(message));
        message.setRetryCount(Integer.valueOf(2));
        Assert.assertTrue((boolean)exceptionHandler.isInException(message));
        this.setMaxRetries("5");
        message.setRetryCount(Integer.valueOf(4));
        Assert.assertFalse((boolean)exceptionHandler.isInException(message));
        message.setRetryCount(Integer.valueOf(5));
        Assert.assertTrue((boolean)exceptionHandler.isInException(message));
        message.setRetryCount(Integer.valueOf(6));
        Assert.assertTrue((boolean)exceptionHandler.isInException(message));
        this.setMaxRetries("0");
        message.setRetryCount(Integer.valueOf(0));
        Assert.assertTrue((boolean)exceptionHandler.isInException(message));
        message.setRetryCount(Integer.valueOf(1));
        Assert.assertTrue((boolean)exceptionHandler.isInException(message));
        this.setMaxRetries("-1");
        message.setRetryCount(Integer.valueOf(0));
        Assert.assertFalse((boolean)exceptionHandler.isInException(message));
        message = this.setupMessage(1, 5);
        Assert.assertFalse((boolean)exceptionHandler.isInException(message));
        this.setMaxRetries("B");
        message.setRetryCount(Integer.valueOf(0));
        Assert.assertFalse((boolean)exceptionHandler.isInException(message));
    }
}

