/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.exceptionhandling;

import java.io.Serializable;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.messaging.GlobalCallbackRegistry;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.TestCallback;
import org.kuali.rice.ksb.messaging.remotedservices.TesetHarnessExplodingQueue;
import org.kuali.rice.ksb.messaging.service.KSBJavaService;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.test.KSBTestCase;
import org.kuali.rice.test.TestUtilities;

public class ExceptionMessagingTest
extends KSBTestCase {
    private QName queueTimeToLiveServiceName = new QName("KEW", "explodingQueueTimeLimit");
    private TestCallback callback = new TestCallback();

    @Override
    public void setUp() throws Exception {
        System.setProperty("RouteQueue.timeIncrement", "500");
        System.setProperty("RouteQueue.maxRetryAttempts", "5");
        super.setUp();
        GlobalCallbackRegistry.getCallbacks().clear();
        GlobalCallbackRegistry.getCallbacks().add(this.callback);
        TestCallback.clearCallbacks();
        TesetHarnessExplodingQueue.NUM_CALLS = 0;
    }

    public void tearDown() throws Exception {
        try {
            KSBServiceLocator.getScheduler().shutdown();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testTimeToLive() throws Exception {
        KSBJavaService explodingQueue = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(this.queueTimeToLiveServiceName);
        explodingQueue.invoke((Serializable)((Object)""));
        TestUtilities.waitForExceptionRouting();
        Thread.sleep(10000L);
        List messagesQueued = KSBServiceLocator.getMessageQueueService().findByServiceName(this.queueTimeToLiveServiceName, "invoke");
        PersistedMessageBO message = (PersistedMessageBO)messagesQueued.get(0);
        Assert.assertEquals((String)"Message should be in exception status", (Object)"E", (Object)message.getQueueStatus());
        Assert.assertTrue((String)"Message expiration date should be equal to or earlier than last queue date", (message.getExpirationDate().getTime() <= message.getQueueDate().getTime() ? 1 : 0) != 0);
    }
}

