/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.JavaServiceConfiguration;
import org.kuali.rice.ksb.messaging.remotedservices.EchoService;
import org.kuali.rice.ksb.messaging.serviceconnectors.HttpInvokerConnector;
import org.kuali.rice.ksb.server.TestClient1;
import org.kuali.rice.ksb.test.KSBTestCase;

public class HttpInvokerConnectorTest
extends KSBTestCase {
    private static final QName serviceName = new QName("urn:TestCl1", "httpInvoker-echoServiceSecure");

    @Override
    public boolean startClient1() {
        return true;
    }

    @Before
    public void setup() {
        KsbApiServiceLocator.getServiceBus().synchronize();
    }

    @Test
    public void testHttpInvokerServiceCall() {
        Endpoint endpoint = KsbApiServiceLocator.getServiceBus().getEndpoint(serviceName);
        Assert.assertTrue((boolean)"httpInvoker".equals(endpoint.getServiceConfiguration().getType()));
        EchoService echoService = (EchoService)KsbApiServiceLocator.getServiceBus().getService(serviceName);
        Assert.assertTrue((boolean)"foo".equals(echoService.echo("foo")));
    }

    @Test
    public void testSecureHttpInvokerServiceCall() throws MalformedURLException {
        Endpoint endpoint = KsbApiServiceLocator.getServiceBus().getEndpoint(serviceName);
        Assert.assertTrue((boolean)"httpInvoker".equals(endpoint.getServiceConfiguration().getType()));
        ServiceConfiguration serviceConfiguration = endpoint.getServiceConfiguration();
        URL endpointUrl = serviceConfiguration.getEndpointUrl();
        TestClient1.ConfigConstants configConstants = new TestClient1.ConfigConstants();
        URL httpsUrl = new URL("https", endpointUrl.getHost(), configConstants.SERVER_HTTPS_PORT, endpointUrl.getFile());
        HttpInvokerConnector connector = new HttpInvokerConnector((JavaServiceConfiguration)serviceConfiguration, httpsUrl);
        EchoService httpsEchoService = (EchoService)connector.getService();
        Assert.assertTrue((boolean)"foo".equals(httpsEchoService.echo("foo")));
    }
}

