/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ksb.messaging.remotedservices.EchoService;
import org.kuali.rice.ksb.messaging.remotedservices.JaxWsEchoService;
import org.kuali.rice.ksb.messaging.remotedservices.SOAPService;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.test.KSBTestCase;

public class SOAPServiceTest
extends KSBTestCase {
    @Override
    public boolean startClient1() {
        return true;
    }

    private String getEndpointUrl() {
        return "http://localhost:" + this.getClient1Port() + "/TestClient1/remoting/secure/soap-echoServiceSecure";
    }

    private String getWsdlUrl() {
        return "http://localhost:" + this.getClient1Port() + "/TestClient1/remoting/soap-echoService?wsdl";
    }

    private String getClient1Port() {
        return ConfigContext.getCurrentContextConfig().getProperty("ksb.client1.port");
    }

    @Test
    public void testSimpleSOAPService() throws Exception {
        EchoService echoService = (EchoService)GlobalResourceLoader.getService((QName)new QName("TestCl1", "soap-echoService"));
        String result = echoService.trueEcho("Yo yo yo");
        Assert.assertNotNull((Object)result);
        QName serviceName = new QName("testNameSpace", "soap-repeatTopic");
        SOAPService soapService = (SOAPService)GlobalResourceLoader.getService((QName)serviceName);
        soapService.doTheThing("hello");
    }

    @Test
    public void testJaxWsSOAPService() {
        JaxWsEchoService jaxwsEchoService = (JaxWsEchoService)GlobalResourceLoader.getService((QName)new QName("TestCl1", "jaxwsEchoService"));
        String result = jaxwsEchoService.doEcho("Fi Fi Fo Fum");
        Assert.assertTrue((boolean)"Fi Fi Fo Fum".equals(result));
    }

    @Test
    public void testBusSecureSOAPService() throws Exception {
        ClientProxyFactoryBean clientFactory = new ClientProxyFactoryBean();
        clientFactory.setBus(KSBServiceLocator.getCXFBus());
        clientFactory.getServiceFactory().setDataBinding((DataBinding)new AegisDatabinding());
        clientFactory.setServiceClass(EchoService.class);
        clientFactory.setServiceName(new QName("urn:TestCl1", "soap-echoServiceSecure"));
        clientFactory.setAddress(new URI(this.getEndpointUrl()).toString());
        clientFactory.getInInterceptors().add(new LoggingInInterceptor());
        clientFactory.getOutInterceptors().add(new LoggingOutInterceptor());
        EchoService echoService = (EchoService)clientFactory.create();
        try {
            echoService.echo("I can't echo");
            Assert.fail((String)"Expected failure using non-secure client with secure service");
        }
        catch (SoapFault sf) {
            sf.printStackTrace();
            Assert.assertTrue((String)"Non-secure client did not get expected exception.", (boolean)sf.getMessage().startsWith("An error was discovered processing the <wsse:Security> header"));
        }
        echoService = (EchoService)GlobalResourceLoader.getService((QName)new QName("urn:TestCl1", "soap-echoServiceSecure"));
        String result = echoService.echo("I can echo");
        Assert.assertTrue((boolean)"I can echo".equals(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWsdlGeneration() throws Exception {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
            Client client = dcf.createClient(new URI(this.getWsdlUrl()).toString());
            client.getInInterceptors().add(new LoggingInInterceptor());
            client.getOutInterceptors().add(new LoggingOutInterceptor());
            Object[] results = client.invoke("echo", new Object[]{"testing"});
            Assert.assertNotNull((Object)results);
            Assert.assertEquals((long)1L, (long)results.length);
            Assert.assertEquals((Object)"testing", (Object)results[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

