/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ksb.messaging.remotedservices.BaseballCard;
import org.kuali.rice.ksb.messaging.remotedservices.BaseballCardCollectionService;
import org.kuali.rice.ksb.messaging.remotedservices.EchoService;
import org.kuali.rice.ksb.messaging.remotedservices.JaxWsEchoService;
import org.kuali.rice.ksb.messaging.remotedservices.ServiceCallInformationHolder;
import org.kuali.rice.ksb.test.KSBTestCase;

public class ServiceCallVersioningTest
extends KSBTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        Config c = ConfigContext.getCurrentContextConfig();
        c.putProperty("application.name", "ServiceCallVersioningTest");
        c.putProperty("application.version", "99.99-SNAPSHOT");
    }

    @Override
    public boolean startClient1() {
        return true;
    }

    private String getClient1Port() {
        return ConfigContext.getCurrentContextConfig().getProperty("ksb.client1.port");
    }

    @Test
    public void testSimpleSOAPService() throws Exception {
        EchoService echoService = (EchoService)GlobalResourceLoader.getService((QName)new QName("TestCl1", "soap-echoService"));
        echoService.captureHeaders();
        this.assertHeadersCaptured();
    }

    @Test
    public void testJaxWsSOAPService() {
        JaxWsEchoService jaxwsEchoService = (JaxWsEchoService)GlobalResourceLoader.getService((QName)new QName("TestCl1", "jaxwsEchoService"));
        jaxwsEchoService.captureHeaders();
        this.assertHeadersCaptured();
    }

    @Test
    public void testJaxRsService() {
        BaseballCardCollectionService service = (BaseballCardCollectionService)GlobalResourceLoader.getService((QName)new QName("test", "baseballCardCollectionService"));
        List<BaseballCard> allCards = service.getAll();
        Assert.assertNotNull(allCards);
        this.assertHeadersCaptured();
    }

    public void assertHeadersCaptured() {
        Map<String, List<String>> headers = ServiceCallInformationHolder.multiValues;
        Assert.assertNotNull(headers);
        System.out.println("HEADERS");
        System.out.println(headers);
        Assert.assertTrue((boolean)headers.get("X-Kuali-Env").contains("dev"));
        Assert.assertTrue((boolean)headers.get("X-Kuali-Rice-Ver").contains(ConfigContext.getCurrentContextConfig().getRiceVersion()));
        Assert.assertTrue((boolean)headers.get("X-Kuali-App-Name").contains("ServiceCallVersioningTest"));
        Assert.assertTrue((boolean)headers.get("X-Kuali-App-Ver").contains("99.99-SNAPSHOT"));
    }
}

