/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.server;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.security.credentials.CredentialsSourceFactory;
import org.kuali.rice.ksb.BaseTestServer;
import org.kuali.rice.ksb.security.credentials.UsernamePasswordCredentialsSource;

public class TestClient1
extends BaseTestServer {
    private static final Logger LOG = Logger.getLogger(TestClient1.class);

    @Override
    protected Server createServer() {
        this.registerTestCredentialsSourceFactory();
        ConfigConstants configConstants = new ConfigConstants();
        Server server = new Server();
        SelectChannelConnector connector0 = new SelectChannelConnector();
        connector0.setPort(configConstants.SERVER_HTTP_PORT.intValue());
        connector0.setMaxIdleTime(30000);
        connector0.setRequestHeaderSize(8192);
        SslSelectChannelConnector ssl_connector = new SslSelectChannelConnector();
        ssl_connector.setPort(configConstants.SERVER_HTTPS_PORT.intValue());
        SslContextFactory cf = ssl_connector.getSslContextFactory();
        cf.setKeyStorePath(configConstants.KEYSTORE_PATH);
        cf.setKeyStorePassword(configConstants.KEYSTORE_PASS);
        cf.setKeyManagerPassword(configConstants.KEYSTORE_PASS);
        server.setConnectors(new Connector[]{connector0, ssl_connector});
        URL webRoot = this.getClass().getClassLoader().getResource(configConstants.WEB_ROOT);
        String location = webRoot.getPath();
        LOG.debug((Object)"#####################################");
        LOG.debug((Object)"#");
        LOG.debug((Object)("#  Starting Client1 using following web root " + location));
        LOG.debug((Object)"#");
        LOG.debug((Object)"#####################################");
        WebAppContext context = new WebAppContext();
        context.setResourceBase(location);
        context.setContextPath(configConstants.CONTEXT);
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)context);
        server.setHandler((Handler)handlers);
        server.setDumpAfterStart(true);
        return server;
    }

    private void registerTestCredentialsSourceFactory() {
        List<UsernamePasswordCredentialsSource> credentialsSources = Collections.singletonList(new UsernamePasswordCredentialsSource("gilesp", "thuperthecret"));
        CredentialsSourceFactory credentialsSourceFactory = new CredentialsSourceFactory();
        credentialsSourceFactory.setCredentialsSources(credentialsSources);
        try {
            credentialsSourceFactory.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RiceRuntimeException((Throwable)e);
        }
        ConfigContext.getCurrentContextConfig().putObject("credentialsSourceFactory", (Object)credentialsSourceFactory);
    }

    public static final class ConfigConstants {
        public final String WEB_ROOT = "org/kuali/rice/ksb/testclient1";
        public final String CONTEXT = "/TestClient1";
        public final Integer SERVER_HTTP_PORT = Integer.valueOf(ConfigContext.getCurrentContextConfig().getProperty("ksb.client1.port"));
        public final Integer SERVER_HTTPS_PORT = Integer.valueOf(ConfigContext.getCurrentContextConfig().getProperty("ksb.client1.ssl.port"));
        public final String KEYSTORE_PASS = ConfigContext.getCurrentContextConfig().getKeystorePassword();
        public final String KEYSTORE_PATH;

        public ConfigConstants() {
            String keystoreFileTmp = null;
            try {
                keystoreFileTmp = ConfigContext.getCurrentContextConfig().getKeystoreFile();
            }
            catch (Exception e) {
                throw new RiceRuntimeException("Couldn't get keystore file location", (Throwable)e);
            }
            this.KEYSTORE_PATH = keystoreFileTmp;
        }
    }
}

