/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.vc.test;

import com.predic8.schema.ComplexType;
import com.predic8.schema.Sequence;
import com.predic8.soamodel.Difference;
import com.predic8.wsdl.Definitions;
import com.predic8.wsdl.Operation;
import com.predic8.wsdl.PortType;
import com.predic8.wsdl.WSDLParser;
import com.predic8.wsdl.diff.WsdlDiffGenerator;
import com.predic8.xml.util.ResourceDownloadException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK)
public abstract class WsdlCompareTestCase
extends BaselineTestCase {
    private static final Logger LOG = Logger.getLogger(WsdlCompareTestCase.class);
    private static final String WSDL_URL = "wsdl.test.previous.url";
    private static final String WSDL_PREVIOUS_VERSION = "wsdl.test.previous.version";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String previousVersion;
    private static final List<String> ignoreBreakageRegexps = Arrays.asList(".*Position of any changed from .*", ".*Position of element null changed.$", " *ComplexType [^ ]* removed.$", " *Element [^ ]* removed.$", " *SimpleType [^ ]* removed.$");
    private static List<MavenVersion> riceMavenVersions = null;
    private static final Comparator<MavenVersion> mavenVersionTimestampComparator = new Comparator<MavenVersion>(){

        @Override
        public int compare(MavenVersion o1, MavenVersion o2) {
            return o1.getTimestamp().compareTo(o2.getTimestamp());
        }
    };

    public WsdlCompareTestCase(String moduleName) {
        super(moduleName);
    }

    protected List<String> verifyWsdlDifferences(Difference diff, String level) {
        String returnTypeBreakageString;
        ArrayList<String> results = new ArrayList<String>();
        if (diff.isBreaks()) {
            boolean ignore = false;
            for (String ignoreBreakageRegexp : ignoreBreakageRegexps) {
                if (!diff.getDescription().matches(ignoreBreakageRegexp)) continue;
                ignore = true;
                break;
            }
            if (ignore) {
                LOG.info((Object)(level + "non-breaking change: " + diff.getDescription()));
            } else {
                LOG.error((Object)(level + "breaking change: " + diff.getType() + diff.getDescription()));
                results.add(level + diff.getDescription());
            }
        } else {
            LOG.trace((Object)(level + "trivial change: " + diff.getDescription()));
        }
        String opBreakageString = this.checkForOperationBasedChanges(diff);
        if (opBreakageString != null) {
            results.add(level + opBreakageString);
        }
        if ((returnTypeBreakageString = this.checkForFormerlyVoidResponse(diff)) != null) {
            results.add(level + returnTypeBreakageString);
        }
        for (Difference moreDiff : diff.getDiffs()) {
            List<String> childBreakages = this.verifyWsdlDifferences(moreDiff, level + "  ");
            for (String childBreakage : childBreakages) {
                if (!diff.getDescription().trim().startsWith("Schema ")) {
                    results.add(level + diff.getDescription() + LINE_SEPARATOR + childBreakage);
                    continue;
                }
                results.add(childBreakage);
            }
        }
        return results;
    }

    private String checkForOperationBasedChanges(Difference diff) {
        if ("sequence".equals(diff.getType()) && diff.getA() != null && diff.getB() != null) {
            Sequence oldSequence = (Sequence)diff.getA();
            Sequence newSequence = (Sequence)diff.getB();
            if (newSequence.getParent() instanceof ComplexType) {
                Operation operation;
                ComplexType parent = (ComplexType)newSequence.getParent();
                String serviceName = newSequence.getSchema().getDefinitions().getName();
                PortType portType = newSequence.getSchema().getDefinitions().getPortType(serviceName);
                if (portType != null && (operation = portType.getOperation((Object)parent.getName())) != null) {
                    return "Element cannot be added to a sequence if sequence is an Operation " + diff.getDescription();
                }
            }
        }
        return null;
    }

    private String checkForFormerlyVoidResponse(Difference diff) {
        if (!"sequence".equals(diff.getType()) || diff.getA() == null || diff.getB() == null) {
            return null;
        }
        Sequence oldSequence = (Sequence)diff.getA();
        Sequence newSequence = (Sequence)diff.getB();
        if (!(newSequence.getParent() instanceof ComplexType)) {
            return null;
        }
        ComplexType parent = (ComplexType)newSequence.getParent();
        if (!parent.getName().endsWith("Response")) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)oldSequence.getElements()) && CollectionUtils.isNotEmpty((Collection)newSequence.getElements())) {
            return "Element cannot be added to a previously empty return";
        }
        return null;
    }

    protected List<Difference> compareWsdlDefinitions(String oldWsdl, String newWsdl) {
        Definitions wsdl2;
        Definitions wsdl1;
        WSDLParser parser = new WSDLParser();
        try {
            wsdl1 = parser.parse(oldWsdl);
        }
        catch (ResourceDownloadException e) {
            LOG.info((Object)("Couldn't download " + oldWsdl + ", maybe the service didn't exist in this version?"));
            return Collections.emptyList();
        }
        try {
            wsdl2 = parser.parse(newWsdl);
        }
        catch (ResourceDownloadException e) {
            LOG.info((Object)("Couldn't download" + newWsdl + ", maybe the service didn't exist in this version?"));
            return Collections.emptyList();
        }
        WsdlDiffGenerator diffGen = new WsdlDiffGenerator(wsdl1, wsdl2);
        return diffGen.compare();
    }

    protected String getPreviousVersionWsdlUrl(String wsdlFile, MavenVersion previousVersion) {
        StringBuilder oldWsdl = new StringBuilder(this.buildWsdlUrlPrefix(previousVersion.getOriginalForm()));
        oldWsdl.append("rice-");
        oldWsdl.append(this.getModuleName());
        oldWsdl.append("-api-");
        oldWsdl.append(previousVersion.getOriginalForm());
        oldWsdl.append("-");
        oldWsdl.append(wsdlFile);
        return oldWsdl.toString();
    }

    private String buildWsdlUrlPrefix(String previousVersion) {
        String wsdlUrl = ConfigContext.getCurrentContextConfig().getProperty(WSDL_URL);
        if (StringUtils.isNotBlank((String)wsdlUrl) && StringUtils.isNotBlank((String)previousVersion)) {
            StringBuilder urlBuilder = new StringBuilder(wsdlUrl);
            if (!wsdlUrl.endsWith("/")) {
                urlBuilder.append("/");
            }
            urlBuilder.append("rice-");
            urlBuilder.append(this.getModuleName());
            urlBuilder.append("-api/");
            urlBuilder.append(previousVersion);
            urlBuilder.append("/");
            return urlBuilder.toString();
        }
        throw new RuntimeException("Couldn't build wsdl url prefix");
    }

    protected Map<String, List<VersionTransition>> getWsdlVersionTransitionBlacklists() {
        return new HashMap<String, List<VersionTransition>>();
    }

    protected void compareWsdlFiles(File[] wsdlFiles) {
        ArrayList<VersionCompatibilityBreakage> breakages = new ArrayList<VersionCompatibilityBreakage>();
        Assert.assertTrue((String)"There should be wsdls to compare", (wsdlFiles != null && wsdlFiles.length > 0 ? 1 : 0) != 0);
        MavenVersion previousVersion = new MavenVersion(this.getPreviousVersion(), "0");
        MavenVersion currentVersion = this.getCurrentMavenVersion();
        List<MavenVersion> versions = this.getVersionRange(previousVersion, currentVersion);
        List<VersionTransition> transitions = this.generateVersionTransitions(currentVersion, versions);
        for (File wsdlFile : wsdlFiles) {
            if (!wsdlFile.getName().endsWith(".wsdl")) continue;
            LOG.info((Object)("TESTING WSDL: " + wsdlFile.getAbsolutePath()));
            String newWsdl = wsdlFile.getAbsolutePath();
            List<VersionTransition> wsdlTransitionBlacklist = this.getWsdlVersionTransitionBlacklists().get(this.getServiceNameFromWsdlFile(wsdlFile));
            if (wsdlTransitionBlacklist == null) {
                wsdlTransitionBlacklist = Collections.emptyList();
            }
            for (VersionTransition transition : transitions) {
                if (!wsdlTransitionBlacklist.contains(transition)) {
                    breakages.addAll(this.testWsdlVersionTransition(currentVersion, wsdlFile, transition));
                    continue;
                }
                LOG.info((Object)("Ignoring blacklisted " + transition));
            }
        }
        if (!breakages.isEmpty()) {
            Assert.fail((String)this.buildBreakagesSummary(breakages));
        }
    }

    String getServiceNameFromWsdlFile(File wsdlFile) {
        String fileName = wsdlFile.getName();
        int beginIndex = 1 + fileName.lastIndexOf(45);
        int endIndex = fileName.lastIndexOf(46);
        return fileName.substring(beginIndex, endIndex);
    }

    private List<VersionCompatibilityBreakage> testWsdlVersionTransition(MavenVersion currentVersion, File wsdlFile, VersionTransition transition) {
        ArrayList<VersionCompatibilityBreakage> breakages = new ArrayList<VersionCompatibilityBreakage>();
        String fromVersionWsdlUrl = this.getPreviousVersionWsdlUrl(wsdlFile.getName(), transition.getFromVersion());
        String toVersionWsdlUrl = this.getPreviousVersionWsdlUrl(wsdlFile.getName(), transition.getToVersion());
        if (transition.getToVersion().equals(currentVersion)) {
            toVersionWsdlUrl = wsdlFile.getAbsolutePath();
        }
        this.getPreviousVersionWsdlUrl(wsdlFile.getName(), transition.getToVersion());
        LOG.info((Object)("checking " + transition));
        if (fromVersionWsdlUrl == null) {
            LOG.warn((Object)("SKIPPING check, wsdl not found for " + fromVersionWsdlUrl));
        } else if (toVersionWsdlUrl == null) {
            LOG.warn((Object)("SKIPPING check, wsdl not found for " + toVersionWsdlUrl));
        } else {
            List<Difference> differences = this.compareWsdlDefinitions(fromVersionWsdlUrl, toVersionWsdlUrl);
            for (Difference diff : differences) {
                List<String> breakageStrings = this.verifyWsdlDifferences(diff, "");
                for (String breakage : breakageStrings) {
                    breakages.add(new VersionCompatibilityBreakage(transition.fromVersion, transition.toVersion, fromVersionWsdlUrl, toVersionWsdlUrl, breakage));
                }
            }
        }
        return breakages;
    }

    protected List<VersionTransition> generateVersionTransitions(MavenVersion currentVersion, List<MavenVersion> versions) {
        ArrayList<VersionTransition> results = new ArrayList<VersionTransition>();
        versions = new ArrayList<MavenVersion>(versions);
        Collections.sort(versions, mavenVersionTimestampComparator);
        Collections.reverse(versions);
        MavenVersion currentMinorVersion = this.trimToMinorVersion(currentVersion);
        MavenVersion buildingTransitionsTo = currentVersion;
        HashSet<MavenVersion> minorVersionsFrom = new HashSet<MavenVersion>();
        for (MavenVersion version : versions) {
            if (version.compareTo(buildingTransitionsTo) >= 0) continue;
            MavenVersion minorVersion = this.trimToMinorVersion(version);
            if (minorVersion.equals(currentMinorVersion)) {
                results.add(new VersionTransition(version, buildingTransitionsTo));
                buildingTransitionsTo = version;
                minorVersionsFrom.clear();
                continue;
            }
            if (minorVersionsFrom.contains(minorVersion)) continue;
            results.add(new VersionTransition(version, buildingTransitionsTo));
            minorVersionsFrom.add(minorVersion);
        }
        Collections.reverse(results);
        return results;
    }

    private MavenVersion trimToMinorVersion(MavenVersion fullVersion) {
        return new MavenVersion("" + fullVersion.getNumbers().get(0) + "." + fullVersion.getNumbers().get(1), "0");
    }

    protected String buildBreakagesSummary(List<VersionCompatibilityBreakage> breakages) {
        StringBuilder errorsStringBuilder = new StringBuilder(LINE_SEPARATOR + "!!!!! Detected " + breakages.size() + " VC Breakages !!!!!" + LINE_SEPARATOR);
        MavenVersion lastOldVersion = null;
        String lastOldWsdlUrl = "";
        for (VersionCompatibilityBreakage breakage : breakages) {
            if (lastOldVersion != breakage.oldMavenVersion || lastOldWsdlUrl != breakage.oldWsdlUrl) {
                lastOldVersion = breakage.oldMavenVersion;
                lastOldWsdlUrl = breakage.oldWsdlUrl;
                errorsStringBuilder.append(LINE_SEPARATOR + "Old Version: " + lastOldVersion.getOriginalForm() + ", wsdl: " + lastOldWsdlUrl);
                errorsStringBuilder.append(LINE_SEPARATOR + "New Version: " + breakage.newMavenVersion.getOriginalForm() + ", wsdl: " + breakage.newWsdlUrl + LINE_SEPARATOR + LINE_SEPARATOR);
            }
            errorsStringBuilder.append(breakage.breakageMessage + LINE_SEPARATOR);
        }
        return errorsStringBuilder.toString();
    }

    public String getPreviousVersion() {
        if (StringUtils.isEmpty((String)this.previousVersion)) {
            this.previousVersion = ConfigContext.getCurrentContextConfig().getProperty(WSDL_PREVIOUS_VERSION);
        }
        return this.previousVersion;
    }

    public void setPreviousVersion(String previousVersion) {
        this.previousVersion = previousVersion;
    }

    protected Lifecycle getLoadApplicationLifecycle() {
        SpringResourceLoader springResourceLoader = new SpringResourceLoader(new QName("VCTestHarnessResourceLoader"), "classpath:VCTestHarnessSpringBeans.xml", null);
        springResourceLoader.setParentSpringResourceLoader(this.getTestHarnessSpringResourceLoader());
        return springResourceLoader;
    }

    protected List<Lifecycle> getPerTestLifecycles() {
        return new ArrayList<Lifecycle>();
    }

    protected List<Lifecycle> getSuiteLifecycles() {
        LinkedList<Lifecycle> lifecycles = new LinkedList<Lifecycle>();
        lifecycles.add((Lifecycle)new BaseLifecycle(){

            public void start() throws Exception {
                Config config = WsdlCompareTestCase.this.getTestHarnessConfig();
                ConfigContext.init((Config)config);
                super.start();
            }
        });
        return lifecycles;
    }

    protected List<MavenVersion> getVersionRange(MavenVersion lowestVersion, MavenVersion highestVersion) {
        ArrayList<MavenVersion> results = new ArrayList<MavenVersion>();
        if (highestVersion.compareTo(lowestVersion) <= 0) {
            throw new IllegalStateException("currentVersion " + highestVersion + "  is <= previousVersion " + lowestVersion);
        }
        List<MavenVersion> riceVersions = WsdlCompareTestCase.getRiceMavenVersions();
        for (MavenVersion riceVersion : riceVersions) {
            if (highestVersion.compareTo(riceVersion) <= 0 || lowestVersion.compareTo(riceVersion) > 0 || !"".equals(riceVersion.getQualifier())) continue;
            results.add(riceVersion);
        }
        return results;
    }

    private static List<MavenVersion> getRiceMavenVersions() {
        if (riceMavenVersions == null) {
            String searchContent = WsdlCompareTestCase.getMavenSearchResults();
            riceMavenVersions = WsdlCompareTestCase.parseSearchResults(searchContent);
            Collections.sort(riceMavenVersions, mavenVersionTimestampComparator);
            LOG.info((Object)"Published versions, sorted by timestamp:");
            for (MavenVersion riceVersion : riceMavenVersions) {
                LOG.info((Object)("" + riceVersion.getTimestamp() + " " + riceVersion.getOriginalForm()));
            }
        }
        return riceMavenVersions;
    }

    private MavenVersion getCurrentMavenVersion() {
        return new MavenVersion(ConfigContext.getCurrentContextConfig().getProperty("rice.version"), "" + System.currentTimeMillis());
    }

    private static List<MavenVersion> parseSearchResults(String searchContent) {
        JsonNode rootNode;
        LinkedList<MavenVersion> riceVersions = new LinkedList<MavenVersion>();
        ObjectMapper mapper = new ObjectMapper();
        try {
            rootNode = mapper.readTree(searchContent);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't parse maven search results", e);
        }
        JsonNode docsNode = rootNode.get("response").get("docs");
        for (JsonNode node : docsNode) {
            String versionStr = node.get("v").toString();
            String timestampStr = node.get("timestamp").toString();
            riceVersions.add(new MavenVersion(versionStr.replace("\"", ""), timestampStr));
        }
        Collections.sort(riceVersions);
        return riceVersions;
    }

    private static String getMavenSearchResults() {
        URL mavenSearchUrl;
        String mavenSearchUrlString = "http://search.maven.org/solrsearch/select?q=g:%22org.kuali.rice%22+AND+a:%22rice%22&core=gav&rows=20&wt=json";
        try {
            mavenSearchUrl = new URL("http://search.maven.org/solrsearch/select?q=g:%22org.kuali.rice%22+AND+a:%22rice%22&core=gav&rows=20&wt=json");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("can't parse maven search url", e);
        }
        StringBuilder contentBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader contentReader = new BufferedReader(new InputStreamReader(mavenSearchUrl.openStream()));
            while (null != (line = contentReader.readLine())) {
                contentBuilder.append(line + LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read search results", e);
        }
        return contentBuilder.toString();
    }

    protected static class VersionCompatibilityBreakage {
        private final MavenVersion oldMavenVersion;
        private final MavenVersion newMavenVersion;
        private final String oldWsdlUrl;
        private final String newWsdlUrl;
        private final String breakageMessage;

        public VersionCompatibilityBreakage(MavenVersion oldMavenVersion, MavenVersion newMavenVersion, String oldWsdlUrl, String newWsdlUrl, String breakageMessage) {
            if (oldMavenVersion == null) {
                throw new IllegalArgumentException("oldMavenVersion must not be null");
            }
            if (newMavenVersion == null) {
                throw new IllegalArgumentException("newMavenVersion must not be null");
            }
            if (StringUtils.isEmpty((String)oldWsdlUrl)) {
                throw new IllegalArgumentException("oldWsdlUrl must not be empty/null");
            }
            if (StringUtils.isEmpty((String)newWsdlUrl)) {
                throw new IllegalArgumentException("newWsdlUrl must not be empty/null");
            }
            if (StringUtils.isEmpty((String)breakageMessage)) {
                throw new IllegalArgumentException("breakageMessage must not be empty/null");
            }
            this.oldWsdlUrl = oldWsdlUrl;
            this.newWsdlUrl = newWsdlUrl;
            this.oldMavenVersion = oldMavenVersion;
            this.newMavenVersion = newMavenVersion;
            this.breakageMessage = breakageMessage;
        }

        public String toString() {
            return "VersionCompatibilityBreakage{oldMavenVersion=" + this.oldMavenVersion + ", newMavenVersion=" + this.newMavenVersion + ", oldWsdlUrl='" + this.oldWsdlUrl + '\'' + ", newWsdlUrl='" + this.newWsdlUrl + '\'' + ", breakageMessage='" + this.breakageMessage + '\'' + '}';
        }
    }

    public static class VersionTransition {
        private final MavenVersion fromVersion;
        private final MavenVersion toVersion;

        public VersionTransition(MavenVersion fromVersion, MavenVersion toVersion) {
            this.fromVersion = fromVersion;
            this.toVersion = toVersion;
            if (fromVersion == null) {
                throw new IllegalArgumentException("fromVersion must not be null");
            }
            if (toVersion == null) {
                throw new IllegalArgumentException("toVersion must not be null");
            }
        }

        public VersionTransition(String fromVersion, String toVersion) {
            this(new MavenVersion(fromVersion), new MavenVersion(toVersion));
        }

        private MavenVersion getFromVersion() {
            return this.fromVersion;
        }

        private MavenVersion getToVersion() {
            return this.toVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionTransition that = (VersionTransition)o;
            if (!this.fromVersion.equals(that.fromVersion)) {
                return false;
            }
            return this.toVersion.equals(that.toVersion);
        }

        public int hashCode() {
            int result = this.fromVersion.hashCode();
            result = 31 * result + this.toVersion.hashCode();
            return result;
        }

        public String toString() {
            return "VersionTransition{" + this.fromVersion.getOriginalForm() + " -> " + this.toVersion.getOriginalForm() + '}';
        }
    }

    protected static class MavenVersion
    implements Comparable<MavenVersion> {
        private static final Pattern PERIOD_PATTERN = Pattern.compile("\\.");
        private final List<Integer> numbers;
        private final String originalForm;
        private final String qualifier;
        private final Long timestamp;

        public MavenVersion(String versionString) {
            this(versionString, "0");
        }

        public MavenVersion(String versionString, String timestampString) {
            String versionPart;
            this.originalForm = versionString;
            if (versionString == null || "".equals(versionString.trim())) {
                throw new IllegalArgumentException("empty or null version string");
            }
            int dashIndex = versionString.indexOf(45);
            if (dashIndex != -1 && versionString.length() - 1 > dashIndex) {
                this.qualifier = versionString.substring(dashIndex + 1).trim();
                versionPart = versionString.substring(0, dashIndex);
            } else {
                versionPart = versionString;
                this.qualifier = "";
            }
            String[] versionArray = PERIOD_PATTERN.split(versionPart);
            ArrayList<Integer> numbersBuilder = new ArrayList<Integer>(versionArray.length);
            for (String versionParticle : versionArray) {
                numbersBuilder.add(Integer.valueOf(versionParticle));
            }
            this.numbers = Collections.unmodifiableList(numbersBuilder);
            this.timestamp = Long.valueOf(timestampString);
        }

        @Override
        public int compareTo(MavenVersion that) {
            Iterator<Integer> thisNumbersIter = this.numbers.iterator();
            Iterator<Integer> thatNumbersIter = that.numbers.iterator();
            while (thisNumbersIter.hasNext()) {
                if (!thatNumbersIter.hasNext()) {
                    return 1;
                }
                int numberComparison = thisNumbersIter.next().compareTo(thatNumbersIter.next());
                if (numberComparison == 0) continue;
                return numberComparison;
            }
            if (thatNumbersIter.hasNext()) {
                return -1;
            }
            return MavenVersion.compareQualifiers(this.qualifier, that.qualifier);
        }

        private static int compareQualifiers(String thisQ, String thatQ) {
            if ("".equals(thisQ)) {
                if ("".equals(thatQ)) {
                    return 0;
                }
                return 1;
            }
            if ("".equals(thatQ)) {
                return -1;
            }
            return thisQ.compareTo(thatQ);
        }

        public List<Integer> getNumbers() {
            return Collections.unmodifiableList(this.numbers);
        }

        public String getQualifier() {
            return this.qualifier;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public String getOriginalForm() {
            return this.originalForm;
        }

        public String toString() {
            return "MavenVersion{" + this.originalForm + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MavenVersion that = (MavenVersion)o;
            return this.originalForm.equals(that.originalForm);
        }

        public int hashCode() {
            return this.originalForm.hashCode();
        }
    }
}

