/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.document.DocumentContentUpdate;
import org.kuali.rice.kew.api.document.DocumentUpdate;

public final class WorkflowDocumentFactory {
    private static final String CREATE_METHOD_NAME = "createDocument";
    private static final String LOAD_METHOD_NAME = "loadDocument";

    public static WorkflowDocument createDocument(String principalId, String documentTypeName) {
        return WorkflowDocumentFactory.createDocument(principalId, documentTypeName, null, null);
    }

    public static WorkflowDocument createDocument(String principalId, String documentTypeName, String title) {
        DocumentUpdate.Builder builder = DocumentUpdate.Builder.create();
        builder.setTitle(title);
        return WorkflowDocumentFactory.createDocument(principalId, documentTypeName, builder.build(), null);
    }

    public static WorkflowDocument createDocument(String principalId, String documentTypeName, DocumentUpdate documentUpdate, DocumentContentUpdate documentContentUpdate) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new IllegalArgumentException("principalId was null or blank");
        }
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new IllegalArgumentException("documentTypeName was null or blank");
        }
        Object workflowDocument = null;
        try {
            workflowDocument = ProviderHolder.createMethod.invoke(ProviderHolder.provider, new Object[]{principalId, documentTypeName, documentUpdate, documentContentUpdate});
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Failed to invoke createDocument", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new ConfigurationException("Failed to invoke createDocument", (Throwable)e);
        }
        if (!(workflowDocument instanceof WorkflowDocument)) {
            throw new ConfigurationException("Created document is not a proper instance of " + WorkflowDocument.class + ", was instead " + workflowDocument.getClass());
        }
        return (WorkflowDocument)workflowDocument;
    }

    public static WorkflowDocument loadDocument(String principalId, String documentId) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new IllegalArgumentException("principalId was null or blank");
        }
        if (StringUtils.isBlank((String)documentId)) {
            throw new IllegalArgumentException("documentId was null or blank");
        }
        Object workflowDocument = null;
        try {
            workflowDocument = ProviderHolder.loadMethod.invoke(ProviderHolder.provider, principalId, documentId);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Failed to invoke loadDocument", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new ConfigurationException("Failed to invoke loadDocument", (Throwable)e);
        }
        if (!(workflowDocument instanceof WorkflowDocument)) {
            throw new ConfigurationException("Loaded document is not a proper instance of " + WorkflowDocument.class + ", was instead " + workflowDocument.getClass());
        }
        return (WorkflowDocument)workflowDocument;
    }

    private static Object loadProvider() {
        String providerClassName = null;
        String resource = null;
        try {
            resource = "META-INF/services/" + WorkflowDocument.class.getName();
            InputStream resourceStream = ClassLoaderUtils.getDefaultClassLoader().getResourceAsStream(resource.toString());
            if (resourceStream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, "UTF-8"));
                providerClassName = reader.readLine().trim();
                reader.close();
                Class<?> providerClass = Class.forName(providerClassName);
                return WorkflowDocumentFactory.newInstance(providerClass);
            }
            throw new ConfigurationException("Failed to locate a services definition file at " + resource);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failure processing services definition file at " + resource, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Failed to load provider class: " + providerClassName, (Throwable)e);
        }
    }

    private static Object newInstance(Class<?> providerClass) {
        try {
            return providerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate provider class: " + providerClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Failed to instantiate provider class: " + providerClass.getName(), (Throwable)e);
        }
    }

    private static Method locateCreateMethod(Object provider) {
        try {
            return provider.getClass().getMethod(CREATE_METHOD_NAME, String.class, String.class, DocumentUpdate.class, DocumentContentUpdate.class);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Failed to locate valid createDocument method signature on provider class: " + provider.getClass().getName(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Encountered security issue when attempting to access createDocument method on provider class: " + provider.getClass().getName(), (Throwable)e);
        }
    }

    private static Method locateLoadMethod(Object provider) {
        try {
            return provider.getClass().getMethod(LOAD_METHOD_NAME, String.class, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Failed to locate valid createDocument method signature on provider class: " + provider.getClass().getName(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Encountered security issue when attempting to access createDocument method on provider class: " + provider.getClass().getName(), (Throwable)e);
        }
    }

    static /* synthetic */ Object access$000() {
        return WorkflowDocumentFactory.loadProvider();
    }

    static /* synthetic */ Method access$100(Object x0) {
        return WorkflowDocumentFactory.locateCreateMethod(x0);
    }

    static /* synthetic */ Method access$200(Object x0) {
        return WorkflowDocumentFactory.locateLoadMethod(x0);
    }

    private static final class ProviderHolder {
        static final Object provider = WorkflowDocumentFactory.access$000();
        static final Method createMethod = WorkflowDocumentFactory.access$100(provider);
        static final Method loadMethod = WorkflowDocumentFactory.access$200(provider);

        private ProviderHolder() {
        }
    }
}

