/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.common;

import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kim.api.common.attribute.KimAttribute;
import org.kuali.rice.kim.api.common.attribute.KimAttributeContract;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttributeContract;
import org.kuali.rice.kim.api.type.KimTypeContract;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.group.GroupAttributeBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.mockito.Mockito;

public class KimAttributeDataBoTest {
    private static KimTypeContract mockKimTypeContract;
    private static KimAttributeContract mockKimAttributeContract;
    private KimTypeInfoService mockInfoService;

    private static KimType create() {
        return KimType.Builder.create((KimTypeContract)mockKimTypeContract).build();
    }

    private static KimAttribute createKimAttribute() {
        return KimAttribute.Builder.create((KimAttributeContract)mockKimAttributeContract).build();
    }

    @Before
    public void setup() throws Exception {
        mockKimAttributeContract = (KimAttributeContract)Mockito.mock(KimAttributeContract.class);
        Long versionNumber = 1L;
        String attributeName = "one";
        String namespaceCode = "namespaceCode";
        String id = "id_one";
        Mockito.when((Object)mockKimAttributeContract.getVersionNumber()).thenReturn((Object)versionNumber);
        Mockito.when((Object)mockKimAttributeContract.getAttributeName()).thenReturn((Object)attributeName);
        Mockito.when((Object)mockKimAttributeContract.getNamespaceCode()).thenReturn((Object)namespaceCode);
        Mockito.when((Object)mockKimAttributeContract.getId()).thenReturn((Object)id);
        KimTypeAttributeContract one = (KimTypeAttributeContract)Mockito.mock(KimTypeAttributeContract.class);
        String id2 = "one";
        Long versionNumber2 = 1L;
        KimAttribute attribute = KimAttributeDataBoTest.createKimAttribute();
        Mockito.when((Object)one.getKimAttribute()).thenReturn((Object)attribute);
        Mockito.when((Object)one.getId()).thenReturn((Object)id2);
        Mockito.when((Object)one.getVersionNumber()).thenReturn((Object)versionNumber2);
        mockKimTypeContract = (KimTypeContract)Mockito.mock(KimTypeContract.class);
        id2 = new String("27");
        String serviceName = "barService";
        String namespaceCode2 = "NAMESPACE CODE";
        String name = "mock Kim Type Contract";
        Long versionNumber3 = 1L;
        String objectId = "1";
        ArrayList<KimTypeAttributeContract> attributeDefinitions = new ArrayList<KimTypeAttributeContract>();
        attributeDefinitions.add(one);
        Mockito.when((Object)mockKimTypeContract.getId()).thenReturn((Object)id2);
        Mockito.when((Object)mockKimTypeContract.getServiceName()).thenReturn((Object)serviceName);
        Mockito.when((Object)mockKimTypeContract.getNamespaceCode()).thenReturn((Object)namespaceCode2);
        Mockito.when((Object)mockKimTypeContract.getName()).thenReturn((Object)name);
        Mockito.when((Object)mockKimTypeContract.getVersionNumber()).thenReturn((Object)versionNumber3);
        Mockito.when((Object)mockKimTypeContract.getObjectId()).thenReturn((Object)objectId);
        Mockito.when((Object)mockKimTypeContract.getAttributeDefinitions()).thenReturn(attributeDefinitions);
        KimType kimType = KimAttributeDataBoTest.create();
        this.mockInfoService = (KimTypeInfoService)Mockito.mock(KimTypeInfoService.class);
        Mockito.when((Object)this.mockInfoService.getKimType(Mockito.anyString())).thenReturn((Object)kimType);
    }

    @Test
    public void testKimAttributeDataBo() {
        KimType kimType = KimAttributeDataBoTest.create();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("one", "one");
        String kimTypeId = "27";
        Assert.assertEquals((Object)kimType.getId(), (Object)"27");
        KimAttributeDataBo.setKimTypeInfoService((KimTypeInfoService)this.mockInfoService);
        GroupAttributeBo groupQualifier = (GroupAttributeBo)KimAttributeDataBo.createFrom(GroupAttributeBo.class, attributes, (String)kimTypeId).get(0);
        Assert.assertNotNull((Object)groupQualifier.getKimType());
        Assert.assertEquals((Object)groupQualifier.getKimType().getId(), (Object)KimTypeBo.from((KimType)kimType).getId());
    }
}

