/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.common.delegate;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kim.api.common.delegate.DelegateMember;
import org.kuali.rice.kim.api.common.delegate.DelegateType;
import org.kuali.rice.kim.api.common.delegate.DelegateTypeContract;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.springframework.util.AutoPopulatingList;

@Entity
@Table(name="KRIM_DLGN_T")
public class DelegateTypeBo
extends DataObjectBase
implements DelegateTypeContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @PortableSequenceGenerator(name="KRIM_DLGN_ID_S")
    @GeneratedValue(generator="KRIM_DLGN_ID_S")
    @Id
    @Column(name="DLGN_ID")
    private String delegationId;
    @Column(name="ROLE_ID")
    private String roleId;
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active = true;
    @Column(name="KIM_TYP_ID")
    private String kimTypeId;
    @Column(name="DLGN_TYP_CD")
    private String delegationTypeCode;
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=DelegateMemberBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="DLGN_ID", referencedColumnName="DLGN_ID")
    private List<DelegateMemberBo> members = new AutoPopulatingList(DelegateMemberBo.class);

    public void setDelegationType(DelegationType type) {
        this._persistence_set_delegationTypeCode(type.getCode());
    }

    public DelegationType getDelegationType() {
        return DelegationType.fromCode((String)this._persistence_get_delegationTypeCode());
    }

    public static DelegateType to(DelegateTypeBo bo) {
        return DelegateType.Builder.create((DelegateTypeContract)bo).build();
    }

    public static DelegateTypeBo from(DelegateType immutable) {
        ArrayList<DelegateMemberBo> tmpMembers = new ArrayList<DelegateMemberBo>();
        for (DelegateMember member : immutable.getMembers()) {
            tmpMembers.add(DelegateMemberBo.from(member));
        }
        DelegateTypeBo bo = new DelegateTypeBo();
        bo.setDelegationId(immutable.getDelegationId());
        bo.setRoleId(immutable.getRoleId());
        bo.setActive(immutable.isActive());
        bo.setKimTypeId(immutable.getKimTypeId());
        bo.setDelegationTypeCode(immutable.getDelegationType().getCode());
        bo.setMembers(tmpMembers);
        return bo;
    }

    public String getDelegationId() {
        return this._persistence_get_delegationId();
    }

    public void setDelegationId(String delegationId) {
        this._persistence_set_delegationId(delegationId);
    }

    public String getRoleId() {
        return this._persistence_get_roleId();
    }

    public void setRoleId(String roleId) {
        this._persistence_set_roleId(roleId);
    }

    public boolean getActive() {
        return this._persistence_get_active();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public String getKimTypeId() {
        return this._persistence_get_kimTypeId();
    }

    public void setKimTypeId(String kimTypeId) {
        this._persistence_set_kimTypeId(kimTypeId);
    }

    public String getDelegationTypeCode() {
        return this._persistence_get_delegationTypeCode();
    }

    public void setDelegationTypeCode(String delegationTypeCode) {
        this._persistence_set_delegationTypeCode(delegationTypeCode);
    }

    public List<DelegateMemberBo> getMembers() {
        return this._persistence_get_members();
    }

    public void setMembers(List<DelegateMemberBo> members) {
        this._persistence_set_members(members);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DelegateTypeBo();
    }

    public Object _persistence_get(String string) {
        if (string == "delegationTypeCode") {
            return this.delegationTypeCode;
        }
        if (string == "kimTypeId") {
            return this.kimTypeId;
        }
        if (string == "roleId") {
            return this.roleId;
        }
        if (string == "members") {
            return this.members;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "delegationId") {
            return this.delegationId;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "delegationTypeCode") {
            this.delegationTypeCode = (String)object;
            return;
        }
        if (string == "kimTypeId") {
            this.kimTypeId = (String)object;
            return;
        }
        if (string == "roleId") {
            this.roleId = (String)object;
            return;
        }
        if (string == "members") {
            this.members = (List)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "delegationId") {
            this.delegationId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_delegationTypeCode() {
        this._persistence_checkFetched("delegationTypeCode");
        return this.delegationTypeCode;
    }

    public void _persistence_set_delegationTypeCode(String string) {
        this._persistence_checkFetchedForSet("delegationTypeCode");
        this._persistence_propertyChange("delegationTypeCode", this.delegationTypeCode, string);
        this.delegationTypeCode = string;
    }

    public String _persistence_get_kimTypeId() {
        this._persistence_checkFetched("kimTypeId");
        return this.kimTypeId;
    }

    public void _persistence_set_kimTypeId(String string) {
        this._persistence_checkFetchedForSet("kimTypeId");
        this._persistence_propertyChange("kimTypeId", this.kimTypeId, string);
        this.kimTypeId = string;
    }

    public String _persistence_get_roleId() {
        this._persistence_checkFetched("roleId");
        return this.roleId;
    }

    public void _persistence_set_roleId(String string) {
        this._persistence_checkFetchedForSet("roleId");
        this._persistence_propertyChange("roleId", this.roleId, string);
        this.roleId = string;
    }

    public List _persistence_get_members() {
        this._persistence_checkFetched("members");
        return this.members;
    }

    public void _persistence_set_members(List list) {
        this._persistence_checkFetchedForSet("members");
        this._persistence_propertyChange("members", this.members, list);
        this.members = list;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_delegationId() {
        this._persistence_checkFetched("delegationId");
        return this.delegationId;
    }

    public void _persistence_set_delegationId(String string) {
        this._persistence_checkFetchedForSet("delegationId");
        this._persistence_propertyChange("delegationId", this.delegationId, string);
        this.delegationId = string;
    }
}

