/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.entity.EntityDefaultQueryResults;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierType;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoDefault;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.kim.impl.identity.principal.PrincipalBo;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.service.BusinessObjectMetaDataService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.util.KRADUtils;
import org.springframework.beans.PropertyAccessorUtils;

public class PersonServiceImpl
implements PersonService {
    private static Logger LOG = Logger.getLogger(PersonServiceImpl.class);
    protected static final String ENTITY_EXT_ID_PROPERTY_PREFIX = "externalIdentifiers.";
    protected static final String ENTITY_AFFILIATION_PROPERTY_PREFIX = "affiliations.";
    protected static final String ENTITY_TYPE_PROPERTY_PREFIX = "entityTypeContactInfos.";
    protected static final String ENTITY_EMAIL_PROPERTY_PREFIX = "entityTypeContactInfos.emailAddresses.";
    protected static final String ENTITY_PHONE_PROPERTY_PREFIX = "entityTypeContactInfos.phoneNumbers.";
    protected static final String ENTITY_ADDRESS_PROPERTY_PREFIX = "entityTypeContactInfos.addresses.";
    protected static final String ENTITY_NAME_PROPERTY_PREFIX = "names.";
    protected static final String PRINCIPAL_PROPERTY_PREFIX = "principals.";
    protected static final String ENTITY_EMPLOYEE_ID_PROPERTY_PREFIX = "employmentInformation.";
    protected static final String EXTENSION = "extension";
    private IdentityService identityService;
    private RoleService roleService;
    private BusinessObjectMetaDataService businessObjectMetaDataService;
    private MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    protected List<String> personEntityTypeCodes = new ArrayList<String>(4);
    private String personEntityTypeLookupCriteria = null;
    protected Map<String, String> baseLookupCriteria = new HashMap<String, String>();
    protected Map<String, String> criteriaConversion = new HashMap<String, String>();
    protected ArrayList<String> personCachePropertyNames = new ArrayList();

    public PersonServiceImpl() {
        this.baseLookupCriteria.put("active", "Y");
        this.baseLookupCriteria.put("entityTypeContactInfos.active", "Y");
        this.criteriaConversion.put("entityId", "id");
        this.criteriaConversion.put("active", "principals.active");
        this.criteriaConversion.put("principalId", "principals.principalId");
        this.criteriaConversion.put("principalName", "principals.principalName");
        this.criteriaConversion.put("firstName", "names.firstName");
        this.criteriaConversion.put("lastName", "names.lastName");
        this.criteriaConversion.put("middleName", "names.middleName");
        this.criteriaConversion.put("emailAddress", "entityTypeContactInfos.emailAddresses.emailAddress");
        this.criteriaConversion.put("phoneNumber", "entityTypeContactInfos.phoneNumbers.phoneNumber");
        this.criteriaConversion.put("line1", "entityTypeContactInfos.addresses.line1");
        this.criteriaConversion.put("line2", "entityTypeContactInfos.addresses.line2");
        this.criteriaConversion.put("line3", "entityTypeContactInfos.addresses.line3");
        this.criteriaConversion.put("city", "entityTypeContactInfos.addresses.city");
        this.criteriaConversion.put("stateCode", "entityTypeContactInfos.addresses.stateProvinceCode");
        this.criteriaConversion.put("postalCode", "entityTypeContactInfos.addresses.postalCode");
        this.criteriaConversion.put("countyCode", "entityTypeContactInfos.addresses.countryCode");
        this.criteriaConversion.put("campusCode", "affiliations.campusCode");
        this.criteriaConversion.put("affiliationTypeCode", "affiliations.affiliationTypeCode");
        this.criteriaConversion.put("externalIdentifierTypeCode", "externalIdentifiers.externalIdentifierTypeCode");
        this.criteriaConversion.put("externalId", "externalIdentifiers.externalId");
        this.criteriaConversion.put("employeeTypeCode", "employmentInformation.employeeTypeCode");
        this.criteriaConversion.put("employeeStatusCode", "employmentInformation.employeeStatusCode");
        this.criteriaConversion.put("employeeId", "employmentInformation.employeeId");
        this.criteriaConversion.put("baseSalaryAmount", "employmentInformation.baseSalaryAmount");
        this.criteriaConversion.put("primaryDepartmentCode", "employmentInformation.primaryDepartmentCode");
        this.personCachePropertyNames.add("principalId");
        this.personCachePropertyNames.add("principalName");
        this.personCachePropertyNames.add("entityId");
        this.personCachePropertyNames.add("firstName");
        this.personCachePropertyNames.add("lastName");
        this.personCachePropertyNames.add("middleName");
        this.personCachePropertyNames.add("campusCode");
        this.personCachePropertyNames.add("employeeId");
        this.personCachePropertyNames.add("primaryDepartmentCode");
    }

    public Person getPerson(String principalId) {
        EntityDefault entity;
        if (StringUtils.isBlank((String)principalId)) {
            return null;
        }
        Principal principal = this.getIdentityService().getPrincipal(principalId);
        if (principal != null && (entity = this.getIdentityService().getEntityDefault(principal.getEntityId())) != null) {
            return this.convertEntityToPerson(entity, principal);
        }
        return null;
    }

    protected PersonImpl convertEntityToPerson(EntityDefault entity, Principal principal) {
        try {
            for (String entityTypeCode : this.personEntityTypeCodes) {
                EntityTypeContactInfoDefault entType = entity.getEntityType(entityTypeCode);
                if (entType == null) continue;
                return new PersonImpl(principal, entity, entityTypeCode);
            }
            return null;
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException("Problem building person object", ex);
        }
    }

    public Person getPersonByPrincipalName(String principalName) {
        EntityDefault entity;
        if (StringUtils.isBlank((String)principalName)) {
            return null;
        }
        Principal principal = this.getIdentityService().getPrincipalByPrincipalName(principalName);
        if (principal != null && (entity = this.getIdentityService().getEntityDefault(principal.getEntityId())) != null) {
            return this.convertEntityToPerson(entity, principal);
        }
        return null;
    }

    public Person getPersonByEmployeeId(String employeeId) {
        Principal principal;
        if (StringUtils.isBlank((String)employeeId)) {
            return null;
        }
        List<Person> people = this.findPeople(Collections.singletonMap("employeeId", employeeId));
        if (!people.isEmpty()) {
            return people.get(0);
        }
        EntityDefault entity = this.getIdentityService().getEntityDefaultByEmployeeId(employeeId);
        if (entity != null && !entity.getPrincipals().isEmpty() && (principal = this.getIdentityService().getPrincipal(((Principal)entity.getPrincipals().get(0)).getPrincipalId())) != null) {
            return this.convertEntityToPerson(entity, principal);
        }
        return null;
    }

    public List<Person> findPeople(Map<String, String> criteria) {
        return this.findPeople(criteria, true);
    }

    public List<Person> findPeople(Map<String, String> criteria, boolean unbounded) {
        CollectionIncomplete people = null;
        if (criteria == null) {
            criteria = Collections.emptyMap();
        }
        criteria = new HashMap<String, String>(criteria);
        String roleName = criteria.get("lookupRoleName");
        String namespaceCode = criteria.get("lookupRoleNamespaceCode");
        criteria.remove("lookupRoleName");
        criteria.remove("lookupRoleNamespaceCode");
        if (StringUtils.isNotBlank((String)namespaceCode) && StringUtils.isNotBlank((String)roleName)) {
            List<String> principalIds;
            Integer searchResultsLimit = LookupUtils.getSearchResultsLimit(PersonImpl.class);
            int searchResultsLimitInt = Integer.MAX_VALUE;
            if (searchResultsLimit != null) {
                searchResultsLimitInt = searchResultsLimit;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Performing Person search including role filter: " + namespaceCode + "/" + roleName));
            }
            if (criteria.size() == 1 && criteria.containsKey("active")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Only active criteria specified, running role search first");
                }
                principalIds = this.getRoleService().getRoleMemberPrincipalIds(namespaceCode, roleName, Collections.emptyMap());
                StringBuffer sb = new StringBuffer(principalIds.size() * 15);
                Iterator pi = principalIds.iterator();
                while (pi.hasNext()) {
                    sb.append((String)pi.next());
                    if (!pi.hasNext()) continue;
                    sb.append('|');
                }
                criteria.put("principalId", sb.toString());
                people = this.findPeopleInternal(criteria, false);
            } else if (!criteria.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Person criteria also specified, running that search first");
                }
                people = this.findPeopleInternal(criteria, true);
                principalIds = this.peopleToPrincipalIds((List<Person>)people);
                principalIds = this.getRoleService().getPrincipalIdSubListWithRole(principalIds, namespaceCode, roleName, Collections.emptyMap());
                if (!unbounded && principalIds.size() > searchResultsLimitInt) {
                    int actualResultSize = principalIds.size();
                    principalIds = new ArrayList<String>(principalIds).subList(0, searchResultsLimitInt);
                    people = this.getPeople(principalIds);
                    people = new CollectionIncomplete(people.subList(0, searchResultsLimitInt), new Long(actualResultSize));
                } else {
                    people = this.getPeople((Collection<String>)principalIds);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"No Person criteria specified - only using role service.");
                }
                principalIds = this.getRoleService().getRoleMemberPrincipalIds(namespaceCode, roleName, Collections.emptyMap());
                if (!unbounded && principalIds.size() > searchResultsLimitInt) {
                    int actualResultSize = principalIds.size();
                    principalIds = new ArrayList(principalIds).subList(0, searchResultsLimitInt);
                    people = this.getPeople(principalIds);
                    people = new CollectionIncomplete(people.subList(0, searchResultsLimitInt), new Long(actualResultSize));
                } else {
                    people = this.getPeople(principalIds);
                }
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No Role criteria specified, running person lookup as normal.");
            }
            people = this.findPeopleInternal(criteria, unbounded);
        }
        HashSet<String> peopleNoDupsSet = new HashSet<String>();
        ArrayList<Person> peopleNoDupsList = new ArrayList<Person>();
        for (Person person : people) {
            if (!peopleNoDupsSet.add(person.getEntityId() + person.getPrincipalId() + person.getPrincipalName())) continue;
            peopleNoDupsList.add(person);
        }
        people.clear();
        people.addAll(peopleNoDupsList);
        return people;
    }

    protected List<Person> findPeopleInternal(Map<String, String> criteria, boolean unbounded) {
        ArrayList<Person> people;
        block13: {
            EntityDefaultQueryResults qr;
            Map<String, String> entityCriteria;
            block14: {
                EntityDefaultQueryResults newQr;
                block15: {
                    block12: {
                        Integer searchResultsLimit;
                        entityCriteria = this.convertPersonPropertiesToEntityProperties(criteria);
                        Predicate predicate = PredicateUtils.convertMapToPredicate(entityCriteria);
                        QueryByCriteria.Builder queryBuilder = QueryByCriteria.Builder.create();
                        queryBuilder.setPredicates(new Predicate[]{predicate});
                        if (!unbounded && (searchResultsLimit = LookupUtils.getSearchResultsLimit(PersonImpl.class)) != null && searchResultsLimit >= 0) {
                            queryBuilder.setMaxResults(searchResultsLimit);
                            queryBuilder.setCountFlag(CountFlag.INCLUDE);
                        }
                        people = new ArrayList<Person>();
                        qr = this.getIdentityService().findEntityDefaults(queryBuilder.build());
                        if (qr.getResults().size() <= 0) break block12;
                        for (EntityDefault e : qr.getResults()) {
                            if (e.getPrincipals().isEmpty()) {
                                PrincipalBo principalBo = new PrincipalBo();
                                principalBo.setActive(false);
                                principalBo.setEntityId(e.getEntityId());
                                principalBo.setPrincipalName("No Principal Name");
                                principalBo.setPrincipalId(e.getEntityId());
                                people.add(this.convertEntityToPerson(e, PrincipalBo.to(principalBo)));
                                continue;
                            }
                            for (Principal p : e.getPrincipals()) {
                                people.add(this.convertEntityToPerson(e, p));
                            }
                        }
                        break block13;
                    }
                    if (qr.isMoreResultsAvailable() || !entityCriteria.containsKey("principals.principalId")) break block14;
                    HashMap<String, String> newEntityCriteria = new HashMap<String, String>();
                    String principalID = entityCriteria.get("principals.principalId");
                    newEntityCriteria.put("active", "Y");
                    newEntityCriteria.put("id", principalID);
                    Predicate newPredicate = PredicateUtils.convertMapToPredicate(newEntityCriteria);
                    QueryByCriteria.Builder newQueryBuilder = QueryByCriteria.Builder.create();
                    newQueryBuilder.setMaxResults(Integer.valueOf(1));
                    newQueryBuilder.setCountFlag(CountFlag.INCLUDE);
                    newQueryBuilder.setPredicates(new Predicate[]{newPredicate});
                    newQr = this.getIdentityService().findEntityDefaults(newQueryBuilder.build());
                    String activeCriteria = entityCriteria.get("active");
                    if (activeCriteria == null || !activeCriteria.equalsIgnoreCase("Y")) break block15;
                    if (newQr.getResults().size() <= 0) break block13;
                    for (EntityDefault e : newQr.getResults()) {
                        if (!e.getPrincipals().isEmpty()) continue;
                        PrincipalBo principalBo = new PrincipalBo();
                        principalBo.setActive(false);
                        principalBo.setEntityId(e.getEntityId());
                        principalBo.setPrincipalName("No Principal Name");
                        principalBo.setPrincipalId(e.getEntityId());
                        people.add(this.convertEntityToPerson(e, PrincipalBo.to(principalBo)));
                    }
                    break block13;
                }
                if (entityCriteria.containsKey("active") && !criteria.get("active").equals("N") || !newQr.getResults().isEmpty()) break block13;
                String principalId = entityCriteria.get("principals.principalId");
                try {
                    EntityDefault entityDefault = this.getIdentityService().getEntityDefaultByPrincipalId(principalId);
                    for (Principal p : entityDefault.getPrincipals()) {
                        if (p.isActive()) continue;
                        people.add(this.convertEntityToPerson(entityDefault, p));
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)("A principal Id of " + principalId + " dose not exist in the system"));
                }
                break block13;
            }
            if (qr.isMoreResultsAvailable() || !entityCriteria.containsKey("principals.principalName") || entityCriteria.containsKey("active") && !criteria.get("active").equals("N")) break block13;
            HashMap<String, String> newEntityCriteria = new HashMap<String, String>();
            String principalName = entityCriteria.get("principals.principalName");
            newEntityCriteria.put("active", "Y");
            newEntityCriteria.put("principals.principalName", principalName);
            Predicate newPredicate = PredicateUtils.convertMapToPredicate(newEntityCriteria);
            QueryByCriteria.Builder newQueryBuilder = QueryByCriteria.Builder.create();
            newQueryBuilder.setMaxResults(Integer.valueOf(1));
            newQueryBuilder.setCountFlag(CountFlag.INCLUDE);
            newQueryBuilder.setPredicates(new Predicate[]{newPredicate});
            EntityDefaultQueryResults newQr = this.getIdentityService().findEntityDefaults(newQueryBuilder.build());
            if (newQr.getResults().isEmpty()) {
                String principalNm = entityCriteria.get("principals.principalName");
                try {
                    EntityDefault entityDefault = this.getIdentityService().getEntityDefaultByPrincipalName(principalNm);
                    for (Principal p : entityDefault.getPrincipals()) {
                        if (p.isActive()) continue;
                        people.add(this.convertEntityToPerson(entityDefault, p));
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)("A principal name of " + principalNm + " dose not exist in the system"));
                }
            }
        }
        return people;
    }

    public Map<String, String> convertPersonPropertiesToEntityProperties(Map<String, String> criteria) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("convertPersonPropertiesToEntityProperties: " + criteria));
        }
        boolean nameCriteria = false;
        boolean addressCriteria = false;
        boolean externalIdentifierCriteria = false;
        boolean affiliationCriteria = false;
        boolean affiliationDefaultOnlyCriteria = false;
        boolean phoneCriteria = false;
        boolean emailCriteria = false;
        boolean employeeIdCriteria = false;
        HashMap<String, String> newCriteria = new HashMap<String, String>();
        newCriteria.putAll(this.baseLookupCriteria);
        newCriteria.put("entityTypeContactInfos.entityTypeCode", this.personEntityTypeLookupCriteria);
        if (criteria != null) {
            for (String key : criteria.keySet()) {
                String entityProperty;
                EntityExternalIdentifierType extIdType;
                String extIdTypeCode;
                if (!criteria.containsKey("active")) {
                    newCriteria.remove("active");
                }
                if (StringUtils.isEmpty((String)criteria.get(key))) continue;
                if (key.equals("externalId") && StringUtils.isNotBlank((String)criteria.get(key)) && criteria.containsKey("externalIdentifierTypeCode") && StringUtils.isNotBlank((String)(extIdTypeCode = criteria.get("externalIdentifierTypeCode"))) && (extIdType = this.getIdentityService().getExternalIdentifierType(extIdTypeCode)) != null && extIdType.isEncryptionRequired()) {
                    try {
                        if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                            criteria.put(key, CoreApiServiceLocator.getEncryptionService().encrypt((Object)criteria.get(key)));
                        }
                    }
                    catch (GeneralSecurityException ex) {
                        LOG.error((Object)("Unable to encrypt value for external ID search of type " + extIdTypeCode), (Throwable)ex);
                    }
                }
                if ((entityProperty = this.criteriaConversion.get(key)) != null) {
                    newCriteria.put(entityProperty, criteria.get(key));
                } else {
                    entityProperty = key;
                    newCriteria.put(key, criteria.get(key));
                }
                if (this.isNameEntityCriteria(entityProperty)) {
                    nameCriteria = true;
                }
                if (this.isExternalIdentifierEntityCriteria(entityProperty)) {
                    externalIdentifierCriteria = true;
                }
                if (this.isAffiliationEntityCriteria(entityProperty)) {
                    affiliationCriteria = true;
                }
                if (this.isAddressEntityCriteria(entityProperty)) {
                    addressCriteria = true;
                }
                if (this.isPhoneEntityCriteria(entityProperty)) {
                    phoneCriteria = true;
                }
                if (this.isEmailEntityCriteria(entityProperty)) {
                    emailCriteria = true;
                }
                if (this.isEmployeeIdEntityCriteria(entityProperty)) {
                    employeeIdCriteria = true;
                }
                if (!key.equals("campusCode")) continue;
                affiliationDefaultOnlyCriteria = true;
            }
            if (nameCriteria) {
                newCriteria.put("names.active", "Y");
                newCriteria.put("names.defaultValue", "Y");
            }
            if (addressCriteria) {
                newCriteria.put("entityTypeContactInfos.addresses.active", "Y");
                newCriteria.put("entityTypeContactInfos.addresses.defaultValue", "Y");
            }
            if (phoneCriteria) {
                newCriteria.put("entityTypeContactInfos.phoneNumbers.active", "Y");
                newCriteria.put("entityTypeContactInfos.phoneNumbers.defaultValue", "Y");
            }
            if (emailCriteria) {
                newCriteria.put("entityTypeContactInfos.emailAddresses.active", "Y");
                newCriteria.put("entityTypeContactInfos.emailAddresses.defaultValue", "Y");
            }
            if (employeeIdCriteria) {
                newCriteria.put("employmentInformation.active", "Y");
                newCriteria.put("employmentInformation.primary", "Y");
                if (criteria.size() == 1) {
                    newCriteria.remove("entityTypeContactInfos.active");
                    newCriteria.remove("entityTypeContactInfos.entityTypeCode");
                }
            }
            if (affiliationCriteria) {
                newCriteria.put("affiliations.active", "Y");
            }
            if (affiliationDefaultOnlyCriteria) {
                newCriteria.put("affiliations.defaultValue", "Y");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Converted: " + newCriteria));
        }
        return newCriteria;
    }

    protected boolean isNameEntityCriteria(String propertyName) {
        return propertyName.startsWith(ENTITY_NAME_PROPERTY_PREFIX);
    }

    protected boolean isAddressEntityCriteria(String propertyName) {
        return propertyName.startsWith(ENTITY_ADDRESS_PROPERTY_PREFIX);
    }

    protected boolean isPhoneEntityCriteria(String propertyName) {
        return propertyName.startsWith(ENTITY_PHONE_PROPERTY_PREFIX);
    }

    protected boolean isEmailEntityCriteria(String propertyName) {
        return propertyName.startsWith(ENTITY_EMAIL_PROPERTY_PREFIX);
    }

    protected boolean isEmployeeIdEntityCriteria(String propertyName) {
        return propertyName.startsWith(ENTITY_EMPLOYEE_ID_PROPERTY_PREFIX);
    }

    protected boolean isAffiliationEntityCriteria(String propertyName) {
        return propertyName.startsWith(ENTITY_AFFILIATION_PROPERTY_PREFIX);
    }

    protected boolean isExternalIdentifierEntityCriteria(String propertyName) {
        return propertyName.startsWith(ENTITY_EXT_ID_PROPERTY_PREFIX);
    }

    public List<String> getPersonEntityTypeCodes() {
        return this.personEntityTypeCodes;
    }

    public void setPersonEntityTypeCodes(List<String> personEntityTypeCodes) {
        this.personEntityTypeCodes = personEntityTypeCodes;
        this.personEntityTypeLookupCriteria = null;
        for (String entityTypeCode : personEntityTypeCodes) {
            if (this.personEntityTypeLookupCriteria == null) {
                this.personEntityTypeLookupCriteria = entityTypeCode;
                continue;
            }
            this.personEntityTypeLookupCriteria = this.personEntityTypeLookupCriteria + "|" + entityTypeCode;
        }
    }

    protected List<Person> getPeople(Collection<String> principalIds) {
        ArrayList<Person> people = new ArrayList<Person>(principalIds.size());
        for (String principalId : principalIds) {
            people.add(this.getPerson(principalId));
        }
        return people;
    }

    protected List<String> peopleToPrincipalIds(List<Person> people) {
        ArrayList<String> principalIds = new ArrayList<String>();
        for (Person person : people) {
            principalIds.add(person.getPrincipalId());
        }
        return principalIds;
    }

    public List<Person> getPersonByExternalIdentifier(String externalIdentifierTypeCode, String externalId) {
        if (StringUtils.isBlank((String)externalIdentifierTypeCode) || StringUtils.isBlank((String)externalId)) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>(2);
        criteria.put("externalIdentifierTypeCode", externalIdentifierTypeCode);
        criteria.put("externalId", externalId);
        return this.findPeople(criteria);
    }

    public Person updatePersonIfNecessary(String sourcePrincipalId, Person currentPerson) {
        if (currentPerson == null || !StringUtils.equals((String)sourcePrincipalId, (String)currentPerson.getPrincipalId()) || currentPerson.getEntityId() == null) {
            Person person = this.getPerson(sourcePrincipalId);
            if (person == null && currentPerson != null && currentPerson.getEntityId() == null) {
                return currentPerson;
            }
            if (person == null && currentPerson == null) {
                try {
                    return new PersonImpl();
                }
                catch (Exception ex) {
                    LOG.error((Object)("unable to instantiate an object of type: " + this.getPersonImplementationClass() + " - returning null"), (Throwable)ex);
                    return null;
                }
            }
            return person;
        }
        return currentPerson;
    }

    private Map<String, String> getNonPersonSearchCriteria(Object bo, Map<String, String> fieldValues) {
        HashMap<String, String> nonUniversalUserSearchCriteria = new HashMap<String, String>();
        for (String propertyName : fieldValues.keySet()) {
            if (this.isPersonProperty(bo, propertyName)) continue;
            nonUniversalUserSearchCriteria.put(propertyName, fieldValues.get(propertyName));
        }
        return nonUniversalUserSearchCriteria;
    }

    private boolean isPersonProperty(Object bo, String propertyName) {
        block4: {
            try {
                if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)propertyName) && !StringUtils.contains((String)propertyName, (String)"add.")) {
                    int lastIndex = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)propertyName);
                    String propertyTypeName = lastIndex != -1 ? StringUtils.substring((String)propertyName, (int)0, (int)lastIndex) : "";
                    Class type = PropertyUtils.getPropertyType((Object)bo, (String)propertyTypeName);
                    if (type != null) {
                        return Person.class.isAssignableFrom(type);
                    }
                    LOG.warn((Object)("Unable to determine type of nested property: " + bo.getClass().getName() + " / " + propertyName));
                }
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("Unable to determine if property on " + bo.getClass().getName() + " to a person object: " + propertyName), (Throwable)ex);
            }
        }
        return false;
    }

    public Map<String, String> resolvePrincipalNamesToPrincipalIds(BusinessObject businessObject, Map<String, String> fieldValues) {
        if (fieldValues == null) {
            return null;
        }
        if (businessObject == null) {
            return fieldValues;
        }
        StringBuffer resolvedPrincipalIdPropertyName = new StringBuffer();
        Map<String, String> processedFieldValues = this.getNonPersonSearchCriteria(businessObject, fieldValues);
        for (String propertyName : fieldValues.keySet()) {
            String principalName;
            if (!StringUtils.isBlank((String)fieldValues.get(propertyName)) && this.isPersonProperty(businessObject, propertyName)) {
                String personReferenceObjectPropertyName;
                int lastPropertyIndex = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)propertyName);
                String personPropertyName = lastPropertyIndex != -1 ? StringUtils.substring((String)propertyName, (int)(lastPropertyIndex + 1)) : propertyName;
                if (!StringUtils.equals((String)"principalName", (String)personPropertyName)) continue;
                Class<?> targetBusinessObjectClass = null;
                BusinessObject targetBusinessObject = null;
                resolvedPrincipalIdPropertyName.setLength(0);
                String string = personReferenceObjectPropertyName = lastPropertyIndex != -1 ? StringUtils.substring((String)propertyName, (int)0, (int)lastPropertyIndex) : "";
                if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)personReferenceObjectPropertyName)) {
                    int lastTargetIndex = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)personReferenceObjectPropertyName);
                    String targetBusinessObjectPropertyName = lastTargetIndex != -1 ? StringUtils.substring((String)personReferenceObjectPropertyName, (int)0, (int)lastTargetIndex) : "";
                    DataObjectWrapper wrapper = KradDataServiceLocator.getDataObjectService().wrap((Object)businessObject);
                    targetBusinessObject = (BusinessObject)wrapper.getPropertyValueNullSafe(targetBusinessObjectPropertyName);
                    if (targetBusinessObject != null) {
                        targetBusinessObjectClass = targetBusinessObject.getClass();
                        resolvedPrincipalIdPropertyName.append(targetBusinessObjectPropertyName).append(".");
                    } else {
                        LOG.error((Object)("Could not find target property '" + propertyName + "' in class " + businessObject.getClass().getName() + ". Property value was null."));
                    }
                } else {
                    targetBusinessObjectClass = businessObject.getClass();
                    targetBusinessObject = businessObject;
                }
                if (targetBusinessObjectClass != null) {
                    int lastIndex = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)personReferenceObjectPropertyName);
                    String propName = lastIndex != -1 ? StringUtils.substring((String)personReferenceObjectPropertyName, (int)(lastIndex + 1)) : personReferenceObjectPropertyName;
                    DataObjectRelationship rel = this.getBusinessObjectMetaDataService().getBusinessObjectRelationship((Object)targetBusinessObject, propName);
                    if (rel != null) {
                        String sourcePrimitivePropertyName = rel.getParentAttributeForChildAttribute("principalId");
                        resolvedPrincipalIdPropertyName.append(sourcePrimitivePropertyName);
                        String principalName2 = fieldValues.get(propertyName);
                        Principal principal = this.getIdentityService().getPrincipalByPrincipalName(principalName2);
                        if (principal != null) {
                            processedFieldValues.put(resolvedPrincipalIdPropertyName.toString(), principal.getPrincipalId());
                            continue;
                        }
                        processedFieldValues.put(resolvedPrincipalIdPropertyName.toString(), null);
                        try {
                            KRADUtils.setObjectProperty((Object)targetBusinessObject, (String)resolvedPrincipalIdPropertyName.toString(), null);
                            KRADUtils.setObjectProperty((Object)targetBusinessObject, (String)propName, null);
                            KRADUtils.setObjectProperty((Object)targetBusinessObject, (String)(propName + ".principalName"), (Object)principalName2);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Unable to blank out the person object after finding that the person with the given principalName does not exist.", (Throwable)ex);
                        }
                        continue;
                    }
                    LOG.error((Object)("Missing relationship for " + propName + " on " + targetBusinessObjectClass.getName()));
                    continue;
                }
                processedFieldValues.put(resolvedPrincipalIdPropertyName.toString(), null);
                continue;
            }
            if (!propertyName.endsWith(".principalName") || !StringUtils.isNotEmpty((String)(principalName = fieldValues.get(propertyName)))) continue;
            String containerPropertyName = propertyName;
            if (containerPropertyName.startsWith("add.")) {
                containerPropertyName = StringUtils.substringAfter((String)propertyName, (String)"add.");
            }
            if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)containerPropertyName)) {
                String collectionName = StringUtils.substringBefore((String)containerPropertyName, (String)".");
                Class collectionBusinessObjectClass = this.getMaintenanceDocumentDictionaryService().getCollectionBusinessObjectClass(this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(businessObject.getClass()), collectionName);
                if (collectionBusinessObjectClass != null) {
                    List relationships = this.getBusinessObjectMetaDataService().getBusinessObjectRelationships(collectionBusinessObjectClass);
                    for (DataObjectRelationship rel : relationships) {
                        String currRelatedPersonPrincipalId;
                        String parentAttribute = rel.getParentAttributeForChildAttribute("principalId");
                        if (parentAttribute == null) continue;
                        processedFieldValues.remove(propertyName);
                        String fieldPrefix = StringUtils.substringBeforeLast((String)StringUtils.substringBeforeLast((String)propertyName, (String)".principalName"), (String)".");
                        String relatedPrincipalIdPropertyName = fieldPrefix + "." + parentAttribute;
                        if (EXTENSION.equals(StringUtils.substringAfterLast((String)fieldPrefix, (String)".")) && EXTENSION.equals(StringUtils.substringBefore((String)parentAttribute, (String)"."))) {
                            relatedPrincipalIdPropertyName = fieldPrefix + "." + StringUtils.substringAfter((String)parentAttribute, (String)".");
                        }
                        if (!StringUtils.isBlank((String)(currRelatedPersonPrincipalId = processedFieldValues.get(relatedPrincipalIdPropertyName)))) continue;
                        Principal principal = this.getIdentityService().getPrincipalByPrincipalName(principalName);
                        if (principal != null) {
                            processedFieldValues.put(relatedPrincipalIdPropertyName, principal.getPrincipalId());
                            continue;
                        }
                        processedFieldValues.put(relatedPrincipalIdPropertyName, null);
                    }
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Unable to determine class for collection referenced as part of property: " + containerPropertyName + " on " + businessObject.getClass().getName()));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Non-nested property ending with 'principalName': " + containerPropertyName + " on " + businessObject.getClass().getName()));
        }
        return processedFieldValues;
    }

    protected IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    protected RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = KimApiServiceLocator.getRoleService();
        }
        return this.roleService;
    }

    public Class<? extends Person> getPersonImplementationClass() {
        return PersonImpl.class;
    }

    protected BusinessObjectMetaDataService getBusinessObjectMetaDataService() {
        if (this.businessObjectMetaDataService == null) {
            this.businessObjectMetaDataService = KNSServiceLocator.getBusinessObjectMetaDataService();
        }
        return this.businessObjectMetaDataService;
    }

    protected MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (this.maintenanceDocumentDictionaryService == null) {
            this.maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return this.maintenanceDocumentDictionaryService;
    }
}

