/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.lookup;

import java.io.Serializable;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.web.format.DateFormatter;
import org.kuali.rice.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.rice.kns.document.authorization.FieldRestriction;
import org.kuali.rice.kns.service.BusinessObjectAuthorizationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.ObjectUtils;

@Deprecated
public abstract class HtmlData
implements Serializable {
    protected static final Logger LOG = Logger.getLogger(HtmlData.class);
    public static final String ANCHOR_HTML_DATA_TYPE = AnchorHtmlData.class.getName();
    public static final String INPUT_HTML_DATA_TYPE = InputHtmlData.class.getName();
    protected String name = "";
    protected String title = "";
    protected String methodToCall = "";
    protected String displayText = "";
    protected String prependDisplayText = "";
    protected String appendDisplayText = "";
    protected List<HtmlData> childUrlDataList;
    protected String maxLength;
    private static BusinessObjectAuthorizationService businessObjectAuthorizationService;

    public abstract String constructCompleteHtmlTag();

    public String getAppendDisplayText() {
        return this.appendDisplayText;
    }

    public void setAppendDisplayText(String appendDisplayText) {
        this.appendDisplayText = appendDisplayText;
    }

    public List<HtmlData> getChildUrlDataList() {
        return this.childUrlDataList;
    }

    public void setChildUrlDataList(List<HtmlData> childUrlDataList) {
        this.childUrlDataList = childUrlDataList;
    }

    public String getPrependDisplayText() {
        return this.prependDisplayText;
    }

    public void setPrependDisplayText(String prependDisplayText) {
        this.prependDisplayText = prependDisplayText;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setDisplayText(String displayText) {
        this.displayText = displayText;
    }

    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    public String getTitle(String prependText, Class bo, List keys) {
        return "";
    }

    public static String getTitleText(String prependText, Object dataObject, List<String> keys, BusinessObjectRestrictions businessObjectRestrictions) {
        if (dataObject == null) {
            return "";
        }
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        for (String fieldNm : keys) {
            Object fieldVal = ObjectUtils.getPropertyValue((Object)dataObject, (String)fieldNm);
            FieldRestriction fieldRestriction = null;
            if (businessObjectRestrictions != null) {
                fieldRestriction = businessObjectRestrictions.getFieldRestriction(fieldNm);
            }
            if (KNSServiceLocator.getDataDictionaryService().getAttributeDefinition(dataObject.getClass().getName(), fieldNm) == null) {
                fieldVal = "";
            } else if (fieldRestriction != null && (fieldRestriction.isMasked() || fieldRestriction.isPartiallyMasked())) {
                fieldVal = fieldRestriction.getMaskFormatter().maskValue(fieldVal);
            } else if (fieldVal == null) {
                fieldVal = "";
            } else if (fieldVal instanceof Date) {
                DateFormatter dateFormatter = new DateFormatter();
                fieldVal = dateFormatter.format(fieldVal);
            }
            keyValueMap.put(fieldNm, fieldVal.toString());
        }
        return HtmlData.getTitleText(prependText, dataObject.getClass(), keyValueMap);
    }

    private static BusinessObjectAuthorizationService getBusinessObjectAuthorizationService() {
        if (businessObjectAuthorizationService == null) {
            businessObjectAuthorizationService = KNSServiceLocator.getBusinessObjectAuthorizationService();
        }
        return businessObjectAuthorizationService;
    }

    public static String getTitleText(String prependText, Class<?> dataObjectClass, Map<String, String> keyValueMap) {
        StringBuffer titleText = new StringBuffer(prependText);
        for (String key : keyValueMap.keySet()) {
            String fieldVal = keyValueMap.get(key).toString();
            if (!StringUtils.isNotBlank((String)fieldVal)) continue;
            titleText.append(KRADServiceLocatorWeb.getDataDictionaryService().getAttributeLabel(dataObjectClass, key) + "=" + fieldVal.toString() + " ");
        }
        return titleText.toString();
    }

    public int getMaxLength() {
        try {
            return Integer.parseInt(this.maxLength);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public void setMaxLength(String maxLength) {
        this.maxLength = maxLength;
    }

    public static class MultipleAnchorHtmlData
    extends AnchorHtmlData {
        protected List<AnchorHtmlData> anchorHtmlData;
        protected static final String ANCHORS_SEPARATOR = ", ";

        public MultipleAnchorHtmlData(List<AnchorHtmlData> anchorHtmlData) {
            this.anchorHtmlData = anchorHtmlData;
        }

        @Override
        public String constructCompleteHtmlTag() {
            StringBuffer completeHtmlTag = new StringBuffer();
            for (AnchorHtmlData anchor : this.anchorHtmlData) {
                completeHtmlTag.append(anchor.constructCompleteHtmlTag() + ",");
            }
            if (completeHtmlTag.toString().endsWith(ANCHORS_SEPARATOR)) {
                completeHtmlTag.delete(completeHtmlTag.length() - ANCHORS_SEPARATOR.length(), completeHtmlTag.length());
            }
            return completeHtmlTag.toString();
        }

        public List<AnchorHtmlData> getAnchorHtmlData() {
            return this.anchorHtmlData;
        }
    }

    public static class InputHtmlData
    extends HtmlData {
        public static final String CHECKBOX_INPUT_TYPE = "checkbox";
        public static final String CHECKBOX_CHECKED_VALUE = "checked";
        protected String inputType = "";
        protected String src = "";
        protected String styleClass = "";
        protected String border = "0";
        protected String checked = "";
        protected String value = "";

        public InputHtmlData(String name, String inputType) {
            this.name = name;
            this.inputType = inputType;
        }

        public InputHtmlData(String name, String inputType, String src) {
            this.name = name;
            this.inputType = inputType;
            this.src = src;
        }

        @Override
        public String constructCompleteHtmlTag() {
            return this.getPrependDisplayText() + "<input title=\"" + this.title + "\"" + " name=\"" + this.getName() + "\"" + (StringUtils.isEmpty((String)this.src) ? "" : " src=\"" + this.src + "\" ") + " type=\"" + this.getInputType() + "\"" + (StringUtils.isEmpty((String)this.value) ? "" : " value=\"" + this.value + "\" ") + (StringUtils.isEmpty((String)this.checked) ? "" : " checked=\"" + this.checked + "\" ") + (StringUtils.isEmpty((String)this.getStyleClass()) ? "" : " styleClass=\"" + this.getStyleClass() + "\" ") + " border=\"" + this.getBorder() + "\"" + " value=\"" + this.getDisplayText() + "\"" + "/>" + this.getAppendDisplayText();
        }

        public String getInputType() {
            return this.inputType;
        }

        public String getSrc() {
            return this.src;
        }

        public String getBorder() {
            return this.border;
        }

        public void setBorder(String border) {
            this.border = border;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public void setStyleClass(String styleClass) {
            this.styleClass = styleClass;
        }

        public void setChecked(String checked) {
            this.checked = checked;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class AnchorHtmlData
    extends HtmlData {
        public static final String TARGET_BLANK = "_blank";
        protected String href = "";
        protected String target = "";
        protected String style = "";
        protected String styleClass = "";
        protected String onclick = "";

        public AnchorHtmlData() {
        }

        public AnchorHtmlData(String href, String title) {
            this.href = href;
            this.title = title;
        }

        public AnchorHtmlData(String href, String methodToCall, String displayText) {
            this.href = href;
            this.methodToCall = methodToCall;
            this.displayText = displayText;
        }

        public void setHref(String href) {
            this.href = href;
        }

        @Override
        public String constructCompleteHtmlTag() {
            String completeHtmlTag = StringUtils.isEmpty((String)this.getHref()) ? this.getDisplayText() : this.getPrependDisplayText() + "<a title=\"" + this.title + "\"" + " href=\"" + this.getHref() + "\"" + this.getStyle() + " " + this.getStyleClass() + " " + (StringUtils.isEmpty((String)this.getOnclick()) ? "" : " onClick=\"" + this.getOnclick() + "\" ") + (StringUtils.isEmpty((String)this.getTarget()) ? "" : " target=\"" + this.getTarget() + "\" ") + ">" + this.getDisplayText() + "</a>" + this.getAppendDisplayText();
            return completeHtmlTag;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public String getStyle() {
            return this.style;
        }

        public void setStyle(String style) {
            this.style = style;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public void setStyleClass(String styleClass) {
            this.styleClass = styleClass;
        }

        public String getOnclick() {
            return this.onclick;
        }

        public void setOnclick(String onclick) {
            this.onclick = onclick;
        }

        public String getHref() {
            return this.href;
        }

        @Override
        public String getMethodToCall() {
            return this.methodToCall;
        }
    }
}

