/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.web.comparator;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.lang.StringUtils;
import org.displaytag.model.Cell;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.kns.web.comparator.NullCellComparator;
import org.kuali.rice.kns.web.comparator.NullValueComparator;
import org.kuali.rice.kns.web.comparator.NumericCellComparator;
import org.kuali.rice.kns.web.comparator.StringCellComparator;
import org.kuali.rice.kns.web.comparator.TemporalCellComparator;
import org.kuali.rice.krad.comparator.NumericValueComparator;
import org.kuali.rice.krad.comparator.StringValueComparator;
import org.kuali.rice.krad.comparator.TemporalValueComparator;

public class CellComparatorHelper {
    private static Pattern HREF_ENCLOSURE = Pattern.compile("<a [^>]+>([^<]*)</a>.*", 8);

    public static String getSanitizedStaticValue(Cell cell) {
        if (null == cell) {
            return null;
        }
        return null == cell.getStaticValue() ? null : CellComparatorHelper.getSanitizedStaticValue(cell.getStaticValue().toString());
    }

    public static String getSanitizedStaticValue(String staticValue) {
        if (null == staticValue) {
            return null;
        }
        staticValue = StringUtils.replace((String)staticValue, (String)"\r", (String)"");
        staticValue = StringUtils.replace((String)staticValue, (String)"\n", (String)"");
        String sanitizedValue = staticValue = StringUtils.replace((String)staticValue, (String)"\t", (String)"");
        Matcher matcher = HREF_ENCLOSURE.matcher(staticValue);
        if (matcher.matches()) {
            sanitizedValue = matcher.group(1).trim();
        }
        while (sanitizedValue.endsWith("&nbsp;")) {
            sanitizedValue = sanitizedValue.substring(0, sanitizedValue.length() - 6).trim();
        }
        return sanitizedValue;
    }

    public static Comparator getAppropriateComparatorForPropertyClass(Class propClass) {
        if (propClass == null) {
            return new NullCellComparator();
        }
        if (TypeUtils.isDecimalClass((Class)propClass) || TypeUtils.isIntegralClass((Class)propClass)) {
            return new NumericCellComparator();
        }
        if (TypeUtils.isTemporalClass((Class)propClass)) {
            return new TemporalCellComparator();
        }
        if (String.class.equals((Object)propClass)) {
            return new StringCellComparator();
        }
        return ComparableComparator.getInstance();
    }

    public static Comparator getAppropriateValueComparatorForPropertyClass(Class propClass) {
        if (propClass == null) {
            return NullValueComparator.getInstance();
        }
        if (TypeUtils.isDecimalClass((Class)propClass) || TypeUtils.isIntegralClass((Class)propClass)) {
            return NumericValueComparator.getInstance();
        }
        if (TypeUtils.isTemporalClass((Class)propClass)) {
            return TemporalValueComparator.getInstance();
        }
        if (String.class.equals((Object)propClass)) {
            return StringValueComparator.getInstance();
        }
        return ComparableComparator.getInstance();
    }
}

