/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.util.BeanPropertyComparator;

public class BeanPropertyComparatorTest {
    @Test
    public void testConstructor_nullList() {
        boolean failedAsExpected = false;
        try {
            new BeanPropertyComparator(null);
        }
        catch (IllegalArgumentException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void testConstructor_emptyList() {
        boolean failedAsExpected = false;
        try {
            new BeanPropertyComparator(new ArrayList());
        }
        catch (IllegalArgumentException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void testCompare_unknownPropertyNames() {
        boolean failedAsExpected;
        block2: {
            List<String> unknownProperties = Arrays.asList("one", "two", "three");
            BeanPropertyComparator bpc = new BeanPropertyComparator(unknownProperties);
            A a = new A("something", new Integer(0), false);
            B b = new B("something else", new Integer(1), true);
            failedAsExpected = false;
            try {
                bpc.compare((Object)a, (Object)b);
            }
            catch (BeanPropertyComparator.BeanComparisonException e) {
                if (!(e.getCause() instanceof NullPointerException)) break block2;
                failedAsExpected = true;
            }
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void testCompare_propertyTypeMismatch() {
        List<String> mismatchedProperties = Arrays.asList("i", "b");
        BeanPropertyComparator bpc = new BeanPropertyComparator(mismatchedProperties);
        A a = new A("something", new Integer(0), false);
        C c = new C("something else", 1.0f, true);
        boolean failedAsExpected = false;
        try {
            bpc.compare((Object)a, (Object)c);
        }
        catch (ClassCastException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void testCompare_privateProperty() {
        boolean failedAsExpected;
        block2: {
            List<String> privateProperty = Arrays.asList("s");
            BeanPropertyComparator bpc = new BeanPropertyComparator(privateProperty);
            C c = new C("something else", 1.0f, true);
            A a = new A("something", new Integer(0), false);
            failedAsExpected = false;
            try {
                bpc.compare((Object)c, (Object)a);
            }
            catch (BeanPropertyComparator.BeanComparisonException e) {
                if (!(e.getCause() instanceof NullPointerException)) break block2;
                failedAsExpected = true;
            }
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void testCompare_oneProperty_string() {
        B greater;
        A lesser;
        List<String> properties = Arrays.asList("s");
        BeanPropertyComparator bpc = new BeanPropertyComparator(properties);
        int lessThan = bpc.compare((Object)(lesser = new A("One", new Integer(0), false)), (Object)(greater = new B("Two", new Integer(0), false)));
        Assert.assertTrue((lessThan < 0 ? 1 : 0) != 0);
        int greaterThan = bpc.compare((Object)greater, (Object)lesser);
        Assert.assertTrue((greaterThan > 0 ? 1 : 0) != 0);
        int equal = bpc.compare((Object)greater, (Object)greater);
        Assert.assertTrue((equal == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_oneProperty_integer() {
        B greater;
        A lesser;
        List<String> properties = Arrays.asList("i");
        BeanPropertyComparator bpc = new BeanPropertyComparator(properties);
        int lessThan = bpc.compare((Object)(lesser = new A("One", new Integer(-1), false)), (Object)(greater = new B("One", new Integer(1), false)));
        Assert.assertTrue((lessThan < 0 ? 1 : 0) != 0);
        int greaterThan = bpc.compare((Object)greater, (Object)lesser);
        Assert.assertTrue((greaterThan > 0 ? 1 : 0) != 0);
        int equal = bpc.compare((Object)greater, (Object)greater);
        Assert.assertTrue((equal == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_oneProperty_boolean() {
        B greater;
        A lesser;
        List<String> properties = Arrays.asList("b");
        BeanPropertyComparator bpc = new BeanPropertyComparator(properties);
        int lessThan = bpc.compare((Object)(lesser = new A("One", new Integer(0), false)), (Object)(greater = new B("One", new Integer(0), true)));
        Assert.assertTrue((lessThan < 0 ? 1 : 0) != 0);
        int greaterThan = bpc.compare((Object)greater, (Object)lesser);
        Assert.assertTrue((greaterThan > 0 ? 1 : 0) != 0);
        int equal = bpc.compare((Object)greater, (Object)greater);
        Assert.assertTrue((equal == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_oneLevel() {
        B greater;
        A lesser;
        List<String> propertiesSIB = Arrays.asList("s", "i", "b");
        BeanPropertyComparator bpcSIB = new BeanPropertyComparator(propertiesSIB);
        int lessThan = bpcSIB.compare((Object)(lesser = new A("One", new Integer(0), false)), (Object)(greater = new B("Two", new Integer(0), false)));
        Assert.assertTrue((lessThan < 0 ? 1 : 0) != 0);
        int greaterThan = bpcSIB.compare((Object)greater, (Object)lesser);
        Assert.assertTrue((greaterThan > 0 ? 1 : 0) != 0);
        int equal = bpcSIB.compare((Object)greater, (Object)greater);
        Assert.assertTrue((equal == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_twoLevels() {
        B greater;
        A lesser;
        List<String> propertiesSIB = Arrays.asList("s", "i", "b");
        BeanPropertyComparator bpc = new BeanPropertyComparator(propertiesSIB);
        int lessThan = bpc.compare((Object)(lesser = new A("Same", new Integer(-1), false)), (Object)(greater = new B("Same", new Integer(1), false)));
        Assert.assertTrue((lessThan < 0 ? 1 : 0) != 0);
        int greaterThan = bpc.compare((Object)greater, (Object)lesser);
        Assert.assertTrue((greaterThan > 0 ? 1 : 0) != 0);
        int equal = bpc.compare((Object)greater, (Object)greater);
        Assert.assertTrue((equal == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_threeLevels() {
        B greater;
        A lesser;
        List<String> propertiesSIB = Arrays.asList("s", "i", "b");
        BeanPropertyComparator bpc = new BeanPropertyComparator(propertiesSIB);
        int lessThan = bpc.compare((Object)(lesser = new A("Same", new Integer(1), false)), (Object)(greater = new B("Same", new Integer(1), true)));
        Assert.assertTrue((lessThan < 0 ? 1 : 0) != 0);
        int greaterThan = bpc.compare((Object)greater, (Object)lesser);
        Assert.assertTrue((greaterThan > 0 ? 1 : 0) != 0);
        int equal = bpc.compare((Object)greater, (Object)greater);
        Assert.assertTrue((equal == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_differentCases() {
        List<String> propertiesSIB = Arrays.asList("s", "i", "b");
        BeanPropertyComparator sensitive = new BeanPropertyComparator(propertiesSIB, false);
        BeanPropertyComparator insensitive = new BeanPropertyComparator(propertiesSIB, true);
        A lesser = new A("SomeThing", new Integer(1), false);
        B greater = new B("something", new Integer(1), false);
        int equal = insensitive.compare((Object)greater, (Object)lesser);
        Assert.assertTrue((equal == 0 ? 1 : 0) != 0);
        int inequal = sensitive.compare((Object)greater, (Object)lesser);
        Assert.assertTrue((inequal != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_differentDates() throws ParseException {
        List<String> propertiesD = Arrays.asList("d");
        DateFormat dateFormat = SimpleDateFormat.getDateInstance(3);
        BeanPropertyComparator comparator = new BeanPropertyComparator(propertiesD);
        D lesser = new D(dateFormat.parse("01/01/1990"));
        D greater = new D(dateFormat.parse("01/02/1990"));
        int result = comparator.compare((Object)greater, (Object)lesser);
        Assert.assertEquals((long)1L, (long)result);
        result = comparator.compare((Object)lesser, (Object)greater);
        Assert.assertEquals((long)-1L, (long)result);
        result = comparator.compare((Object)lesser, (Object)lesser);
        Assert.assertEquals((long)0L, (long)result);
        result = comparator.compare((Object)greater, (Object)greater);
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testCompare_firstNullDates() throws ParseException {
        List<String> propertiesD = Arrays.asList("d");
        DateFormat dateFormat = SimpleDateFormat.getDateInstance(3);
        BeanPropertyComparator comparator = new BeanPropertyComparator(propertiesD);
        D lesser = new D(null);
        D greater = new D(dateFormat.parse("01/02/1990"));
        int result = comparator.compare((Object)greater, (Object)lesser);
        Assert.assertEquals((long)1L, (long)result);
        result = comparator.compare((Object)lesser, (Object)greater);
        Assert.assertEquals((long)-1L, (long)result);
        result = comparator.compare((Object)lesser, (Object)lesser);
        Assert.assertEquals((long)0L, (long)result);
        result = comparator.compare((Object)greater, (Object)greater);
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testCompare_secondNullDates() throws ParseException {
        List<String> propertiesD = Arrays.asList("d");
        DateFormat dateFormat = SimpleDateFormat.getDateInstance(3);
        BeanPropertyComparator comparator = new BeanPropertyComparator(propertiesD);
        D lesser = new D(dateFormat.parse("01/02/1990"));
        D greater = new D(null);
        int result = comparator.compare((Object)greater, (Object)lesser);
        Assert.assertEquals((long)-1L, (long)result);
        result = comparator.compare((Object)lesser, (Object)greater);
        Assert.assertEquals((long)1L, (long)result);
        result = comparator.compare((Object)lesser, (Object)lesser);
        Assert.assertEquals((long)0L, (long)result);
        result = comparator.compare((Object)greater, (Object)greater);
        Assert.assertEquals((long)0L, (long)result);
    }

    public static class D {
        private Date d;

        public D(Date d) {
            this.d = d;
        }

        public Date getD() {
            return this.d;
        }
    }

    public static class C {
        private boolean s;
        private String i;
        private float b;

        public C(String i, float b, boolean s) {
            this.s = s;
            this.i = i;
            this.b = b;
        }

        private boolean getS() {
            return this.s;
        }

        public String getI() {
            return this.i;
        }

        public float getB() {
            return this.b;
        }
    }

    public static class B {
        private String s;
        private Integer i;
        private Boolean b;
        private Long l;

        public B(String s, Integer i, Boolean b) {
            this.s = s;
            this.i = i;
            this.b = b;
            this.l = new Long(23L);
        }

        public String getS() {
            return this.s;
        }

        public Integer getI() {
            return this.i;
        }

        public Boolean getB() {
            return this.b;
        }

        public Long getL() {
            return this.l;
        }
    }

    public static class A {
        private String s;
        private Integer i;
        private Boolean b;

        public A(String s, Integer i, Boolean b) {
            this.s = s;
            this.i = i;
            this.b = b;
        }

        public String getS() {
            return this.s;
        }

        public Integer getI() {
            return this.i;
        }

        public Boolean getB() {
            return this.b;
        }
    }
}

