/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class MessageMapTest {
    private static final String MIXED_LIST_PATTERN = "document.sourceAccounting*,document.targetAccounting*,foo,bar,newSourceLine*,newTargetLine*";

    @Test
    public void testPut() {
        MessageMap testMap = new MessageMap();
        try {
            testMap.putError("accountNbr", "error.inactive", new String[0]);
        }
        catch (RuntimeException e) {
            Assert.fail((String)"ErrorMap threw exception adding string pair");
        }
    }

    @Test
    public void testErrorCount() {
        MessageMap testMap = new MessageMap();
        testMap.putError("accountNbr", "error.inactive", new String[0]);
        Assert.assertTrue((testMap.getErrorCount() == 1 ? 1 : 0) != 0);
        testMap.putError("accountNbr", "error.invalidFormat", new String[0]);
        Assert.assertTrue((testMap.getErrorCount() == 2 ? 1 : 0) != 0);
        testMap.putError("chartCode", "error.invalidFormat", new String[0]);
        testMap.putError("projectCode", "error.invalidFormat", new String[0]);
        testMap.putError("objectCode", "error.invalidFormat", new String[0]);
        Assert.assertTrue((testMap.getErrorCount() == 5 ? 1 : 0) != 0);
        testMap.removeAllErrorMessagesForProperty("accountNbr");
        Assert.assertTrue((testMap.getErrorCount() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testFieldMessages() {
        MessageMap testMap = new MessageMap();
        testMap.putError("accountNbr", "error.inactive", new String[0]);
        testMap.putError("accountNbr", "error.invalidFormat", new String[0]);
        testMap.putError("accountNbr", "error.phonenumber", new String[0]);
        Assert.assertEquals((long)3L, (long)testMap.countFieldMessages("accountNbr"));
        Assert.assertTrue((boolean)testMap.fieldHasMessage("accountNbr", "error.inactive"));
        Assert.assertTrue((boolean)testMap.fieldHasMessage("accountNbr", "error.invalidFormat"));
        Assert.assertTrue((boolean)testMap.fieldHasMessage("accountNbr", "error.phonenumber"));
    }

    @Test
    public void testErrorPath() {
        MessageMap testMap = new MessageMap();
        Assert.assertTrue((boolean)testMap.getKeyPath("accountNbr", true).equals("accountNbr"));
        testMap.addToErrorPath("document");
        Assert.assertTrue((boolean)testMap.getKeyPath("accountNbr", true).equals("document.accountNbr"));
        Assert.assertTrue((boolean)testMap.getKeyPath("accountNbr", false).equals("accountNbr"));
        testMap.removeFromErrorPath("document");
        Assert.assertTrue((boolean)testMap.getKeyPath("accountNbr", true).equals("accountNbr"));
        Assert.assertTrue((boolean)testMap.getKeyPath("accountNbr", false).equals("accountNbr"));
        testMap.addToErrorPath("document");
        testMap.addToErrorPath("newAccountingLine");
        Assert.assertTrue((boolean)testMap.getKeyPath("accountNbr", true).equals("document.newAccountingLine.accountNbr"));
        Assert.assertTrue((boolean)testMap.getKeyPath("accountNbr", false).equals("accountNbr"));
        testMap.putError("accountNbr", "error.inactive", new String[0]);
        Assert.assertEquals((long)1L, (long)testMap.countFieldMessages("document.newAccountingLine.accountNbr"));
        Assert.assertTrue((boolean)testMap.fieldHasMessage("document.newAccountingLine.accountNbr", "error.inactive"));
        testMap.removeAllErrorMessagesForProperty("document.newAccountingLine.accountNbr");
        testMap.putErrorWithoutFullErrorPath("accountNbr", "error.inactive", new String[0]);
        Assert.assertEquals((long)1L, (long)testMap.countFieldMessages("accountNbr"));
        Assert.assertTrue((boolean)testMap.fieldHasMessage("accountNbr", "error.inactive"));
        Assert.assertFalse((boolean)testMap.fieldHasMessage("document.newAccountingLine.accountNbr", "error.inactive"));
        Assert.assertTrue((boolean)testMap.getKeyPath("GLOBAL_ERRORS", true).equals("GLOBAL_ERRORS"));
        Assert.assertTrue((boolean)testMap.getKeyPath("projectCode.code", true).equals("document.newAccountingLine.projectCode.code"));
        testMap.removeFromErrorPath("newAccountingLine");
        Assert.assertTrue((boolean)testMap.getKeyPath("accountNbr", true).equals("document.accountNbr"));
        testMap.removeFromErrorPath("document");
        Assert.assertTrue((boolean)testMap.getKeyPath("accountNbr", true).equals("accountNbr"));
    }

    @Test
    public void testPropertiesWithErrors() {
        MessageMap testMap = new MessageMap();
        testMap.putError("accountNbr", "error.inactive", new String[0]);
        testMap.putError("projectCode", "error.inactive", new String[0]);
        testMap.putError("chartCode", "error.inactive", new String[0]);
        testMap.putError("objectCode", "error.inactive", new String[0]);
        testMap.putError("subAccountNbr", "error.inactive", new String[0]);
        Assert.assertTrue((boolean)testMap.getPropertiesWithErrors().contains("accountNbr"));
        Assert.assertTrue((boolean)testMap.getPropertiesWithErrors().contains("projectCode"));
        Assert.assertTrue((boolean)testMap.getPropertiesWithErrors().contains("chartCode"));
        Assert.assertTrue((boolean)testMap.getPropertiesWithErrors().contains("objectCode"));
        Assert.assertTrue((boolean)testMap.getPropertiesWithErrors().contains("subAccountNbr"));
    }

    @Test
    public void testMessageParameters() {
        MessageMap testMap = new MessageMap();
        testMap.putError("accountNbr", "error.inactive", new String[]{"Account Number"});
        testMap.putError("accountNbr", "error.required", new String[]{"Account Number"});
        testMap.putError("accountNbr", "error.inactive", new String[]{"Account Number"});
        testMap.putError("chartCode", "error.required", new String[]{"Chart Code"});
        Assert.assertEquals((long)3L, (long)testMap.getErrorCount());
        AutoPopulatingList errorMessages = testMap.getMessages("accountNbr");
        Assert.assertEquals((long)2L, (long)errorMessages.size());
        this.checkMessageParemeters(errorMessages, 0, "error.inactive", new String[]{"Account Number"});
        this.checkMessageParemeters(errorMessages, 1, "error.required", new String[]{"Account Number"});
        errorMessages = testMap.getMessages("chartCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        this.checkMessageParemeters(errorMessages, 0, "error.required", new String[]{"Chart Code"});
    }

    private void checkMessageParemeters(AutoPopulatingList errorMessages, int messageIndex, String expectedKeyConstant, String[] expectedParameters) {
        ErrorMessage message1 = (ErrorMessage)errorMessages.get(messageIndex);
        Assert.assertEquals((Object)expectedKeyConstant, (Object)message1.getErrorKey());
        Assert.assertTrue((boolean)Arrays.equals(message1.getMessageParameters(), expectedParameters));
    }

    @Test
    public void testMessageCollisions() {
        String PROPERTY_NAME = "document.sourceAccounting*,document.targetAccounting*,newSourceLine*,newTargetLine*";
        MessageMap testMap = new MessageMap();
        testMap.putError("document.sourceAccounting*,document.targetAccounting*,newSourceLine*,newTargetLine*", "error.inactive", new String[]{"Chart Code"});
        testMap.putError("document.sourceAccounting*,document.targetAccounting*,newSourceLine*,newTargetLine*", "error.document.subAccountClosed", new String[]{"Sub-Account Number"});
        testMap.putError("document.sourceAccounting*,document.targetAccounting*,newSourceLine*,newTargetLine*", "error.inactive", new String[]{"Object Code"});
        testMap.putError("document.sourceAccounting*,document.targetAccounting*,newSourceLine*,newTargetLine*", "error.inactive", new String[]{"SubObject Code"});
        testMap.putError("document.sourceAccounting*,document.targetAccounting*,newSourceLine*,newTargetLine*", "error.inactive", new String[]{"Project Code"});
        Assert.assertEquals((long)5L, (long)testMap.getErrorCount());
        AutoPopulatingList thing = testMap.getErrorMessagesForProperty("document.sourceAccounting*,document.targetAccounting*,newSourceLine*,newTargetLine*");
        HashSet<String[]> usedParams = new HashSet<String[]>();
        for (Map.Entry entry : testMap.getAllPropertiesAndErrors()) {
            String propertyKey = (String)entry.getKey();
            AutoPopulatingList messageList = (AutoPopulatingList)entry.getValue();
            for (ErrorMessage message : messageList) {
                String[] params = message.getMessageParameters();
                if (usedParams.contains(params)) {
                    Assert.fail((String)("usedParams contains duplicate parameters object '" + params + "'"));
                }
                usedParams.add(params);
            }
        }
    }

    @Test
    public void testContainsKeyMatchingPattern_mixedList_empty() {
        Assert.assertEquals((Object)false, (Object)new MessageMap().containsKeyMatchingPattern(MIXED_LIST_PATTERN));
    }

    @Test
    public void testContainsKeyMatchingPattern_mixedList_simpleNoMatch() {
        MessageMap testMap = new MessageMap();
        testMap.putError("xxx", "error.inactive", new String[]{"Chart Code"});
        testMap.putError("yyy", "error.inactive", new String[]{"Chart Code"});
        Assert.assertEquals((Object)false, (Object)testMap.containsKeyMatchingPattern(MIXED_LIST_PATTERN));
    }

    @Test
    public void testContainsKeyMatchingPattern_mixedList_simpleMatch() {
        MessageMap testMap = new MessageMap();
        testMap.putError("xxx", "error.inactive", new String[]{"Chart Code"});
        testMap.putError("foo", "error.inactive", new String[]{"Chart Code"});
        testMap.putError("yyy", "error.inactive", new String[]{"Chart Code"});
        Assert.assertEquals((Object)true, (Object)testMap.containsKeyMatchingPattern(MIXED_LIST_PATTERN));
    }

    @Test
    public void testContainsKeyMatchingPattern_mixedList_wildcardMatch() {
        MessageMap testMap = new MessageMap();
        testMap.putError("xxx", "error.inactive", new String[]{"Chart Code"});
        testMap.putError("document.targetAccountingLine.something", "error.inactive", new String[]{"Chart Code"});
        testMap.putError("yyy", "error.inactive", new String[]{"Chart Code"});
        Assert.assertEquals((Object)true, (Object)testMap.containsKeyMatchingPattern(MIXED_LIST_PATTERN));
    }

    @Test
    public void testReplace_testEquals() {
        MessageMap constantMap = this.buildReplaceErrorMap();
        MessageMap replaceMap = this.buildReplaceErrorMap();
        Assert.assertEquals((Object)replaceMap, (Object)replaceMap);
        Assert.assertEquals((Object)replaceMap, (Object)constantMap);
        Assert.assertEquals((Object)constantMap, (Object)replaceMap);
        replaceMap.putError("somethingElse", "error.inactive", new String[]{"Account Number"});
        Assert.assertFalse((boolean)replaceMap.equals((Object)constantMap));
    }

    @Test
    public void testReplace_noMatchingProperty() {
        MessageMap constantMap = this.buildReplaceErrorMap();
        MessageMap replaceMap = this.buildReplaceErrorMap();
        Assert.assertTrue((boolean)replaceMap.equals((Object)constantMap));
        Assert.assertFalse((boolean)replaceMap.containsMessageKey("fooKey"));
        boolean replaced = replaceMap.replaceError("fooName", "fooKey", "fooReplaceKey", new String[0]);
        Assert.assertFalse((boolean)replaced);
        Assert.assertTrue((boolean)replaceMap.equals((Object)constantMap));
        Assert.assertFalse((boolean)replaceMap.containsMessageKey("fooKey"));
    }

    @Test
    public void testReplace_matchingProperty_noMatchingKey() {
        MessageMap constantMap = this.buildReplaceErrorMap();
        MessageMap replaceMap = this.buildReplaceErrorMap();
        Assert.assertTrue((boolean)replaceMap.equals((Object)constantMap));
        Assert.assertFalse((boolean)replaceMap.containsMessageKey("fooKey"));
        boolean replaced = replaceMap.replaceError("accountNbr", "fooKey", "fooReplaceKey", new String[0]);
        Assert.assertFalse((boolean)replaced);
        Assert.assertTrue((boolean)replaceMap.equals((Object)constantMap));
        Assert.assertFalse((boolean)replaceMap.containsMessageKey("fooKey"));
    }

    @Test
    public void testReplace_matchingProperty_matchingKey_noParams() {
        MessageMap constantMap = this.buildReplaceErrorMap();
        MessageMap replaceMap = this.buildReplaceErrorMap();
        Assert.assertTrue((boolean)replaceMap.equals((Object)constantMap));
        Assert.assertTrue((boolean)replaceMap.containsMessageKey("error.inactive"));
        Assert.assertFalse((boolean)replaceMap.containsMessageKey("error.invalidNotAmong"));
        AutoPopulatingList preMessages = replaceMap.getMessages("accountNbr");
        Assert.assertEquals((long)2L, (long)preMessages.size());
        boolean replaced = replaceMap.replaceError("accountNbr", "error.inactive", "error.invalidNotAmong", new String[0]);
        Assert.assertTrue((boolean)replaced);
        Assert.assertFalse((boolean)replaceMap.equals((Object)constantMap));
        Assert.assertFalse((boolean)replaceMap.containsMessageKey("error.inactive"));
        Assert.assertTrue((boolean)replaceMap.containsMessageKey("error.invalidNotAmong"));
        AutoPopulatingList postMessages = replaceMap.getMessages("accountNbr");
        Assert.assertEquals((long)2L, (long)postMessages.size());
        int replacedCount = 0;
        for (ErrorMessage em : postMessages) {
            if (!em.getErrorKey().equals("error.invalidNotAmong")) continue;
            String[] params = em.getMessageParameters();
            Assert.assertEquals((long)0L, (long)params.length);
            ++replacedCount;
        }
        Assert.assertEquals((long)1L, (long)replacedCount);
    }

    @Test
    public void testReplace_matchingProperty_matchingKey_withParams() {
        MessageMap constantMap = this.buildReplaceErrorMap();
        MessageMap replaceMap = this.buildReplaceErrorMap();
        Assert.assertTrue((boolean)replaceMap.equals((Object)constantMap));
        Assert.assertTrue((boolean)replaceMap.containsMessageKey("error.inactive"));
        Assert.assertFalse((boolean)replaceMap.containsMessageKey("error.invalidNotAmong"));
        AutoPopulatingList preMessages = replaceMap.getMessages("accountNbr");
        Assert.assertEquals((long)2L, (long)preMessages.size());
        boolean replaced = replaceMap.replaceError("accountNbr", "error.inactive", "error.invalidNotAmong", new String[]{"zero", "one"});
        Assert.assertTrue((boolean)replaced);
        Assert.assertFalse((boolean)replaceMap.equals((Object)constantMap));
        Assert.assertFalse((boolean)replaceMap.containsMessageKey("error.inactive"));
        Assert.assertTrue((boolean)replaceMap.containsMessageKey("error.invalidNotAmong"));
        AutoPopulatingList postMessages = replaceMap.getMessages("accountNbr");
        Assert.assertEquals((long)2L, (long)postMessages.size());
        int replacedCount = 0;
        for (ErrorMessage em : postMessages) {
            if (!em.getErrorKey().equals("error.invalidNotAmong")) continue;
            String[] params = em.getMessageParameters();
            Assert.assertEquals((long)2L, (long)params.length);
            Assert.assertEquals((Object)"zero", (Object)params[0]);
            Assert.assertEquals((Object)"one", (Object)params[1]);
            ++replacedCount;
        }
        Assert.assertEquals((long)1L, (long)replacedCount);
    }

    private MessageMap buildReplaceErrorMap() {
        MessageMap testMap = new MessageMap();
        testMap.putError("accountNbr", "error.inactive", new String[]{"Account Number"});
        testMap.putError("accountNbr", "error.required", new String[]{"Account Number"});
        testMap.putError("chartCode", "error.required", new String[]{"Chart Code"});
        return testMap;
    }
}

