/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.util.UrlFactory;

public class UrlFactoryTest {
    @Test
    public void testFactoryMatch() throws Exception {
        String basePath = "http://localhost:8080/";
        String actionPath = "kr/lookup.do";
        String testUrl = basePath + actionPath + "?" + "methodToCall" + "=start" + "&" + "docFormKey" + "=903" + "lookupableImplServiceName" + "=accountLookupableImpl" + "returnLocation" + "=" + basePath + "ib.do";
        testUrl = UrlFactory.encode((String)testUrl);
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        parameters.put("docFormKey", "903");
        parameters.put("lookupableImplServiceName", "accountLookupableImpl");
        parameters.put("returnLocation", basePath + "ib.do");
        String returnedUrl = UrlFactory.parameterizeUrl((String)(basePath + actionPath), (Properties)parameters);
        Assert.assertTrue((String)"Returned url is empty", (boolean)StringUtils.isNotBlank((String)returnedUrl));
        Assert.assertTrue((String)"Returned url has incorrect base", (boolean)returnedUrl.startsWith(basePath + actionPath + "?"));
        Assert.assertTrue((String)"Returned url does not have correct # of &", (StringUtils.countMatches((String)returnedUrl, (String)"&") == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Returned url missing parameter 1", (boolean)StringUtils.contains((String)returnedUrl, (String)"methodToCall=start"));
        Assert.assertTrue((String)"Returned url missing parameter 2", (boolean)StringUtils.contains((String)returnedUrl, (String)"docFormKey=903"));
        Assert.assertTrue((String)"Returned url missing parameter 3", (boolean)StringUtils.contains((String)returnedUrl, (String)"lookupableImplServiceName=accountLookupableImpl"));
    }
}

