/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.app.persistence.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.persistence.jpa.DevHibernateJpaVendorAdapter;
import org.kuali.rice.krad.app.persistence.jpa.RicePersistenceUnitPostProcessor;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;

public class RiceLocalContainerEntityManagerFactoryBean
extends LocalContainerEntityManagerFactoryBean {
    public RiceLocalContainerEntityManagerFactoryBean() {
        throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " can not be constructed without a datasource");
    }

    public RiceLocalContainerEntityManagerFactoryBean(DataSource datasource) {
        this("", datasource);
    }

    public RiceLocalContainerEntityManagerFactoryBean(String prefix, DataSource datasource) {
        if (prefix.equals("")) {
            prefix = "rice";
        }
        prefix = prefix + ".jpa.";
        Config config = ConfigContext.getCurrentContextConfig();
        this.setPersistenceUnitManager(this.preparePersistentUnitManager(config, prefix, datasource));
        this.setPersistenceXmlLocation(this.determineConfigProperty(config, prefix, "PersistenceXmlLocation", "META-INF/persistence.xml"));
        this.setDataSource(datasource);
        this.setPersistenceUnitName(this.determineConfigProperty(config, prefix, "PersistenceUnitName", "rice"));
        this.setJpaDialect((JpaDialect)new HibernateJpaDialect());
        this.setJpaPropertyMap(this.prepareJpaProperties(config, prefix));
        this.setJpaVendorAdapter(this.prepareJpaVendorAdapter(config, prefix));
        RicePersistenceUnitPostProcessor postProcessor = new RicePersistenceUnitPostProcessor();
        postProcessor.setJtaDataSource(datasource);
        this.setPersistenceUnitPostProcessors(new RicePersistenceUnitPostProcessor[]{postProcessor});
    }

    private PersistenceUnitManager preparePersistentUnitManager(Config config, String prefix, DataSource datasource) {
        DefaultPersistenceUnitManager persistenceUnitManager = new DefaultPersistenceUnitManager();
        persistenceUnitManager.setDefaultDataSource(datasource);
        persistenceUnitManager.setPersistenceXmlLocations(new String[]{this.determineConfigProperty(config, prefix, "PersistenceXmlLocation", "META-INF/persistence.xml")});
        persistenceUnitManager.setDefaultPersistenceUnitRootLocation(this.determineConfigProperty(config, prefix, "PersistenceUnitRootLocation", "classpath:"));
        RicePersistenceUnitPostProcessor postProcessor = new RicePersistenceUnitPostProcessor();
        postProcessor.setJtaDataSource(datasource);
        persistenceUnitManager.setPersistenceUnitPostProcessors((PersistenceUnitPostProcessor[])new RicePersistenceUnitPostProcessor[]{postProcessor});
        persistenceUnitManager.afterPropertiesSet();
        return persistenceUnitManager;
    }

    private JpaVendorAdapter prepareJpaVendorAdapter(Config config, String prefix) {
        DevHibernateJpaVendorAdapter jpaVendorAdapter = new DevHibernateJpaVendorAdapter();
        jpaVendorAdapter.setDatabasePlatform(this.determineConfigProperty(config, prefix, "DatabasePlatform", "org.hibernate.dialect.MySQLDialect"));
        jpaVendorAdapter.setGenerateDdl(new Boolean(this.determineConfigProperty(config, prefix, "GenerateDdl", "false")).booleanValue());
        jpaVendorAdapter.setSerializationFilename(this.determineConfigProperty(config, prefix, "SerializationFilename", "/tmp/Ejb3Configuration.out"));
        jpaVendorAdapter.setUseSerialization(new Boolean(this.determineConfigProperty(config, prefix, "UseSerialization", "true")).booleanValue());
        try {
            jpaVendorAdapter.afterPropertiesSet();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jpaVendorAdapter;
    }

    private Map<String, String> prepareJpaProperties(Config config, String prefix) {
        HashMap<String, String> jpaProperties = new HashMap<String, String>();
        jpaProperties.putAll(config.getPropertiesWithPrefix(prefix + "JpaProperties.", true));
        jpaProperties.put("hibernate.show_sql", this.determineConfigProperty(config, prefix, "JpaProperties.hibernate.show_sql", "false"));
        jpaProperties.put("hibernate.format_sql", this.determineConfigProperty(config, prefix, "JpaProperties.hibernate.format_sql", "false"));
        jpaProperties.put("hibernate.use_sql_comments", this.determineConfigProperty(config, prefix, "JpaProperties.hibernate.use_sql_comments", "false"));
        jpaProperties.put("hibernate.transaction.manager_lookup_class", this.determineConfigProperty(config, prefix, "JpaProperties.hibernate.transaction.manager_lookup_class", "org.hibernate.transaction.JOTMTransactionManagerLookup"));
        jpaProperties.put("hibernate.current_session_context_class", this.determineConfigProperty(config, prefix, "JpaProperties.hibernate.current_session_context_class", "org.hibernate.context.JTASessionContext"));
        jpaProperties.put("hibernate.connection.release_mode", this.determineConfigProperty(config, prefix, "JpaProperties.hibernate.connection.release_mode", "auto"));
        jpaProperties.put("hibernate.transaction.flush_before_completion", this.determineConfigProperty(config, prefix, "JpaProperties.hibernate.transaction.flush_before_completion", "true"));
        jpaProperties.put("hibernate.bytecode.use_reflection_optimizer", this.determineConfigProperty(config, prefix, "JpaProperties.hibernate.bytecode.use_reflection_optimizer", "false"));
        jpaProperties.put("hibernate.transaction.auto_close_session", this.determineConfigProperty(config, prefix, "JpaProperties.hibernate.transaction.auto_close_session", "false"));
        jpaProperties.put("hibernate.hbm2ddl.auto", this.determineConfigProperty(config, prefix, "JpaProperties.hibernate.hbm2ddl.auto", ""));
        return jpaProperties;
    }

    private String determineConfigProperty(Config config, String prefix, String key, String defaultValue) {
        String value = config.getProperty(prefix + key);
        if (value == null) {
            value = config.getProperty("rice.jpa." + key);
        }
        return value == null ? defaultValue : value;
    }
}

