/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import javax.persistence.Entity;
import javax.persistence.IdClass;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.AdHocRoutePersonId;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;

@IdClass(value=AdHocRoutePersonId.class)
@Entity
@Table(name="KRNS_ADHOC_RTE_ACTN_RECIP_T")
public class AdHocRoutePerson
extends AdHocRouteRecipient {
    private static final long serialVersionUID = 1L;
    @Transient
    private transient Person person;

    public AdHocRoutePerson() {
        this.setType(PERSON_TYPE);
        try {
            this.person = (Person)KimApiServiceLocator.getPersonService().getPersonImplementationClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setType(Integer type) {
        if (!PERSON_TYPE.equals(type)) {
            throw new IllegalArgumentException("cannot change type to " + type);
        }
        super.setType(type);
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        if (StringUtils.isNotBlank((String)id)) {
            this.person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(id);
            this.setPerson(this.person);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (StringUtils.isNotBlank((String)name) && this.getId() != null && this.person != null && !StringUtils.equals((String)this.person.getName(), (String)name)) {
            this.person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(this.getId());
            this.setPerson(this.person);
        }
    }

    public Person getPerson() {
        if (this.person == null || !StringUtils.equals((String)this.person.getPrincipalName(), (String)this.getId())) {
            this.person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(this.getId());
            if (this.person == null) {
                try {
                    this.person = (Person)KimApiServiceLocator.getPersonService().getPersonImplementationClass().newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
        if (person != null) {
            this.id = person.getPrincipalName();
            this.name = person.getName();
        }
    }
}

