/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import java.io.IOException;
import java.io.InputStream;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.service.KRADServiceLocator;

@Entity
@Table(name="KRNS_ATT_T")
public class Attachment
extends PersistableBusinessObjectBase {
    private static final long serialVersionUID = 402432724949441326L;
    @Id
    @Column(name="NTE_ID")
    private Long noteIdentifier;
    @Column(name="MIME_TYP")
    private String attachmentMimeTypeCode;
    @Column(name="FILE_NM")
    private String attachmentFileName;
    @Column(name="ATT_ID")
    private String attachmentIdentifier;
    @Column(name="FILE_SZ")
    private Long attachmentFileSize;
    @Column(name="ATT_TYP_CD")
    private String attachmentTypeCode;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="NTE_ID")
    private Note note;

    public Long getNoteIdentifier() {
        return this.noteIdentifier;
    }

    public void setNoteIdentifier(Long noteIdentifier) {
        this.noteIdentifier = noteIdentifier;
    }

    public String getAttachmentMimeTypeCode() {
        return this.attachmentMimeTypeCode;
    }

    public void setAttachmentMimeTypeCode(String attachmentMimeTypeCode) {
        this.attachmentMimeTypeCode = attachmentMimeTypeCode;
    }

    public String getAttachmentFileName() {
        return this.attachmentFileName;
    }

    public void setAttachmentFileName(String attachmentFileName) {
        this.attachmentFileName = attachmentFileName;
    }

    public String getAttachmentIdentifier() {
        return this.attachmentIdentifier;
    }

    public void setAttachmentIdentifier(String attachmentIdentifier) {
        this.attachmentIdentifier = attachmentIdentifier;
    }

    public Long getAttachmentFileSize() {
        return this.attachmentFileSize;
    }

    public void setAttachmentFileSize(Long attachmentFileSize) {
        this.attachmentFileSize = attachmentFileSize;
    }

    public String getAttachmentFileSizeWithUnits() {
        if (this.attachmentFileSize != null) {
            return RiceUtilities.getFileSizeUnits((Long)this.attachmentFileSize);
        }
        return "";
    }

    public String getAttachmentTypeCode() {
        return this.attachmentTypeCode;
    }

    public void setAttachmentTypeCode(String attachmentTypeCode) {
        this.attachmentTypeCode = attachmentTypeCode;
    }

    public Note getNote() {
        return this.note;
    }

    public void setNote(Note note) {
        this.note = note;
    }

    public boolean isComplete() {
        return StringUtils.isNotBlank((String)this.attachmentIdentifier) && StringUtils.isNotBlank((String)this.attachmentFileName) && this.attachmentFileSize != null && StringUtils.isNotBlank((String)this.attachmentMimeTypeCode);
    }

    public InputStream getAttachmentContents() throws IOException {
        return KRADServiceLocator.getAttachmentService().retrieveAttachmentContents(this);
    }
}

